﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/account_Types.h>
#include <nn/nn_Common.h>
#include <nn/olsc/srv/util/olsc_MountTypes.h>

namespace nn { namespace olsc { namespace srv { namespace util {

class MountManagerBase;

class MountContext
{
    NN_DISALLOW_COPY(MountContext);
public:
    MountContext() NN_NOEXCEPT = default;
    MountContext(MountContext&& rhs) NN_NOEXCEPT;
    MountContext& operator=(MountContext&& rhs) NN_NOEXCEPT;
    ~MountContext() NN_NOEXCEPT;

    const char* GetMountName() const NN_NOEXCEPT;
    const char* GetRootPath() const NN_NOEXCEPT;

protected:
    MountContext(MountManagerBase* mountManager, MounterId mounter) NN_NOEXCEPT;
    void SetReferenceMode(ReferenceMode referenceMode) NN_NOEXCEPT;

private:
    friend void swap(MountContext& lhs, MountContext& rhs) NN_NOEXCEPT;
    friend class MountManagerBase;

    MountManagerBase* m_MountManager { nullptr };
    MounterId m_Mounter;
    ReferenceMode m_ReferenceMode;
};

using ReadMount = MountContext;
class WriteMount : public ReadMount
{
    NN_DISALLOW_COPY(WriteMount);
public:
    WriteMount() NN_NOEXCEPT = default;
    WriteMount(WriteMount&& rhs) NN_NOEXCEPT;
    WriteMount& operator=(WriteMount&& rhs) NN_NOEXCEPT;

    Result Commit() NN_NOEXCEPT;

private:
    WriteMount(MountManagerBase* mountManager, MounterId mounter) NN_NOEXCEPT;
    friend void swap(WriteMount& lhs, WriteMount& rhs) NN_NOEXCEPT;
    friend class MountManagerBase;

};

void swap(MountContext& lhs, MountContext& rhs) NN_NOEXCEPT;
void swap(WriteMount& lhs, WriteMount& rhs) NN_NOEXCEPT;


}}}}
