﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 *  @file
 *  @brief  ポリシーサーバーに対して発行する API です。
 */

#include <nn/fs/fs_SaveDataTransferForCloudBackUp.h>
#include <nn/olsc/srv/olsc_InternalTypes.h>
#include <nn/util/util_Execution.h>

#include <curl/curl.h>

namespace nn { namespace olsc { namespace srv { namespace transfer {

    /**
    *       @brief      ポリシーサーバに対して、 指定したアプリケーションのポリシー情報を要求します。
    *
    *       @param[out]   pOut   サーバーから返ってきたポリシー情報。
    *       @param[in]   appId  ポリシー情報を取得したいアプリケーションの ID。
    *       @param[in]   version   アプリケーションのリリースバージョン。
    *       @param[in]   curlHandle    内部の通信処理に使用する libcURL のハンドル。
    *       @param[in]   workBuffer    ワークバッファ。
    *       @param[in]   workBufferSize   ワークバッファのサイズ。
    *       @param[in]   pCancelable   中止を検知するためのオブジェクト。
    *
    *       @return     処理結果を返します。
    *
    */
    Result GetPolicyInfo(PolicyInfo* pOut, ApplicationId appId, uint32_t version, CURL* curlHandle, void* workBuffer, size_t workBufferSize, const nn::util::Cancelable* pCancelable) NN_NOEXCEPT;

}}}} // namespace nn::olsc::srv::transfer
