﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <array>
#include <nn/nn_Result.h>
#include <nn/olsc/olsc_Result.h>
#include <nn/olsc/olsc_SystemEventHolder.h>
#include <nn/olsc/olsc_TransferTaskTypes.h>
#include <nn/olsc/olsc_TransferTaskTypesForPrivate.h>
#include <nn/olsc/srv/database/olsc_TransferTaskDatabaseManager.h>
#include <nn/olsc/srv/olsc_InternalTypes.h>
#include <nn/olsc/srv/olsc_SystemEventManager.h>
#include <nn/olsc/srv/olsc_TransferTaskAgent.h>
#include <nn/sf/sf_Buffers.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_NativeHandle.h>

namespace nn { namespace olsc { namespace srv {

class IStopperObject;

class TransferTaskListControllerImpl
{
    using TransferTaskDatabaseManager = database::TransferTaskDatabaseManager;

public:
    TransferTaskListControllerImpl(
        MemoryResource& objectMemoryResource,
        TransferTaskDatabaseManager& ttdm,
        TransferTaskAgent& agent,
        TransferTaskStartEventManager& taskStartEventManager,
        TransferTaskCompleteEventManager& taskCompleteEventManager) NN_NOEXCEPT
        : m_ObjectMemoryResource(objectMemoryResource)
        , m_Ttdm(ttdm)
        , m_Agent(agent)
        , m_TaskStartEventManager(taskStartEventManager)
        , m_TaskCompleteEventManager(taskCompleteEventManager)
    {
    }

    Result GetTransferTaskCount(nn::sf::Out<std::uint32_t> outValue) const NN_NOEXCEPT;
    Result GetTransferTaskInfo(nn::sf::Out<TransferTaskInfo> outValue, TransferTaskId id) const NN_NOEXCEPT;
    Result ListTransferTaskInfo(const nn::sf::OutArray<TransferTaskInfo>& outValue, nn::sf::Out<std::int32_t> outCount, std::int32_t offset) const NN_NOEXCEPT;
    Result DeleteTransferTask(TransferTaskId id) NN_NOEXCEPT;
    Result RaiseTransferTaskPriority(TransferTaskId id) NN_NOEXCEPT;
    Result GetTransferTaskProgress(nn::sf::Out<TransferTaskProgressForIpc> outValue, TransferTaskId id) const NN_NOEXCEPT;
    Result GetTransferTaskLastResult(TransferTaskId id) const NN_NOEXCEPT;
    Result StopNextTransferTaskExecution(sf::Out<sf::SharedPointer<IStopperObject>> outValue) NN_NOEXCEPT;
    Result GetTransferTaskEndEventNativeHandleHolder(sf::Out<sf::SharedPointer<srv::INativeHandleHolder>> outValue) NN_NOEXCEPT;
    Result GetTransferTaskStartEventNativeHandleHolder(sf::Out<sf::SharedPointer<srv::INativeHandleHolder>> outValue) NN_NOEXCEPT;
    Result SuspendTransferTask(TransferTaskId id) NN_NOEXCEPT;

    // デバッグ用
    Result DeleteAllTransferTask() NN_NOEXCEPT;

private:
    MemoryResource& m_ObjectMemoryResource;
    TransferTaskDatabaseManager& m_Ttdm;
    TransferTaskAgent& m_Agent;
    TransferTaskStartEventManager& m_TaskStartEventManager;
    TransferTaskCompleteEventManager& m_TaskCompleteEventManager;

    static const int ListBufferCount = 16;
    mutable std::array<TransferTaskDetailInfo, ListBufferCount> m_ListBuffer;
};

}}} // namespace nn::olsc::srv
