﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/account_Types.h>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/olsc/srv/database/olsc_ErrorHistoryDatabase.h>
#include <nn/olsc/srv/database/olsc_PolicyInfoCache.h>
#include <nn/olsc/srv/olsc_Executor.h>
#include <nn/olsc/srv/olsc_DaemonControllerImpl.h>
#include <nn/olsc/srv/olsc_SaveDataArchiveInfoCacheManager.h>
#include <nn/olsc/srv/olsc_SeriesInfoDatabaseManager.h>
#include <nn/olsc/srv/olsc_TransferTaskAgent.h>
#include <nn/olsc/srv/olsc_TransferTaskFactory.h>
#include <nn/olsc/srv/util/olsc_MountManager.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_ObjectFactory.h>

namespace nn { namespace olsc { namespace srv {

class IRemoteStorageController;
class ITransferTaskListController;

class RemoteStorageControllerImpl;
class TransferTaskListControllerImpl;

class Service
{
    NN_DISALLOW_COPY(Service);

public:
    Service(
        MemoryResource& objectMemoryResource,
        RemoteStorageControllerImpl& remoteStorageController,
        TransferTaskListControllerImpl& transferTaskListController,
        DaemonControllerImpl& daemonController,
        SeriesInfoDatabaseManager& seriesInfoDatabaseManager,
        SaveDataArchiveInfoCacheManager& sdaInfoCacheManager,
        database::ErrorHistoryDatabase& errorHistoryDatabase,
        database::PolicyInfoCache& policyInfoCache,
        TransferTaskAgent& transferTaskAgent,
        Executor& executor) NN_NOEXCEPT;
    // コントローラオープン
    Result GetTransferTaskListController(sf::Out<sf::SharedPointer<ITransferTaskListController>> outValue) NN_NOEXCEPT;
    Result GetRemoteStorageController(sf::Out<sf::SharedPointer<IRemoteStorageController>> outValue) NN_NOEXCEPT;
    Result GetDaemonController(sf::Out<sf::SharedPointer<IDaemonController>> outValue) NN_NOEXCEPT;

    // エラー情報関連
    Result ListTransferTaskErrorInfo(const sf::OutArray<nn::olsc::TransferTaskErrorInfo>& outValue, sf::Out<int32_t> outCount, int32_t offset) const NN_NOEXCEPT;
    Result GetTransferTaskErrorInfoCount(sf::Out<int32_t> outValue) const NN_NOEXCEPT;
    Result RemoveTransferTaskErrorInfo(const account::Uid& uid, ApplicationId appId) NN_NOEXCEPT;

    // ポリシー関連
    Result GetDataTransferPolicy(sf::Out<DataTransferPolicy> outValue, ApplicationId appId) NN_NOEXCEPT;
    Result DeleteDataTransferPolicy(ApplicationId appId) NN_NOEXCEPT;
    Result RequestUpdateDataTransferPolicyAsync(sf::Out<sf::SharedPointer<IAsyncResult>> outValue, ApplicationId appId) NN_NOEXCEPT;

    // 自動 UL 関連
    Result RunAutonomyUploadTransferTaskRegistration(const account::Uid& uid) NN_NOEXCEPT;

    // デバッグ用
    Result DeleteAllTransferTask() NN_NOEXCEPT;
    Result DeleteAllSeriesInfo(const nn::account::Uid& uid) NN_NOEXCEPT;
    Result DeleteAllSdaInfoCache(const nn::account::Uid& uid) NN_NOEXCEPT;
    Result DeleteAllApplicationSetting(const nn::account::Uid& uid) NN_NOEXCEPT;
    Result DeleteAllTransferTaskErrorInfo() NN_NOEXCEPT;
    Result RegisterTransferTaskErrorInfo(const TransferTaskErrorInfo& errorInfo) NN_NOEXCEPT;
    Result AddSaveDataArchiveInfoCache(const account::Uid& uid, const SaveDataArchiveInfo& sda) NN_NOEXCEPT;
    Result DeleteSeriesInfo(const account::Uid& uid, ApplicationId appId) NN_NOEXCEPT;
    Result GetSeriesInfo(const sf::Out<SeriesInfo>& outValue, const account::Uid& uid, ApplicationId appId) NN_NOEXCEPT;

private:
    MemoryResource& m_ObjectMemoryResource;
    RemoteStorageControllerImpl& m_RemoteStorageController;
    TransferTaskListControllerImpl& m_TransferTaskListController;
    DaemonControllerImpl& m_DaemonController;
    TransferTaskAgent& m_TransferTaskAgent;
    Executor& m_Executor;

    SeriesInfoDatabaseManager& m_SeriesInfoDatabaseManager;
    SaveDataArchiveInfoCacheManager& m_SdaInfoCacheManager;
    database::ErrorHistoryDatabase& m_ErrorHistoryDatabase;
    database::PolicyInfoCache& m_PolicyInfoCache;
};

}}} // namespace nn::olsc::srv
