﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/account_Types.h>
#include <nn/nn_ApplicationId.h>
#include <nn/olsc/srv/database/olsc_AutoUploadSettingDatabase.h>
#include <nn/olsc/srv/database/olsc_TransferTaskDatabaseManager.h>
#include <nn/olsc/srv/olsc_SaveDataArchiveInfoCacheManager.h>
#include <nn/olsc/srv/olsc_SeriesInfoDatabaseManager.h>
#include <nn/olsc/srv/olsc_UserReusableObjectManager.h>
#include <nn/olsc/srv/util/olsc_MountManager.h>

namespace nn { namespace olsc { namespace srv {

class AutoUploadSettingManager
{
    NN_DISALLOW_COPY(AutoUploadSettingManager);
public:
    NN_IMPLICIT AutoUploadSettingManager(util::DefaultMountManager& mountManager) NN_NOEXCEPT
        : m_DatabaseManager(mountManager)
    {}

    bool SetGlobalSetting(const account::Uid& uid, bool isEnabled) NN_NOEXCEPT;
    bool GetGlobalSetting(const account::Uid& uid) const NN_NOEXCEPT;

    void SetApplicationSetting(const account::Uid& uid, ApplicationId appId, database::AutoUploadSettingDatabase::ApplicationAutoUploadSetting setting) NN_NOEXCEPT;
    database::AutoUploadSettingDatabase::ApplicationAutoUploadSetting GetApplicationSetting(const account::Uid& uid, ApplicationId appId) const NN_NOEXCEPT;

    void CleanupApplicationSetting(const account::Uid& uid) NN_NOEXCEPT;
private:
    static const int AutoUploadSettingDatabaseCount = 2;

    class DatabaseManager : public UserReusableObjectManager<database::AutoUploadSettingDatabase, AutoUploadSettingDatabaseCount>
    {
        NN_DISALLOW_COPY(DatabaseManager);
    public:
        NN_IMPLICIT DatabaseManager(util::DefaultMountManager& mountManager) NN_NOEXCEPT
            : m_MountManager(mountManager)
        {
        }

        util::WriteMount AcquireWriteMount(const account::Uid& uid) NN_NOEXCEPT
        {
            return m_MountManager.AcquireUserSettingsSaveForWrite(uid);
        }

    protected:
        virtual void EmplaceObject(nn::util::optional<database::AutoUploadSettingDatabase>& toEmplace, const account::Uid& uid) NN_NOEXCEPT NN_OVERRIDE
        {
            toEmplace.emplace(uid, m_MountManager);
        }

    private:
        util::DefaultMountManager& m_MountManager;
    };

    mutable DatabaseManager m_DatabaseManager;
};


}}} // namespace nn::olsc::srv
