﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//-----------------------------------------------------------------------------
// Ocean 開発者限定のアプリケーション用 private-API を定義しているヘッダです。
// このヘッダを一般のアプリケーション開発者に開示・提供してはいけません。
//-----------------------------------------------------------------------------

#include <nn/nn_Macro.h>

namespace nn { namespace oe {


//! @name   Ocean 開発者限定のアプリ用 private-API です。
//! @{

/**
 * @brief   アプリケーションを自発的に終了します。
 *
 * @details
 *  自プログラムを終了し、システムアプレットに対してアプリケーションの自発終了
 *  を示すメッセージを通知します。本 API からはリターンされません。
 *
 *  本 API は nn::oe::EnterExitRequestHandlingSection() による終了要求の
 *  ハンドリング処理区間内であっても強制的に自プログラムを終了します。
 *
 */
NN_NORETURN void ExitApplication() NN_NOEXCEPT;

//! @}


}} // namespace nn::oe

