﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

namespace nn { namespace oe {


//! @name   電源コントロールに関する API
//! @{

/**
 * @brief   システムに対してシャットダウンするように要求します。
 *
 * @details
 *  システムに対して、シャットダウンするように要求を出します。
 *  本 API からはリターンされません。
 *
 *  システム上で、HOME メニューや DevMenu が動作している場合は、
 *  それらに対して、シャットダウンシーケンスを開始するように要求を出します。
 *
 *  システム上に、それらのシステムアプレットが存在していない場合には、
 *  即座にシャットダウンシーケンスを開始します。
 *
 *  本 API は一般のアプリ開発者には公開されません。
 *
 */
NN_NORETURN void RequestToShutdown() NN_NOEXCEPT;

/**
 * @brief   システムに対して再起動するように要求します。
 *
 * @details
 *  システムに対して、再起動するように要求を出します。
 *  本 API からはリターンされません。
 *
 *  システム上で、HOME メニューや DevMenu が動作している場合は、
 *  それらに対して、再起動シーケンスを開始するように要求を出します。
 *
 *  システム上に、それらのシステムアプレットが存在していない場合には、
 *  即座に再起動シーケンスを開始します。
 *
 *  本 API は一般のアプリ開発者には公開されません。
 *
 */
NN_NORETURN void RequestToReboot() NN_NOEXCEPT;

//! @}


}} // namespace nn::oe

