﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   状態遷移に関する API の宣言 ( for OceanKit )
 *
 * @details
 *  このヘッダファイルは、OceanKit に組み込まれるのを想定しており、
 *  ライブラリアプレット開発者が利用する API を定義しています。
 *
 */

#pragma once

#include <nn/oe/oe_OperationStateControlTypes.h>
#include <nn/oe/oe_LibraryAppletControlTypes.h>

namespace nn { namespace oe {

//! @name   ライブラリアプレット連携用 API ( for OceanKit )
//! @{


/**
 * @brief   SDK が表示する UI に期待しているテーマカラーを取得します。
 *
 * @return  SDK が表示する UI に期待しているテーマカラーを示す ThemeColorType 型の列挙子が返ります。
 */
ThemeColorType GetExpectedThemeColor() NN_NOEXCEPT;


/**
 * @brief   SDK が表示する UI に期待するテーマカラーを設定します。(引数チェックなし版)
 *
 * @param[in] themeColorType SDK が表示する UI に期待するテーマカラー
 *
 * @details
 *  SDK が表示する UI に期待するテーマカラーを、プリセット値である ThemeColorType 型の列挙子から設定します。@n
 *  指定したプリセットによってどのような色合いになるかは、本体設定の「テーマ」から
 *  ThemeColorType 型の列挙子と同じ色を指定することで確認できます。@n
 *  本 API を呼んでも、すべての SDK が表示する UI が期待したテーマカラーを反映するわけではありません。@n
 *  例えば Mii 作成・編集アプレットではテーマカラーは反映されません。@n
 *  本 API を呼ばなかったときのデフォルトのプリセット値は ThemeColorType_User です。
 *  非公開カラーを使用するために引数チェックをおこなわないバージョンです。
 */
void SetExpectedThemeColorForSystem( ThemeColorType themeColorType ) NN_NOEXCEPT;


/**
 * @brief   ThemeColorType_Default が意味しているテーマカラーを取得します。
 *
 * @return  ThemeColorType_Default が意味しているテーマカラー ThemeColorType 型の列挙子が返ります。@n
 *          GetExpectedThemeColor() 関数の返り値が ThemeColorType_Default であった場合、
 *          本関数を呼んで具体的な ThemeColorType を取得してください。
 */
ThemeColorType GetDefaultThemeColor() NN_NOEXCEPT;


//! @}

}} // namespace nn::oe

