﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief 非公開の性能の定義。
 */

namespace nn { namespace oe {

/**
 * CPU 1020.0 MHz, GPU 307.2 MHz, EMC 1065.6 Mhz。@n
 * 現在サポートしていません。
 *
 * @deprecated 本性能は 5.0.0NUP 以降の製品および NX Addon 5.3.0 以降の開発機で使用できない性能です。
 */
NN_DEPRECATED const PerformanceConfiguration PerformanceConfiguration_Cpu1020MhzGpu307MhzEmc1065Mhz = 0x00020005;

/**
 * CPU 1020.0 MHz, GPU 384.0 MHz, EMC 1065.6 Mhz。@n
 * 電池消費の大きい性能です。@n
 * 現在サポートしていません。
 *
 * @deprecated 本性能は 5.0.0NUP 以降の製品および NX Addon 5.3.0 以降の開発機で使用できない性能です。
 */
NN_DEPRECATED const PerformanceConfiguration PerformanceConfiguration_Cpu1020MhzGpu384MhzEmc1065Mhz = 0x00020006;

/**
 * CPU 1020.0 MHz, GPU 460.8 MHz, EMC 1600.0 Mhz。@n
 * 電池消費の大きい性能です。@n
 * 全ての性能モードで使用可能です。
 */
const PerformanceConfiguration PerformanceConfiguration_Cpu1020MhzGpu460MhzEmc1600Mhz = 0x92220007;

/**
 * CPU 1020.0 MHz, GPU 307.2 MHz, EMC 1600.0 MHz。@n
 * 全ての性能モードで使用可能です。
 *
 * @deprecated 本性能はローンチ時の製品および開発機で使用できない性能になることが予定されています。@n
 * @ref nn::oe::PerformanceConfiguration_Cpu1020MhzGpu307MhzEmc1331Mhz もしくは @ref nn::oe::PerformanceConfiguration_Cpu1020MhzGpu384MhzEmc1331Mhz を使用してください。
 */
NN_DEPRECATED const PerformanceConfiguration PerformanceConfiguration_Cpu1020MhzGpu307MhzEmc1600Mhz = 0x00020001;

/**
 * CPU 1020.0 MHz, GPU 384.0 MHz, EMC 1600.0 MHz。@n
 * 電池消費量の大きい性能です。@n
 * 全ての性能モードで使用可能です。
 *
 * @deprecated 本性能はローンチ時の製品および開発機で使用できない性能になることが予定されています。@n
 * @ref nn::oe::PerformanceConfiguration_Cpu1020MhzGpu384MhzEmc1331Mhz を使用してください。
 */
NN_DEPRECATED const PerformanceConfiguration PerformanceConfiguration_Cpu1020MhzGpu384MhzEmc1600Mhz = 0x00010000;

}} // namespace nn::oe
