﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   常時動画撮影機能に関する開発専用 API の宣言 (private)
 *
 * @details
 *  本ヘッダに含まれる API は製品機では使用できません。
 *
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>

namespace nn { namespace oe {

//! @name   アプリケーションの常時動画撮影機能に関する API (private)
//! @{

/**
    @brief (デバッグ専用)(暫定) 直前のプレイ動画の録画を保存します。

    @param[in] maxTime 保存される動画の最長時間を指定します。0 を指定した場合は、可能な限り長く保存します。
    @return 処理の結果を返します。

    @details
     この関数は試作版であり、予告なく削除されたり仕様が変更されたりする可能性があります。
     この関数は開発専用であり、製品機で呼んだ場合は何もせずに処理が返ります。

     現在から遡って最大 maxTime 分だけプレイ動画を保存します。実際に保存される動画の長さは、バッファサイズなど実装に依存します。
     maxTime が 0 のとき、可能な限り長い時間の動画を保存します。

     本関数は保存処理が完了すると返ります。

     現実装における本関数は、成功が返った場合にも必ずしも動画が保存に成功するとは限りませんので注意してください。
     確認が必要な場合には、画面の表示によって成功を確認してください。
     この挙動は今後改善される予定です。

     別のプレイ動画の保存などが実行中だった場合、先に実行されていた処理は強制中断されます。
*/
Result SaveGamePlayRecordingForDebug(TimeSpan maxTime = 0) NN_NOEXCEPT;

//! @}

//-----------------------------------------------------------------------------

}} // namespace nn::oe

