﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   アプリケーション自身の制御に関する private-API の宣言
 *
 */

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace oe {

//-----------------------------------------------------------------------------
/**
 * @brief   プログラムの再起動をシステムに要求します。
 *
 * @details
 *  自プログラムの再起動をシステムに要求します。
 *  本 API は要求を出した後にすぐにリターンします。
 *
 *  システムはプログラムの再起動要求を受理すると、呼出元プログラムに対して
 *  ユーザ操作によるプログラム終了と同様の終了手続きを行なってから、
 *  同プログラムを再び起動するというステップを踏みます。
 *
 *  そのため、例えば事前に nn::oe::EnterExitRequestHandlingSection() を使って
 *  終了要求ハンドリングが有効になっている場合には、本 API を使用した場合でも
 *  当該仕様に準じた終了手順を踏んでプログラムを終了する必要があります。
 *
 */
void RequestToRelaunchApplication() NN_NOEXCEPT;


//! @}

//-----------------------------------------------------------------------------

}} // namespace nn::oe

