﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace ntc { namespace service {

    /**
     * @biref   時刻補正サービスの IPC サーバーを起動します
     * @details
     *  - このサービスは socket, ssl, libcurl, nifm, time を利用します。
     *  - socket の並列利用数は 1 スレッドです。
     *  - nn::time::InitializeForSystem() を使って Time ライブラリが初期化されている必要があります。
     *
     *  socket, ssl, libcurl, nifm で必要な権限以外に、以下の権限が追加で必要です。
     *  - time:crt (Server)
     *  - time:s (Client)
     */
    void StartServer() NN_NOEXCEPT;

    /**
     * @brief   サービスの IPC サーバーを終了します
     */
    void StopServer() NN_NOEXCEPT;

}}} // nn::ntc::service
