﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/time.h>

namespace nn { namespace ntc { namespace detail { namespace service {

/**
 * @brief   ネットワーク時計補正のレポートを送ります
 * @param[in]   oldContext  補正前のネットワーク時計のコンテキスト
 * @param[in]   serverTime  サーバから取得した時刻
 * @param[in]   timeOfGettingServerPosixTime  サーバからの時刻取得にかかった時間
 * @details
 *  ネットワーク経由でのネットワーク時計の補正時に呼び出します。
 */
void SendCorrectionSystemReport(
    const nn::time::SystemClockContext& oldContext,
    const nn::time::PosixTime& serverTime,
    const nn::TimeSpan& timeOfGettingServerPosixTime) NN_NOEXCEPT;

/**
 * @brief   RTCリセットのレポートを送ります
 * @details
 *  システム起動時、RTCリセットが検知されていれば一度だけ呼び出します。
 */
void SendRtcResetSystemReport() NN_NOEXCEPT;

}}}} // nn::ntc::detail::service
