﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ntc/detail/service/ntc_Common.h>

#include <nn/ntc/detail/service/ntc_AutonomicEnsureNetworkClockAvailabilityThread.h>
#include <nn/ntc/detail/service/ntc_IEnsureNetworkClockAvailabilityService.sfdl.h>

#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/lmem/lmem_ExpHeap.h>

namespace nn { namespace ntc { namespace detail { namespace service {

template<size_t Size>
class SfExpHeapAllocator
{
private:
    char m_Buffer[Size];
    nn::sf::ExpHeapAllocator m_ExpHeapAllocator;

public:
    explicit SfExpHeapAllocator() NN_NOEXCEPT
    {
        m_ExpHeapAllocator.Attach(nn::lmem::CreateExpHeap(m_Buffer, Size, nn::lmem::CreationOption_NoOption));
    }

    nn::sf::ExpHeapAllocator* GetBase() NN_NOEXCEPT
    {
        return &m_ExpHeapAllocator;
    }
};

class StaticService
{
public:
    explicit StaticService(nn::ntc::detail::service::AutonomicEnsureNetworkClockAvailabilityThread* pAutonomicEnsureNetworkClockAvailabilityThread) NN_NOEXCEPT;

    //!< 非同期用のサービス取得
    nn::Result GetEnsureNetworkClockAvailabilityService(
        nn::sf::Out<nn::sf::SharedPointer<IEnsureNetworkClockAvailabilityService>> outService,
        int32_t ensureNetworkClockAvailabilityMode,
        const nn::nifm::ClientId& nifmClientId
        ) NN_NOEXCEPT;

    Result SuspendAutonomicTimeCorrection() NN_NOEXCEPT;
    Result ResumeAutonomicTimeCorrection() NN_NOEXCEPT;

private:
    SfExpHeapAllocator<4 * 1024> m_SfExpHeapAllocator;
    nn::ntc::detail::service::AutonomicEnsureNetworkClockAvailabilityThread* m_pAutonomicEnsureNetworkClockAvailabilityThread;
};

}}}} // nn::ntc::detail::service
