﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/os.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_StringUtil.h>
#include <nn/util/util_ScopeExit.h>

#include <nn/nifm.h>
#include <nn/nifm/nifm_ApiClientManagement.h>
#include <nn/nifm/nifm_NetworkConnection.h>
#include <nn/time.h>
#include <nn/time/time_ResultCorrection.h>
#include <nn/time/time_ResultPrivate.h>
#include <nn/time/time_StandardSteadyClock.h>
#include <nn/time/detail/time_Log.h>

#include <nn/ntc/ntc_EnsureNetworkClockAvailabilityMode.h>

#include <mutex>
#include <atomic>
#include <algorithm>

// TIME の構造化ログを拝借
#define NN_DETAIL_NTC_SERVER_LOG(...) NN_DETAIL_TIME_INFO("[NTCSRV] " __VA_ARGS__)

