﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief nn::nsd の型定義
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_StringUtil.h>

namespace nn { namespace nsd {

    /**
     * @brief FQDN を表す型
     * @details
     */
    struct Fqdn
    {
        static const size_t Size = 256; //!< FQDN 文字列のサイズ
        char value[Size]; //!< FQDN を表す文字列

        friend bool operator == (const Fqdn& lhs, const Fqdn& rhs) NN_NOEXCEPT
        {
            return nn::util::Strncmp(lhs.value, rhs.value, lhs.Size) == 0;
        }

        friend bool operator != (const Fqdn& lhs, const Fqdn& rhs) NN_NOEXCEPT
        {
            return !(lhs == rhs);
        }
    };

    /**
     * @privatedocbegin{selectable_OceanKit}
     * @brief サービスディスカバリの設定名を表す型
     * @details
     * @privatedocend
     */
    struct SettingName
    {
        static const size_t Size = 256; //!< 設定名の文字列のサイズ
        char value[Size]; //!< 設定名を表す文字列
    };

    /**
     * @privatedocbegin{selectable_OceanKit}
     * @brief パスコードを表す型
     * @details
     *  パスコードは、サービスディスカバリの設定データをサーバーに問い合わせる際に必要になります。
     * @privatedocend
     */
    struct PassCode
    {
        static const size_t Size = 32; //!< パスコード文字列のサイズ
        char value[Size]; //!< パスコードを表す文字列
    };

    /**
     * @privatedocbegin{selectable_OceanKit}
     * @brief 環境識別子を表す型
     * @details
     * @privatedocend
     */
    struct EnvironmentIdentifier
    {
        static const size_t Size = 8; //!< 環境識別子文字列のサイズ
        char value[Size]; //!< 環境識別子を表す文字列

        friend bool operator == (const EnvironmentIdentifier& lhs, const EnvironmentIdentifier& rhs) NN_NOEXCEPT
        {
            return nn::util::Strncmp(lhs.value, rhs.value, lhs.Size) == 0;
        }

        friend bool operator != (const EnvironmentIdentifier& lhs, const EnvironmentIdentifier& rhs) NN_NOEXCEPT
        {
            return !(lhs == rhs);
        }
    };

}} // nn::nsd
