﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief 基幹サービス向け設定の型定義
 */

#pragma once

#include <nn/nsd/nsd_Common.h>
#include <nn/util/util_StringUtil.h>

namespace nn { namespace nsd {
    /**
     * @brief   NAS を利用するサービスの名称を表す型
     */
    struct NasServiceName
    {
        static const size_t Size = 16;
        char value[Size];

        friend bool operator == (const NasServiceName& lhs, const NasServiceName& rhs) NN_NOEXCEPT
        {
            return nn::util::Strncmp(lhs.value, rhs.value, NasServiceName::Size) == 0;
        }

        friend bool operator != (const NasServiceName& lhs, const NasServiceName& rhs) NN_NOEXCEPT
        {
            return !(lhs == rhs);
        }
    };

    const NasServiceName NasServiceNameOfNxAccount = {"NxAccount"}; //!< NX Account のサービス名称
    const NasServiceName NasServiceNameOfNxShop = {"NxShop"}; //!< NX Shop のサービス名称
    const NasServiceName NasServiceNameOfNxFriends = {"NxFriends"}; //!< NX Friends のサービス名称
    const NasServiceName NasServiceNameOfNxELicense = {"NxELicense"}; //!< NX ELicense のサービス名称

    /**
     * @brief   NAS サービス1つ分の設定を表す型
     */
    struct NasServiceSetting
    {
        /**
         * @brief リダイレクトURIを表す構造体
         */
        struct RedirectUri
        {
            static const size_t Size = 256; //!< リダイレクトURIの文字列サイズ
            char value[Size]; //!< リダイレクトURIを表す文字列
        };

        uint64_t clientId; //!< クライアントID
        RedirectUri redirectUri; //!< リダイレクトURI
    };

}} // nn::nsd
