﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief テスト向けの nn::nsd API (非公開)
 */

#pragma once

#include <nn/nsd/nsd_Common.h>
#include <nn/nsd/nsd_TypesPrivate.h>
#include <nn/nsd/nsd_DeleteMode.h>

namespace nn { namespace nsd {

//! @name テスト向け API (非公開)
//! @{

#if defined(NN_BUILD_CONFIG_OS_WIN)

    /**
     * @brief サービスディスカバリの設定を td1 サーバー環境へ切り替えます(Windows 限定 API)
     * @details
     *  本関数は現時点で Windows 向けにしか定義していません。@n
     *  テストの Main 関数の最初や、各テストの最初に呼ばれることを想定しています。
     *
     *  各テスト実行中に切り替えると、サーバー環境が混じってテストされる可能性があるのでおやめください。
     */
    void SetTd1EnvironmentForTest() NN_NOEXCEPT;

#endif // NN_BUILD_CONFIG_OS_WIN

    /**
     * @brief サービスディスカバリの設定を取得します。
     * @details
     *   nsd:a 権限が必要です。@n
     *   今現在有効になっている設定を取得します。@n
     *   サービスディスカバリのプロセス起動時にファイルシステムから
     *   読み出されたキャッシュを返すことに注意してください。
     */
     void GetCurrentSaveData( SaveData* pSaveData ) NN_NOEXCEPT;

    /**
     * @brief 設定削除(nn::Result 付き)
     * @details
     *   nsd:a 権限が必要です。@n
     *   テスト向けに、nn::nsd::DeleteSettings() が nn::Result を返すようにした関数です。
     */
    nn::Result DeleteSettingsEx(DeleteMode deleteMode) NN_NOEXCEPT;

    /**
     * @brief ファイルシステムから nn::nsd::SaveData を直接読み込みます
     * @details
     *   nsd:a 権限が必要です。
     *
     *   Release ビルドでは常に nn::nsd::ResultNotImplemented() を返します。
     */
    nn::Result WriteSaveDataToFsForTest(const nn::nsd::SaveData& saveData) NN_NOEXCEPT;

    /**
     * @brief ファイルシステムへ nn::nsd::SaveData を直接書き込みます。
     * @details
     *   nsd:a 権限が必要です。
     *
     *   Release ビルドでは常に nn::nsd::ResultNotImplemented() を返します。
     */
    nn::Result ReadSaveDataFromFsForTest(nn::nsd::SaveData* pOut) NN_NOEXCEPT;

    /**
     * @brief ファイルシステムの nn::nsd::SaveData を削除します。
     * @details
     *   nsd:a 権限が必要です。
     *
     *   Release ビルドでは常に nn::nsd::ResultNotImplemented() を返します。
     */
    nn::Result DeleteSaveDataOfFsForTest() NN_NOEXCEPT;

    /**
     * @brief   環境識別子の変更を伴う設定インポートを可能にします。
     * @details
     *  設定は永続化され、本体のシャットダウンをまたいでも引き継がれます。
     */
    void EnableChangeEnvironmentIdentifier() NN_NOEXCEPT;

    /**
     * @brief   環境識別子の変更を伴う設定インポートが不能になっているかどうかを取得します。
     */
    bool IsChangeEnvironmentIdentifierDisabled() NN_NOEXCEPT;

//! @}

}} // nn::nsd
