﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/nsd/nsd_Common.h>
#include <nn/nsd/nsd_Types.h>
#include <nn/nsd/nsd_TypesPrivate.h>
#include <nn/nsd/nsd_DeleteMode.h>
#include <nn/nsd/nsd_ImportMode.h>
#include <nn/nsd/nsd_BackboneSettingsTypes.h>

#include <limits>

namespace nn { namespace nsd { namespace detail {

nn::Result Initialize() NN_NOEXCEPT;

bool IsInitialized() NN_NOEXCEPT;

nn::Result Finalize() NN_NOEXCEPT;


namespace ipc {
nn::Result GetSettingName(nn::nsd::SettingName* pOut) NN_NOEXCEPT;

nn::Result GetEnvironmentIdentifier(nn::nsd::EnvironmentIdentifier* pOut) NN_NOEXCEPT;

nn::Result GetDeviceId(nn::nsd::DeviceId* pOut) NN_NOEXCEPT;

nn::Result DeleteSettings(const nn::nsd::DeleteMode deleteMode) NN_NOEXCEPT;

nn::Result ImportSettings(const void* pBuffer, size_t bufferSize, void* pWorkBuffer, size_t workBufferSize, const ImportMode saveMode) NN_NOEXCEPT;

nn::Result Resolve(Fqdn* pOut, const nn::nsd::Fqdn& fqdn) NN_NOEXCEPT;

nn::Result ResolveEx(nn::Result* pInnerResult, Fqdn* pOut, const nn::nsd::Fqdn& fqdn) NN_NOEXCEPT;

nn::Result GetNasServiceSetting(nn::nsd::NasServiceSetting* pOutNasServiceSetting, const nn::nsd::NasServiceName& nasServiceName) NN_NOEXCEPT;

nn::Result GetNasServiceSettingEx(nn::Result* pInnerResult, nn::nsd::NasServiceSetting* pOutNasServiceSetting, const nn::nsd::NasServiceName& nasServiceName) NN_NOEXCEPT;

nn::Result GetNasRequestFqdn(nn::nsd::Fqdn* pOut) NN_NOEXCEPT;

nn::Result GetNasRequestFqdnEx(nn::Result* pInnerResult, nn::nsd::Fqdn* pOut) NN_NOEXCEPT;

nn::Result GetNasApiFqdn(nn::nsd::Fqdn* pOut) NN_NOEXCEPT;

nn::Result GetNasApiFqdnEx(nn::Result* pInnerResult, nn::nsd::Fqdn* pOut) NN_NOEXCEPT;

nn::Result GetCurrentSetting(nn::nsd::SaveData* pOut) NN_NOEXCEPT;

nn::Result WriteSaveDataToFsForTest(const nn::nsd::SaveData& saveData) NN_NOEXCEPT;

nn::Result ReadSaveDataFromFsForTest(nn::nsd::SaveData* pOut) NN_NOEXCEPT;

nn::Result DeleteSaveDataOfFsForTest() NN_NOEXCEPT;

nn::Result SetChangeEnvironmentIdentifierDisabled(bool isDisabled) NN_NOEXCEPT;

nn::Result IsChangeEnvironmentIdentifierDisabled(bool* pOutIsDisabled) NN_NOEXCEPT;
} // nn::nsd::detail::ipc

}}} // nn::nsd::detail
