﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nsd/nsd_TypesPrivate.h>

namespace nn { namespace nsd { namespace detail {

    /**
     * @brief   基幹サービス向けの ROM 埋め込み設定の取得
     * @param[in]   environmentIdentifier   環境識別子
     * @return      埋め込みの設定
     * @pre
     *  - environmentIdentifier == nn::nsd::EnvironmentIdentifierOfProductDevice || environmentIdentifier == nn::nsd::EnvironmentIdentifierOfNotProductDevice
     * @details
     *  サービスディスカバリの設定をダウンロードしたことがないときのデフォルト設定に利用します
     *  lp1, dd1 のどちらか環境識別子にしか利用できません。
     */
    const BackboneSettings& GetBuiltinBackboneSettings(const EnvironmentIdentifier& environmentIdentifier) NN_NOEXCEPT;

    //!< dd1 環境の NAS リクエスト向け FQDN 取得
    const Fqdn& GetDd1NasRequestFqdn() NN_NOEXCEPT;

    //!< dd1 環境の NAS API 向け FQDN 取得
    const Fqdn& GetDd1NasApiFqdn() NN_NOEXCEPT;

    //!< lp1 環境の NAS リクエスト向け FQDN 取得
    const Fqdn& GetLp1NasRequestFqdn() NN_NOEXCEPT;

    //!< lp1 環境の NAS API 向け FQDN 取得
    const Fqdn& GetLp1NasApiFqdn() NN_NOEXCEPT;

}}} // nn::nsd::detail
