﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/account/account_Types.h>
#include <nn/fs/fs_SystemSaveData.h>
#include <nn/ns/ns_UserResourceManagementTypes.h>
#include <nn/sf/sf_ExpHeapAllocator.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_Out.h>

namespace nn { namespace ns { namespace detail {

class IProgressMonitorForDeleteUserSaveDataAll;

}}} // ~namespace nn::ns::srv::detail

namespace nn { namespace ns { namespace srv {

class UserResourceManagerImpl
{
private:
    static const size_t HeapSize = 1024;

    class Allocator
        : public sf::ExpHeapAllocator
    {
    private:
        typedef std::aligned_storage<HeapSize>::type StorageType;
        StorageType m_Buffer;
        lmem::HeapHandle m_HeapHandle;

    public:
        typedef sf::ExpHeapAllocator::Policy Policy;

        Allocator() NN_NOEXCEPT
        {
            m_HeapHandle = lmem::CreateExpHeap(&m_Buffer, sizeof(m_Buffer), 0);
            this->Attach(m_HeapHandle);
        }
        ~Allocator() NN_NOEXCEPT
        {
            lmem::DestroyExpHeap(m_HeapHandle);
        }
    };
    typedef sf::ObjectFactory<typename Allocator::Policy> FactoryType;
    Allocator m_ObjectAllocator;

public:
    Result CalculateUserSaveDataStatistics(sf::Out<ns::UserSaveDataStatistics> pOut, const account::Uid& uid) NN_NOEXCEPT;
    Result DeleteUserSaveDataAll(sf::Out<sf::SharedPointer<ns::detail::IProgressMonitorForDeleteUserSaveDataAll>> pOut, const account::Uid& uid) NN_NOEXCEPT;
    Result DeleteUserSystemSaveData(const account::Uid& uid, fs::SystemSaveDataId sysSaveId) NN_NOEXCEPT;
    Result UnregisterNetworkServiceAccount(const account::Uid& uid) NN_NOEXCEPT;
    Result UnregisterNetworkServiceAccountWithUserSaveDataDeletion(const account::Uid& uid) NN_NOEXCEPT;
};

}}} // ~namespace nn::ns::srv
