﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_Optional.h>
#include <nn/ns/srv/ns_RequestServer.h>
#include <nn/ns/srv/ns_SystemUpdateApplyManager.h>
#include <nn/nim/nim_NetworkInstallManagerApi.h>

namespace nn { namespace ns { namespace srv {

    class SystemUpdateRequestList : public RequestList
    {
    public:
        explicit SystemUpdateRequestList(SystemUpdateApplyManager* applyManager) NN_NOEXCEPT : m_SystemUpdateApplyManager(applyManager), m_IsCheckRequested(), m_IsExFatDriverRequired() {}
        Result RequestCheckLatest() NN_NOEXCEPT;

        virtual bool NeedsProcess(ProcessType type) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result Prepare(ProcessType type) NN_NOEXCEPT NN_OVERRIDE;
        virtual bool HasPreparedRequest() NN_NOEXCEPT NN_OVERRIDE;
        virtual void WaitAlongWith(os::SystemEvent** events, int numEvents) NN_NOEXCEPT NN_OVERRIDE;

        virtual bool HandleDone() NN_NOEXCEPT NN_OVERRIDE;
        virtual void Cleanup() NN_NOEXCEPT NN_OVERRIDE;

        void SetExFatDriverRequired(bool isRequired) NN_NOEXCEPT
        {
            m_IsExFatDriverRequired = isRequired;
        }

    private:
        Result PrepareMetaRequestIfNeeded() NN_NOEXCEPT;
        Result PrepareTaskRequestIfNeeded() NN_NOEXCEPT;
        bool IsMetaRequestIndex(int index) NN_NOEXCEPT
        {
            return index == 0 && m_MetaRequest;
        }
        Result HandleMetaRequestDone() NN_NOEXCEPT;
        Result HandleTaskRequestDone() NN_NOEXCEPT;

        SystemUpdateApplyManager* m_SystemUpdateApplyManager;
        bool m_IsCheckRequested;
        bool m_IsExFatDriverRequired;
        util::optional<nim::AsyncContentMetaKey> m_MetaRequest;
        util::optional<nim::AsyncResult> m_TaskRequest;
    };
}}}
