﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_PackageSystemUpdateTask.h>
#include <nn/nim/nim_LocalCommunicationReceiveSystemUpdateTaskId.h>
#include <nn/nim/nim_SystemUpdateTaskId.h>
#include <nn/ns/srv/ns_ExFatDriverManager.h>
#include <nn/ns/srv/ns_SystemReportManager.h>

namespace nn { namespace ns { namespace srv {

class SystemUpdateApplyManager
{
public:
    SystemUpdateApplyManager() NN_NOEXCEPT : m_ApplyMutex(false) {}
    void Initialize(SystemReportManager* reportManager, ExFatDriverManager* exFatDriverManager) NN_NOEXCEPT;

    Result ApplyTask(nim::SystemUpdateTaskId id, bool updateBootImages, bool isRebootless) NN_NOEXCEPT;
    Result ApplyReceivedTask(nim::LocalCommunicationReceiveSystemUpdateTaskId id) NN_NOEXCEPT;
    Result ApplyPackageTask(ncm::PackageSystemUpdateTask* task) NN_NOEXCEPT;
    Result NotifyDownloadTaskCompleted(nim::SystemUpdateTaskId id) NN_NOEXCEPT;

private:
    Result ReportThroughput(nim::SystemUpdateTaskId id) NN_NOEXCEPT;

    Result ReportSystemUpdate(nim::SystemUpdateTaskId id, bool isRebootless) NN_NOEXCEPT;
    Result ReportReceivedSystemUpdate(nim::LocalCommunicationReceiveSystemUpdateTaskId id) NN_NOEXCEPT;
    Result ReportPackageSystemUpdate(ncm::PackageSystemUpdateTask* task)  NN_NOEXCEPT;
    Result ReportSystemUpdateCommon(SystemUpdateType type, uint64_t destinationSystemUpdateMetaId, uint32_t destinationSystemUpdateMetaVersion, bool isRebootless) NN_NOEXCEPT;

    SystemReportManager* m_SystemReportManager;
    ExFatDriverManager* m_ExFatDriverManager;
    os::Mutex m_ApplyMutex;
};
}}}
