﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/util/util_Span.h>
#include <nn/account/account_Types.h>
#include <nn/es/es_RightsTypes.h>

#include <nn/ns/ns_ApplicationRightsTypes.h>

namespace nn { namespace ns { namespace srv {

class IntegratedContentManager;
class ApplicationRecordDatabase;

class RightsEnvironmentManager
{
public:

    Result CreateRightsEnvironment(RightsEnvironmentHandle* pOut) NN_NOEXCEPT;
    void DestroyRightsEnvironment(RightsEnvironmentHandle handle) NN_NOEXCEPT;

    Result AddTargetApplicationToRightsEnvironment(RightsEnvironmentHandle handle, ncm::ApplicationId applicationId, const IntegratedContentManager* pIntegratedContentManager, ApplicationRecordDatabase* pApplicationRecordDatabase) NN_NOEXCEPT;
    Result SetUsersToRightsEnvironment(RightsEnvironmentHandle handle, bool anyUser, util::Span<const account::Uid> uids) NN_NOEXCEPT;

    Result ActivateRightsEnvironment(RightsEnvironmentHandle handle) NN_NOEXCEPT;
    void DeactivateRightsEnvironment(RightsEnvironmentHandle handle) NN_NOEXCEPT;

    Result GetRightsEnvironmentStatus(RightsEnvironmentStatus* pOut, RightsEnvironmentHandle handle) NN_NOEXCEPT;
    int ListActivatedRights(es::RightsId* outList, int listCount, RightsEnvironmentHandle handle) NN_NOEXCEPT;
    ApplicationRightsStatus GetApplicationRightsStatus(RightsEnvironmentHandle handle) NN_NOEXCEPT;
};

}}}
