﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ns/detail/ns_IAsync.sfdl.h>

namespace nn { namespace ns { namespace srv {
    class ApplicationRecordDatabase;

    class PreInstallManager
    {
    NN_DISALLOW_COPY(PreInstallManager);
    NN_DISALLOW_MOVE(PreInstallManager);
    public:
        explicit PreInstallManager(ApplicationRecordDatabase* pRecordDb) NN_NOEXCEPT : m_pRecordDb(pRecordDb) {}
        Result RequestCleanupAllPreInstalledApplications(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT;
        Result RequestCleanupPreInstalledApplication(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<ns::detail::IAsyncResult>> outAsync, ncm::ApplicationId id) NN_NOEXCEPT;
    private:
        ApplicationRecordDatabase* m_pRecordDb;
    };
}}}
