﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ns/ns_GameCardRegistrationApi.h>

namespace nn { namespace ns { namespace srv {
    class GameCardManager;

    class GameCardRegistrationManager
    {
    public:
        NN_IMPLICIT GameCardRegistrationManager(GameCardManager* gameCardManager) NN_NOEXCEPT : m_GameCardManager(gameCardManager) {}
        Result RequestCheckGameCardRegistration(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<ns::detail::IAsyncResult>> outAsync, ncm::ApplicationId appId) NN_NOEXCEPT;
        Result RequestGameCardRegistrationGoldPoint(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<ns::detail::IAsyncValue>> outAsync, const account::Uid& uid, ncm::ApplicationId appId) NN_NOEXCEPT;
        Result RequestRegisterGameCard(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<ns::detail::IAsyncResult>> outAsync, const account::Uid& uid, ncm::ApplicationId appId, int goldPoint) NN_NOEXCEPT;
    private:
        GameCardManager* m_GameCardManager;
    };
}}}
