﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_StaticAssert.h>
#include <nn/ncm/ncm_ApplicationInfo.h>
#include <nn/nim/nim_NetworkInstallManagerApi.h>
#include <nn/ns/ns_ApplicationVersionSystemApi.h>
#include <nn/ns/srv/ns_ApplicationRecordDatabase.h>
#include <nn/ns/srv/ns_BlackListManager.h>
#include <nn/ns/srv/ns_IntegratedContentManager.h>
#include <nn/ns/srv/ns_RequestServer.h>
#include <nn/ns/srv/ns_OsUtil.h>
#include <nn/ns/srv/ns_VersionManagementDatabase.h>
#include <nn/os/os_Mutex.h>
#include <nn/sf/sf_Types.h>

namespace nn { namespace ns { namespace srv {
    class ApplicationVersionManager
    {
    public:
        ApplicationVersionManager() NN_NOEXCEPT : m_VersionEntryBufferLock(false) {}
        Result  Initialize(ApplicationRecordDatabase* record, BlackListManager* blacklist) NN_NOEXCEPT;
        void    Finalize() NN_NOEXCEPT;
        Result  UpdateVersionList(const char* versionListBuffer, size_t versionListBufferSize) NN_NOEXCEPT;
        Result  UpdateVersionList(nim::AsyncData* asyncData, char* workBuffer, size_t workBufferSize) NN_NOEXCEPT;
        Result  PushLaunchVersion(ncm::ApplicationId id, uint32_t version) NN_NOEXCEPT;
        Result  ListRequiredVersion(int* outCount, RequiredVersionEntry* outValue, int count) NN_NOEXCEPT;
        Result  ListVersionList(int* outCount, VersionListEntry* outValue, int count) NN_NOEXCEPT;
        Result  CheckApplicationLaunchVersion(ncm::ApplicationId applicationId, ncm::PatchId patchId, uint32_t version, uint32_t requiredSystemVersion, uint32_t requiredApplicationVersion) NN_NOEXCEPT;
        Result  RequestVersionListData(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<ns::detail::IAsyncValue>> outAsync, RequestServer::ManagedStop&& stopper) NN_NOEXCEPT;
        Result  GetLaunchRequiredVersion(nn::sf::Out<std::uint32_t> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        Result  UpgradeLaunchRequiredVersion(nn::ncm::ApplicationId id, std::uint32_t launchRequiredVersion) NN_NOEXCEPT;
        Result  PerformAutoUpdate() NN_NOEXCEPT;

        static const int BufferSize = 256 * 1024; // 256 KB, VersionListEntry/RequiredVersionEntry が 16K 個入る計算
    private:
        template<typename InputStreamType>
        Result  UpdateVersionList(InputStreamType& inputStream) NN_NOEXCEPT;

        nn::os::Mutex               m_VersionEntryBufferLock;
        Bit8                        m_VersionEntryBuffer[BufferSize];
        ApplicationRecordDatabase*  m_Record;
        BlackListManager*           m_pBlackListManager;

        template<typename DatabaseType>
        Result ListTemplate(int* outCount, typename DatabaseType::SelfEntryType* outValue, int count) NN_NOEXCEPT;
        void PrepareInstallTask(VersionListDatabase* db) NN_NOEXCEPT;
        Result PrepareInstallTaskOneIfNeeded(VersionListDatabase* db, ncm::ApplicationId id) NN_NOEXCEPT;
    };

}}}
