﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ncm/ncm_StorageId.h>
#include <nn/nn_SdkLog.h>

namespace nn { namespace ns { namespace srv {

    // 小さい値の方が高優先度
    class ApplicationStoragePriority
    {
    public:
        ApplicationStoragePriority() NN_NOEXCEPT
            : m_Priority(Priority::Low)
        {
        }

        NN_IMPLICIT ApplicationStoragePriority(ncm::StorageId id) NN_NOEXCEPT
        {
            SetByStorageId(id);
        }

        void SetHighestPriority() { m_Priority = Priority::High; }
        void SetLowestPriority() { m_Priority = Priority::Low; }

        bool IsHighest() const { return m_Priority == Priority::High; }
        bool IsLowest() const { return m_Priority == Priority::Low; }

        bool operator<(ApplicationStoragePriority& rValue) NN_NOEXCEPT
        {
            return static_cast<int>(m_Priority) < static_cast<int>(rValue.m_Priority);
        }

        ApplicationStoragePriority& operator=(const ApplicationStoragePriority& storage) NN_NOEXCEPT
        {
            m_Priority = storage.m_Priority;
            return *this;
        }

        ApplicationStoragePriority& operator=(ncm::StorageId id) NN_NOEXCEPT
        {
            SetByStorageId(id);
            return *this;
        }

    private:
        enum class Priority : Bit8
        {
            High,
            Card,
            SdCard,
            BuildInUser,
            Low,
        };

        void SetByStorageId(ncm::StorageId id) NN_NOEXCEPT
        {
            switch(id)
            {
            case ncm::StorageId::None:
            case ncm::StorageId::Any:
                m_Priority = Priority::Low;
                break;
            case ncm::StorageId::Card:
                m_Priority = Priority::Card;
                break;
            case ncm::StorageId::BuildInUser:
                m_Priority = Priority::BuildInUser;
                break;
            case ncm::StorageId::SdCard:
                m_Priority = Priority::SdCard;
                break;
            default: NN_UNEXPECTED_DEFAULT;
            }
        }

        Priority m_Priority;
    };

}}}
