﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <atomic>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ns/ns_ApplicationLaunchInfo.h>
#include <nn/ns/srv/ns_OsUtil.h>
#include <nn/os/os_Types.h>
#include <nn/util/util_Optional.h>

namespace nn { namespace ns { namespace srv {

    class ApplicationLaunchPropertyManager
    {
    public:
        ApplicationLaunchPropertyManager() NN_NOEXCEPT;

        Result Update(const ApplicationLaunchInfo& info, uint8_t programIndex, os::ProcessId processId) NN_NOEXCEPT;

        Result Acquire(ApplicationLaunchInfo* outInfo, os::ProcessId processId) NN_NOEXCEPT;

        Bit64 GenerateApplicationLaunchInfoId() NN_NOEXCEPT;

        Result GetProgramIndex(uint8_t* outValue, const ApplicationLaunchInfo& info) const NN_NOEXCEPT;

        void Clear() NN_NOEXCEPT;

    private:
        mutable NonRecursiveMutex m_Mutex;
        ApplicationLaunchInfo m_Info;
        bool m_CanAcquire;
        uint8_t m_ProgramIndex;
        os::ProcessId m_ProcessId;
        std::atomic<Bit64> m_SequenceId;
    };

}}}
