﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_StaticAssert.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ncm/ncm_StorageId.h>
#include <nn/ns/ns_ApplicationEntitySystemTypes.h>
#include <nn/ns/srv/ns_ApplicationRecordDatabase.h>
#include <nn/ns/srv/ns_IntegratedContentManager.h>
#include <nn/ns/srv/ns_OsUtil.h>
#include <nn/ns/srv/ns_RequestServer.h>
#include <nn/ns/srv/ns_SystemReportManager.h>
#include <nn/ns/srv/ns_TicketManager.h>
#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace ns { namespace srv {

    class ApplicationEntityManager
    {
    public:
        void Initialize(ApplicationRecordDatabase* record, IntegratedContentManager* integrated, RequestServer* requestServer, SystemReportManager* reportManager, TicketManager* ticketManager) NN_NOEXCEPT;

        Result DeleteApplicationEntity(ncm::ApplicationId id) NN_NOEXCEPT;
        Result DeleteApplicationCompletely(ncm::ApplicationId id) NN_NOEXCEPT;
        Result DeleteApplicationContentEntity(const ncm::ContentMetaKey& key) NN_NOEXCEPT;
        Result IsAnyApplicationEntityRedundant(bool* outValue) NN_NOEXCEPT;
        Result DeleteRedundantApplicationEntity() NN_NOEXCEPT;
        Result IsApplicationEntityMovable(bool* outValue, ncm::ApplicationId id, ncm::StorageId storage) NN_NOEXCEPT;
        Result MoveApplicationEntity(ncm::ApplicationId id, ncm::StorageId storage) NN_NOEXCEPT;
        Result IsAnyApplicationEntityInstalled(bool* outValue, ncm::ApplicationId id) NN_NOEXCEPT;
        Result CleanupUnrecordedApplicationEntity(ncm::ApplicationId id) NN_NOEXCEPT;
        Result CleanupAddOnContentsWithNoRights(ncm::ApplicationId id) NN_NOEXCEPT;

        // For ns_ApplicationEntitySystemApi.h
        Result DeleteApplicationContentEntities(ncm::ApplicationId id, uint32_t innerFlagsValue, ncm::StorageId storageId) NN_NOEXCEPT;
        Result DeleteApplicationCompletelyForDebug(ncm::ApplicationId id, uint32_t innerFlagsValue) NN_NOEXCEPT;

    private:
        IntegratedContentManager* m_pIntegrated;
        ApplicationRecordDatabase* m_pRecordDb;
        RequestServer* m_pRequestServer;
        SystemReportManager* m_SystemReportManager;
        TicketManager* m_pTicketManager;

        NonRecursiveMutex m_ContentMetaKeyMutex;
        static const int MaxContentMetaKeyCount = 2048; // TODO: 暫定
        typedef std::aligned_storage<MaxContentMetaKeyCount * sizeof(ncm::ApplicationContentMetaKey), NN_ALIGNOF(ncm::ApplicationContentMetaKey)>::type ContentMetaBuffer;
        ContentMetaBuffer m_ContentMetaKeyBuffer;

        NN_STATIC_ASSERT(sizeof(ContentMetaBuffer) >= MaxContentMetaKeyCount * sizeof(ncm::ApplicationContentMetaKey));
        NN_STATIC_ASSERT(sizeof(ContentMetaBuffer) >= MaxContentMetaKeyCount * sizeof(ncm::ContentMetaKey));
        NN_STATIC_ASSERT(NN_ALIGNOF(ncm::ApplicationContentMetaKey) >= NN_ALIGNOF(ncm::ContentMetaKey));

        ncm::ApplicationContentMetaKey* GetApplicationContentMetaKeyBuffer() NN_NOEXCEPT
        {
            return reinterpret_cast<ncm::ApplicationContentMetaKey*>(&m_ContentMetaKeyBuffer);
        }

        ncm::ContentMetaKey* GetContentMetaKeyBuffer() NN_NOEXCEPT
        {
            return reinterpret_cast<ncm::ContentMetaKey*>(&m_ContentMetaKeyBuffer);
        }

        Result HasRecordOf(bool* outValue, ncm::ApplicationId id, const ncm::ContentMetaKey& key) NN_NOEXCEPT;
        Result DeleteApplicationEntityImpl(bool* outIsApplicationDeleted, ncm::ApplicationId id, ApplicationEntityFlag flags, ncm::StorageId storageId) NN_NOEXCEPT;
        Result DeleteApplicationEntity(ncm::ApplicationId id, ApplicationEntityFlag flags) NN_NOEXCEPT;
        Result DeleteApplicationCompletely(ncm::ApplicationId id, ApplicationEntityFlag flags) NN_NOEXCEPT;
        Result DeleteUnrecordedContentMeta(const ncm::ContentMetaKey& key, const ApplicationRecordAccessor* pAccessor) NN_NOEXCEPT;
    };

}}}
