﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ns/ns_ApplicationCopyIdentifierTypes.h>
#include <nn/ns/srv/ns_GameCardManager.h>
#include <nn/sf/sf_Types.h>

namespace nn { namespace ns { namespace srv {
    class ApplicationCopyIdentifierManager
    {
    NN_DISALLOW_COPY(ApplicationCopyIdentifierManager);
    NN_DISALLOW_MOVE(ApplicationCopyIdentifierManager);
    public:
        ApplicationCopyIdentifierManager() NN_NOEXCEPT {};
        void Initialize(GameCardManager* gameCardManager)
        {
            m_GameCardManager = gameCardManager;
        }

        Result GetGameCardApplicationCopyIdentifier(sf::Out<ns::GameCardApplicationCopyIdentifier> outValue, ncm::ApplicationId id) NN_NOEXCEPT;
        Result GetInstalledApplicationCopyIdentifier(sf::Out<ns::InstalledApplicationCopyIdentifier> outValue, ncm::ApplicationId id, ncm::StorageId storage) NN_NOEXCEPT;
    private:
        GameCardManager* m_GameCardManager;
    };
}}}
