﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/ncm/ncm_SystemContentMetaId.h>

namespace nn { namespace ns {
    namespace detail
    {
        const char PortNameForVulnerabilityManager[] = "ns:vm";
    }

    /**
    * @brief    脆弱性対策の更新の必要性を取得します。
    *
    * @details  本体更新が必要な場合は true を、不要な場合は false を返します。
    *           この関数が返す値はシステムにキャッシュされ、この関数の呼び出しとは無関係にバックグラウンドで更新されます。
    *           返す値の初期値は false です。オンラインになったタイミングで適切な値に更新されます。
    */
    bool NeedsUpdateVulnerability() NN_NOEXCEPT;


    void UpdateSafeSystemVersionForDebug(ncm::SystemUpdateId id, uint32_t version) NN_NOEXCEPT;
    void GetSafeSystemVersion(ncm::ContentMetaKey* out) NN_NOEXCEPT;
}}  // namespace nn::ns
