﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ContentMetaId.h>

namespace nn { namespace ns {

/*
* @brief    アプリケーションの終了理由の Result を設定します。
*
* @details  設定された Result によって、アプリケーションの終了状態を判定します。
*           判定された結果は ApplicationViewFlag に反映されます。
*           設定された Result は nn::ns::ClearApplicationTerminateResult() が呼び出されるまで保持されます。
*
*/
Result SetApplicationTerminateResult(ncm::ApplicationId id, Result result) NN_NOEXCEPT;

/*
* @brief    設定されているアプリケーションの終了理由の Result をクリアします。
*
*/
Result ClearApplicationTerminateResult(ncm::ApplicationId id) NN_NOEXCEPT;

/*
* @brief    設定されているアプリケーションの終了理由を取得します。
*
* @details  外部に公開出来る Result が設定されている時のみ取得できます。
*           それ以外の時は Success が返ってきます。
*/
Result GetApplicationTerminateResult(Result* outValue, ncm::ApplicationId id) NN_NOEXCEPT;

}}
