﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_StaticAssert.h>
#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace ns {

struct SystemDeliveryAttributeTag {};
typedef util::BitFlagSet<32, SystemDeliveryAttributeTag> SystemDeliveryAttribute;

/*
 * この構造体の中身は参照しないでください。
 */
struct SystemDeliveryInfo
{
    uint32_t systemDeliveryProtocolVersion;
    uint32_t applicationDeliveryProtocolVersion;
    SystemDeliveryAttribute attributes;
    uint32_t systemUpdateVersion;
    Bit64 systemUpdateId;
    Bit8 reserved[200];
    // これより上のデータを計算した結果を入れるので、この下に項目を追加しないようにする
    Bit8 mac[32];
};
NN_STATIC_ASSERT(sizeof(SystemDeliveryInfo) == 256);

}}  // namespace nn::ns
