﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ns/ns_Async.h>
#include <nn/util/util_Uuid.h>

namespace nn { namespace ns {
    enum class DownloadTaskStatusDetail : Bit8
    {
        Created,
        Added,
        AlreadyExists,
        Failed
    };

    struct DownloadTaskStatus
    {
        util::Uuid uuid;
        ncm::ApplicationId applicationId;
        DownloadTaskStatusDetail detail;
        bool needsCleanup;
        Bit8 reserved[2];
        Bit32 result;

        bool IsValid() const NN_NOEXCEPT
        {
            return uuid != util::InvalidUuid;
        }

        bool IsEmpty() const NN_NOEXCEPT
        {
            return uuid == util::InvalidUuid;
        }

        void SetResult(Result in) NN_NOEXCEPT
        {
            result = in.GetInnerValueForDebug();
        }

        Result GetResult() const NN_NOEXCEPT
        {
            return result::detail::ConstructResult(result);
        }
    };

    void ClearTaskStatusList() NN_NOEXCEPT;

    int ListDownloadTaskStatus(DownloadTaskStatus outList[], int count) NN_NOEXCEPT;

    struct DownloadTaskListData
    {
        char data[256 * 1024];
    };

    typedef AsyncValue<DownloadTaskListData> AsyncDownloadTaskListData;
    Result RequestDownloadTaskListData(AsyncDownloadTaskListData* outValue) NN_NOEXCEPT;

    Result TryCommitCurrentApplicationDownloadTask() NN_NOEXCEPT;

    Result TriggerDynamicCommitEvent() NN_NOEXCEPT;
}}  // namespace nn::ns
