﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ns/ns_Async.h>

namespace nn { namespace ns {

    /**
    * @brief    ダウンロードタスクリストの取得を要求します。
    */
    void RequestDownloadTaskList() NN_NOEXCEPT;

    /**
    * @brief    ダウンロードタスク開始の保証を要求します。
    *
    * @details  AsyncResult が成功していれば、ダウンロードタスクリストの受信および
    *           ダウンロードタスクの開始が保証されます。
    *           AsyncResult が失敗した場合はエラービューアでエラーを表示してください。
    */
    void RequestEnsureDownloadTask(AsyncResult* outValue) NN_NOEXCEPT;

}}  // namespace nn::ns
