﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account.h>
#include <nn/nn_Common.h>
#include <nn/ns/ns_Async.h>

namespace nn { namespace ns {

    /**
    * @brief    何らかのアプリケーションが動作しているか取得します。
    *
    * @details  機器認証を行ってよい状態かの判断のために利用します。
    *           この API が true を返す場合は、機器認証の解除は行わないでください。
    *
    * @return   動作している場合は true、動作していない場合は false が返ります。
    */
    bool IsAnyApplicationRunning() NN_NOEXCEPT;

    /**
    * @brief    指定のユーザーアカウントに連携済みのニンテンドーアカウントで機器認証登録を要求します。
    *           デバイスアカウントが作成されていない場合、機器認証登録前にデバイス登録を行います。
    *           このデバイスが初期化される前にデバイス登録や機器認証登録を行っていた場合、登録情報の削除をサーバに要求します。
    *           指定のユーザーアカウントに連携済みのニンテンドーアカウントが既にこのデバイスに機器認証登録されていた場合も成功します。
    *
    * @details  非同期処理をリクエストして、AsyncResult を返します。
    *           処理の結果は AsyncResult から取得してください。
    *           処理が成功するためには、インフラ通信が確立している必要があります。
    *           この関数で同時にリクエストできる非同期処理は最大１つです。
    *
    * @return   処理の結果が返ります。通信エラーなどは下位レイヤの Result が返されます。必要があればエラーコードを表示してください。
    * @retval   ResultOutOfMaxRunningTask                       同時に発行できるリクエスト数が最大に達しています。
    * @retval   ResultCanceled                                  （AsyncResult から返される Result）処理がキャンセルされました。
    * @retval   ec::ResultSystemUpdateRequired                  （AsyncResult から返される Result）処理を行うためには本体更新が必要です。
    * @retval   ec::ResultNintendoAccountNotLinked              （AsyncResult から返される Result）指定されたアカウントにニンテンドーアカウントが紐付いていません。
    * @retval   ec::ResultAccountAlreadyDeviceLinked            （AsyncResult から返される Result）ニンテンドーアカウントが他のデバイスで既に機器認証されています。
    */
    Result RequestLinkDevice(AsyncResult* outValue, const account::Uid& uid) NN_NOEXCEPT;

}}  // namespace nn::ns
