﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/ns/ns_ApplicationLaunchInfo.h>
#include <nn/os/os_Types.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/ncm/ncm_ProgramLocation.h>
#include <nn/arp/arp_Types.h>

namespace nn { namespace ns {

    namespace detail
    {
        const char PortNameForDevelop[] = "ns:dev";
    }

    enum LaunchProgramFlags
    {
        LaunchProgramFlags_None             = 0,
        LaunchProgramFlags_NotifyExit       = (1 << 0),
        LaunchProgramFlags_NotifyStart      = (1 << 1),
        LaunchProgramFlags_NotifyException  = (1 << 2),
        LaunchProgramFlags_NotifyDebug      = (1 << 3),
        LaunchProgramFlags_NotStart         = (1 << 4),
        LaunchProgramFlags_DisableAslr      = (1 << 5),
    };

    enum ShellEvent
    {
        ShellEvent_None,
        ShellEvent_Exit,
        ShellEvent_Started,
        ShellEvent_Exception,
        ShellEvent_DebugRunning,
    };

    struct ShellEventInfo
    {
        ShellEvent      event;
        os::ProcessId   processId;
    };

    struct ProgramLaunchProperty
    {
        ncm::ProgramId programId;
        uint32_t version;
        ncm::StorageId storageId;
        uint8_t programIndex;
        bool isApplication;
        Bit8 reserved[1];
    };

    Result InitializeForDevelop() NN_NOEXCEPT;
    Result FinalizeForDevelop() NN_NOEXCEPT;
    Result LaunchProgram(os::ProcessId* pOut, const ProgramLaunchProperty& launchProperty, int flags) NN_NOEXCEPT;
    Result GetShellEvent(os::SystemEvent* pOut) NN_NOEXCEPT;
    Result GetShellEventInfo(ShellEventInfo* pOut) NN_NOEXCEPT;
    Result TerminateProcess(os::ProcessId processId) NN_NOEXCEPT;
    Result TerminateProgram(ncm::ProgramId programId) NN_NOEXCEPT;
    Result TerminateApplication() NN_NOEXCEPT;
    Result PrepareLaunchProgramFromHost(ProgramLaunchProperty* pOut, const char* programPath) NN_NOEXCEPT;
    Result LaunchApplicationForDevelop(os::ProcessId* pOut, ncm::ApplicationId applicationId, int32_t flags) NN_NOEXCEPT;
    Result LaunchApplicationWithStorageIdForDevelop(
        os::ProcessId* pOut,
        ncm::ApplicationId applicationId,
        int32_t flags,
        ncm::StorageId appStorageId,
        ncm::StorageId patchStorageId) NN_NOEXCEPT;
    Result GetRunningApplicationProcessIdForDevelop(os::ProcessId* pOut) NN_NOEXCEPT;

}}  // namespace nn::pm

