﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace ns {

struct VerifyContentFlagTag {};
typedef util::BitFlagSet<32, VerifyContentFlagTag> VerifyContentFlag;

// 検証する ContentMetaType
typedef VerifyContentFlag::Flag<0>     VerifyContentFlag_Application;
typedef VerifyContentFlag::Flag<1>     VerifyContentFlag_AddOnContent;
typedef VerifyContentFlag::Flag<2>     VerifyContentFlag_Patch;

const VerifyContentFlag VerifyContentFlag_All = VerifyContentFlag_Application::Mask |
                                                  VerifyContentFlag_AddOnContent::Mask |
                                                  VerifyContentFlag_Patch::Mask;

struct CorruptContentFlagTag {};
typedef util::BitFlagSet<32, CorruptContentFlagTag> CorruptContentFlag;

// 破壊する ContentMetaType
typedef CorruptContentFlag::Flag<0>     CorruptContentFlag_Application;
typedef CorruptContentFlag::Flag<1>     CorruptContentFlag_AddOnContent;
typedef CorruptContentFlag::Flag<2>     CorruptContentFlag_Patch;

// 一部を破壊したいときの任意オプション
// program0.ncd 内のコンテンツ
typedef CorruptContentFlag::Flag<10>     CorruptContentFlag_Code;

// SD カードのコンテンツを読めなくします (ResultSdCardDataCorrupted の検証用)
// SD カードが破壊対象のストレージになっているときのみ影響があります
// 再起動すると元に戻ります
typedef CorruptContentFlag::Flag<20>     CorruptContentFlag_SdCardEncryption;

const CorruptContentFlag CorruptContentFlag_All = CorruptContentFlag_Application::Mask |
                                                  CorruptContentFlag_AddOnContent::Mask |
                                                  CorruptContentFlag_Patch::Mask;

}}  // namespace nn::ns
