﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ns/ns_ApplicationRightsTypes.h>

namespace nn { namespace ns {

    typedef ApplicationRightsOnClientFlag::Flag<0>  ApplicationRightsOnClientFlag_HasAvailableRights;
    typedef ApplicationRightsOnClientFlag::Flag<1>  ApplicationRightsOnClientFlag_HasUnavailableRights;
    typedef ApplicationRightsOnClientFlag::Flag<2>  ApplicationRightsOnClientFlag_HasAccountRestrictedRights;
    typedef ApplicationRightsOnClientFlag::Flag<3>  ApplicationRightsOnClientFlag_HasPrepurchasedRights;
    typedef ApplicationRightsOnClientFlag::Flag<4>  ApplicationRightsOnClientFlag_RecommendInquireServer;

    struct ApplicationRightsOnClientQueryFlagTag {};
    typedef util::BitFlagSet<32, ApplicationRightsOnClientQueryFlagTag> ApplicationRightsOnClientQueryFlag;
    typedef ApplicationRightsOnClientQueryFlag::Flag<0> ApplicationRightsOnClientQueryFlag_Application;
    typedef ApplicationRightsOnClientQueryFlag::Flag<1> ApplicationRightsOnClientQueryFlag_AddOnContent;

    static const auto ApplicationRightsOnClientQueryFlag_AllContents =  ApplicationRightsOnClientQueryFlag_Application::Mask |
                                                                        ApplicationRightsOnClientQueryFlag_AddOnContent::Mask;
}}  // namespace nn::ns
