﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/account/account_Types.h>
#include <nn/ns/ns_ApplicationRightsTypes.h>

namespace nn { namespace ns {

    /**
    * @brief    アプリケーションの権利状態を取得します
    *
    * @retval   処理の結果が返ります。
    * @retval   ResultApplicationRecordNotFound         アプリケーション記録が見つかりません。
    * @retval   ResultBufferNotEnough                   指定したリストのサイズが足りません。
    * @retval   ResultCorruptedContentFound             破損したファイルがあります。破損チェックを行なってください。
    *
    */
    Result GetApplicationRightsOnClient(
        int* outCount,
        ApplicationRightsOnClient* outList,
        int listCount,
        ncm::ApplicationId appId) NN_NOEXCEPT;

    Result GetApplicationRightsOnClient(
        int* outCount,
        ApplicationRightsOnClient* outList,
        int listCount,
        ncm::ApplicationId appId,
        const account::Uid& uid) NN_NOEXCEPT;

    Result GetApplicationRightsOnClientForApplication(
        ApplicationRightsOnClient* outValue,
        ncm::ApplicationId appId) NN_NOEXCEPT;

    Result GetApplicationRightsOnClientForApplication(
        ApplicationRightsOnClient* outValue,
        ncm::ApplicationId appId,
        const account::Uid& uid) NN_NOEXCEPT;

    Result GetApplicationRightsOnClientForAddOnContent(
        ApplicationRightsOnClient* outValue,
        ncm::ApplicationId appId) NN_NOEXCEPT;

    Result GetApplicationRightsOnClientForAddOnContent(
        ApplicationRightsOnClient* outValue,
        ncm::ApplicationId appId,
        const account::Uid& uid) NN_NOEXCEPT;
}}  // namespace nn::ns
