﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_StaticAssert.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ncm/ncm_StorageId.h>

namespace nn { namespace ns {
    enum class ApplicationLaunchInfoFlag : Bit8
    {
        None = 0,
        AutoBootByGameCard = 1 << 0,
    };

    struct ApplicationLaunchInfo
    {
        ncm::ApplicationId id;
        uint32_t version;
        int32_t launchFlags;
        ncm::StorageId applicationStorageId;
        ncm::StorageId patchStorageId;
        Bit8 launchInfoFlags;
        Bit8 reserved0x13[5];
        Bit64 _infoId; // 内部利用変数
        Bit8 reserved[32];

        bool IsValid() const NN_NOEXCEPT
        {
            return id != ncm::ApplicationId::GetInvalidId();
        }
    };
    // サイズの確認
    NN_STATIC_ASSERT(sizeof(ApplicationLaunchInfo) == 64);

}}  // namespace ns
