﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_StaticAssert.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace ns {

struct ApplicationDeliveryAttributeTag {};
typedef util::BitFlagSet<32, ApplicationDeliveryAttributeTag> ApplicationDeliveryAttribute;

typedef ApplicationDeliveryAttribute::Flag<0>    ApplicationDeliveryAttribute_RequestApplication;
typedef ApplicationDeliveryAttribute::Flag<1>    ApplicationDeliveryAttribute_RequestPatch;

struct ApplicationDeliveryInfo
{
    uint32_t applicationDeliveryProtocolVersion; // SystemDeliveryInfo と同じものが入る
    Bit8 reserved0x4[4];
    ncm::ApplicationId id;
    uint32_t version;
    uint32_t requiredVersion;
    uint32_t requiredSystemVersion;
    ApplicationDeliveryAttribute attributes;
    Bit8 reserved[192];
    // これより上のデータを計算した結果を入れるので、この下に項目を追加しないようにする
    Bit8 mac[32];
};
NN_STATIC_ASSERT(sizeof(ApplicationDeliveryInfo) == 256);

struct ApplicationDeliveryInfoHash
{
    Bit8 data[32];
};
NN_STATIC_ASSERT(sizeof(ApplicationDeliveryInfoHash) == 32);

}}  // namespace nn::ns

