﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/os/os_Types.h>
#include <nn/ncm/ncm_SystemContentMetaId.h>

namespace nn { namespace ns {

    enum class ApplicationShellEvent : Bit8
    {
        Exit,
        DebugRunning,
        DebugBreaked,
        Exception,
        RebootRequest,
        NotifyStartCardUpdate,
        ShowCardUpdateProcessingRequest,
        NotifyEndCardUpdate,
    };

    struct ApplicationShellEventInfo
    {
        ApplicationShellEvent event;
        Bit8 reserved[7];
        os::ProcessId processId;
    };

    // EventClearMode_AutoClear です。
    void GetApplicationShellEvent(os::SystemEvent* outValue) NN_NOEXCEPT;

    int PopApplicationShellEventInfo(ApplicationShellEventInfo outList[], int count) NN_NOEXCEPT;

    Result LaunchLibraryApplet(os::ProcessId* outValue, ncm::SystemProgramId id) NN_NOEXCEPT;

    Result TerminateLibraryApplet(os::ProcessId pid) NN_NOEXCEPT;

    Result LaunchSystemApplet(os::ProcessId* outValue) NN_NOEXCEPT;

    Result TerminateSystemApplet(os::ProcessId pid) NN_NOEXCEPT;

    Result LaunchOverlayApplet(os::ProcessId* outValue) NN_NOEXCEPT;

    Result TerminateOverlayApplet(os::ProcessId pid) NN_NOEXCEPT;

}}  // namespace ns
