﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace ns {
    /**
    * @brief    Direct Function Call 形式で ns ライブラリを使用するために必要な依存システムを初期化します。
    *
    * @details  Windows で ns ライブラリを使用するために使用します。
    *           現時点で、下記の初期化 API を順に実行します。
    *           - ncm::Initialize();
    *           - NN_ABORT_UNLESS_RESULT_SUCCESS(socket::Initialize());
    *           - NN_ABORT_UNLESS_EQUAL(CURLE_OK, curl_global_init(CURL_GLOBAL_ALL));
    *           - NN_ABORT_UNLESS_RESULT_SUCCESS(nifm::Initialize());
    *           - nim::InitializeForNetworkInstallManager();
    *           個別に初期化を制御したい場合は、この API を使わずに上記を個別に呼び出してください。
    *           将来 ns ライブラリが依存する機能が増えると、実行される初期化 API も増えます。
    */
    void InitializeDependenciesForDfc() NN_NOEXCEPT;

    /**
    * @brief    Direct Function Call 形式で ns ライブラリを使用するために必要な依存システムを Finailze します。
    *
    * @details  Windows で ns ライブラリを使用するために使用します。
    *           現時点で、下記の Finalize API を順に実行します。
    *           nim::FinalizeForNetworkInstallManager();
    *           NN_ABORT_UNLESS_RESULT_SUCCESS(nifm::Finalize());
    *           curl_global_cleanup();
    *           NN_ABORT_UNLESS_RESULT_SUCCESS(socket::Finalize());
    *           ncm::Finalize();
    *           将来 ns ライブラリが依存する機能が増えると、実行される Finalize API も増えます。
    */
    void FinalizeDependenciesForDfc() NN_NOEXCEPT;


}}
