﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ns/ns_UserResourceManagementTypes.h>

#include <nn/nn_ApplicationId.h>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/os/os_Tick.h>

namespace nn { namespace ns { namespace detail {

struct ProgressForDeleteUserSaveDataAll
{
    int64_t _startedAt;

    uint32_t _count;
    uint64_t _sizeInBytes;
    struct
    {
        bool isSystem;
        union
        {
            bool _dummy;
            ApplicationId applicationId;
        } identity;
    } _cursor;

    // 進捗
    UserSaveDataStatistics GetStatistics() const NN_NOEXCEPT
    {
        UserSaveDataStatistics stat = {_count, _sizeInBytes};
        return stat;
    }

    // 経過時間
    TimeSpan GetElapsedTime() const NN_NOEXCEPT
    {
        return (os::GetSystemTick() - os::Tick(_startedAt)).ToTimeSpan();
    }

    // システムセーブデータかどうか
    bool IsSystemSaveData() const NN_NOEXCEPT
    {
        return _cursor.isSystem;
    }

    // 現在処理中のセーブデータがどのアプリケーションのものか
    bool TryGetCurrentApplicationId(ApplicationId* pOut) const NN_NOEXCEPT
    {
        if (true
            && !_cursor.isSystem
            && _cursor.identity.applicationId != ApplicationId::GetInvalidId())
        {
            *pOut = _cursor.identity.applicationId;
            return true;
        }
        return false;
    }
};

}}}
