﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/account/account_Types.h>
#include <nn/err/err_ErrorContext.h>
#include <nn/es/es_Types.h>
#include <nn/fs/fs_SaveDataTypes.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/ncm/ncm_ContentStorage.h>
#include <nn/ncm/ncm_ContentType.h>
#include <nn/ncm/ncm_ProgramId.h>
#include <nn/ncm/ncm_StorageId.h>
#include <nn/ncm/ncm_SystemContentMetaId.h>
#include <nn/nim/nim_BackgroundDownloadStressTaskInfo.h>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/ns/detail/ns_IAsync.sfdl.h>
#include <nn/ns/detail/ns_UserResourceManagementInternalTypes.h>
#include <nn/ns/ns_ApplicationContentMetaApi.h>
#include <nn/ns/ns_ApplicationControlDataApi.h>
#include <nn/ns/ns_ApplicationControlDataSystemApi.h>
#include <nn/ns/ns_ApplicationCopyIdentifierTypes.h>
#include <nn/ns/ns_ApplicationDeliveryInfo.h>
#include <nn/ns/ns_ApplicationLaunchInfo.h>
#include <nn/ns/ns_ApplicationManagerApi.h>
#include <nn/ns/ns_ApplicationManagerSystemApi.h>
#include <nn/ns/ns_ApplicationRecordSystemApi.h>
#include <nn/ns/ns_ApplicationRightsSystemApi.h>
#include <nn/ns/ns_ApplicationRightsTypes.h>
#include <nn/ns/ns_ApplicationVersionSystemApi.h>
#include <nn/ns/ns_ContentDeliveryProgress.h>
#include <nn/ns/ns_DownloadTaskSystemApi.h>
#include <nn/ns/ns_NotificationSystemApi.h>
#include <nn/ns/ns_PseudoDeviceIdApi.h>
#include <nn/ns/ns_RetailInteractiveDisplayApi.h>
#include <nn/ns/ns_SystemDeliveryInfo.h>
#include <nn/ns/ns_TicketApi.h>
#include <nn/ns/ns_UserResourceManagementApi.h>
#include <nn/os/os_Types.h>
#include <nn/settings/settings_Language.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace ns { namespace detail { // NOLINT(whitespace/braces)

class IAccountProxyInterface;

class IApplicationManagerInterface;

class IApplicationVersionInterface;

class IContentManagementInterface;

class IDocumentInterface;

class IDownloadTaskInterface;

class IDynamicRightsInterface;

class IECommerceInterface;

class IFactoryResetInterface;

class IGameCardStopper;

class IProgressMonitorForDeleteUserSaveDataAll;

class IReadOnlyApplicationControlDataInterface;

class IReadOnlyApplicationRecordInterface;

class IRequestServerStopper;

class IServiceGetterInterface;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IAccountProxyInterface, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IAccountProxyInterface)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateUserAccount, (const ::nn::account::Nickname& name, const ::nn::sf::InBuffer& image))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IAccountProxyInterface)

        ::nn::Result CreateUserAccount(const ::nn::account::Nickname& name, const ::nn::sf::InBuffer& image) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateUserAccount, (name, image));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IAccountProxyInterface
    {
    public:
        nn::Result CreateUserAccount(const nn::account::Nickname& name, const nn::sf::InBuffer& image) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CreateUserAccount(const nn::account::Nickname& name, const nn::sf::InBuffer& image) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ns::detail::IAccountProxyInterface))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateUserAccount, (const ::nn::account::Nickname& name, const ::nn::sf::InBuffer& image))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateUserAccount, (name, image));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ns::detail::IAccountProxyInterface>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ns::detail::IAccountProxyInterface))

    // nn::Result CreateUserAccount(const nn::account::Nickname& name, const nn::sf::InBuffer& image) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateUserAccount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(image, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (image))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(name, (::nn::account::Nickname), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (name))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(33)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(name), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(image)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateUserAccount)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::Nickname), 33, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ns::detail::IAccountProxyInterface, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ns::detail::IAccountProxyInterface))

    // nn::Result CreateUserAccount(const nn::account::Nickname& name, const nn::sf::InBuffer& image) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateUserAccount, (const ::nn::account::Nickname& name, const ::nn::sf::InBuffer& image))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateUserAccount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(name)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(image)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateUserAccount)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ns::detail::IAccountProxyInterface>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ns::detail::IAccountProxyInterface))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateUserAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(image)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateUserAccount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(name),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(image)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateUserAccount)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ns::detail::IAccountProxyInterface))

namespace nn { namespace ns { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IApplicationManagerInterface, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IApplicationManagerInterface)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationRecord, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationRecord>& outList, ::std::int32_t offset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GenerateApplicationRecordCount, (::nn::sf::Out<::std::int64_t> outCount))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationRecordUpdateSystemEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationViewDeprecated, (const ::nn::sf::OutArray<::nn::ns::ApplicationViewDeprecated>& outList, const ::nn::sf::InArray<::nn::ncm::ApplicationId>& idList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteApplicationEntity, (::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteApplicationCompletely, (::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsAnyApplicationEntityRedundant, (::nn::sf::Out<bool> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DeleteRedundantApplicationEntity)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsApplicationEntityMovable, (::nn::sf::Out<bool> outValue, ::nn::ncm::ApplicationId id, ::nn::ncm::StorageId storage))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(MoveApplicationEntity, (::nn::ncm::ApplicationId id, ::nn::ncm::StorageId storage))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CalculateApplicationOccupiedSize, (::nn::sf::Out<::nn::ns::ApplicationOccupiedSize> outValue, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PushApplicationRecord, (::nn::ncm::ApplicationId id, ::nn::ns::ApplicationEvent appEvent, const ::nn::sf::InArray<::nn::ncm::StorageContentMetaKey>& keyList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationRecordContentMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::nn::ncm::ApplicationId id, ::std::int32_t offset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationContentPath, (::nn::sf::Out<::nn::ncm::Path> outValue, ::nn::ncm::ApplicationId id, ::nn::ncm::ContentType type))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TerminateApplication, (::nn::os::ProcessId pid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ResolveApplicationContentPath, (::nn::ncm::ProgramId id, ::nn::ncm::ContentType type))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BeginInstallApplication, (::nn::ncm::ApplicationId id, ::std::uint32_t version, ::nn::ncm::StorageId storageId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteApplicationRecord, (::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestApplicationUpdateInfo, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CancelApplicationDownload, (::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ResumeApplicationDownload, (::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UpdateVersionList, (const ::nn::sf::InBuffer& buffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PushLaunchVersion, (::nn::ncm::ApplicationId id, ::std::uint32_t version))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListRequiredVersion, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::RequiredVersionEntry>& requiredVersionEntries))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CheckApplicationLaunchVersion, (::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CheckApplicationLaunchRights, (::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationLogoData, (::nn::sf::Out<::std::int64_t> outSize, const ::nn::sf::OutBuffer& outBuffer, ::nn::ncm::ApplicationId id, const ::nn::ncm::Path& logoPath))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CalculateApplicationDownloadRequiredSize, (::nn::sf::Out<::nn::ncm::StorageId> outStorage, ::nn::sf::Out<::std::int64_t> outValue, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CleanupSdCard)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CheckSdCardMountStatus)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSdCardMountStatusChangedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardAttachmentEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardAttachmentInfo, (::nn::sf::Out<::nn::ns::GameCardAttachmentInfo> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetTotalSpaceSize, (::nn::sf::Out<::std::int64_t> outSize, ::nn::ncm::StorageId storage))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFreeSpaceSize, (::nn::sf::Out<::std::int64_t> outSize, ::nn::ncm::StorageId storage))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSdCardRemovedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardUpdateDetectionEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DisableApplicationAutoDelete, (::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EnableApplicationAutoDelete, (::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetApplicationTerminateResult, (::nn::ncm::ApplicationId id, ::std::uint32_t result))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ClearApplicationTerminateResult, (::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(GetLastSdCardMountUnexpectedResult)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetBackgroundDownloadStressTaskInfo, (::nn::sf::Out<::nn::nim::BackgroundDownloadStressTaskInfo> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardStopper, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IGameCardStopper>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsSystemProgramInstalled, (::nn::sf::Out<bool> outValue, ::nn::ncm::SystemProgramId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartApplyDeltaTask, (::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRequestServerStopper, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IRequestServerStopper>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetBackgroundApplyDeltaStressTaskInfo, (::nn::sf::Out<::nn::nim::BackgroundDownloadStressTaskInfo> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CancelApplicationApplyDelta, (::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ResumeApplicationApplyDelta, (::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CalculateApplicationApplyDeltaRequiredSize, (::nn::sf::Out<::nn::ncm::StorageId> outStorage, ::nn::sf::Out<::std::int64_t> outValue, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ResumeAll)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetStorageSize, (::nn::sf::Out<::std::int64_t> outTotalSize, ::nn::sf::Out<::std::int64_t> outFreeSize, ::nn::ncm::StorageId storage))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestDownloadApplication, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId applicationId, ::nn::ncm::StorageId storageId, bool forceDirectUpdate))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestDownloadAddOnContent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId id, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::StorageId storageId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DownloadApplication, (::nn::ncm::ApplicationId applicationId, ::nn::ncm::StorageId storageId, bool forceDirectUpdate))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CheckApplicationResumeRights, (::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDynamicCommitEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestUpdateApplication2, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(EnableApplicationCrashReport, (bool isEnable))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_0(IsApplicationCrashReportEnabled, (bool))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(BoostSystemMemoryResourceLimit, (::std::int64_t boostSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeprecatedLaunchApplication, (::nn::sf::Out<::nn::os::ProcessId> outValue, ::nn::ncm::ApplicationId id, ::std::uint8_t programIndex))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRunningApplicationProgramId, (::nn::sf::Out<::nn::ncm::ProgramId> outValue, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetMainApplicationProgramIndex, (::nn::sf::Out<::std::uint8_t> outValue, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LaunchApplication, (::nn::sf::Out<::nn::os::ProcessId> outValue, const ::nn::ns::ApplicationLaunchInfo& info, ::std::uint8_t programIndex))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationLaunchInfo, (::nn::sf::Out<::nn::ns::ApplicationLaunchInfo> outValue, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AcquireApplicationLaunchInfo, (::nn::sf::Out<::nn::ns::ApplicationLaunchInfo> outValue, ::nn::os::ProcessId processId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetMainApplicationProgramIndexByApplicationLaunchInfo, (::nn::sf::Out<::std::uint8_t> outValue, const ::nn::ns::ApplicationLaunchInfo& info))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_N(EnableApplicationAllThreadDumpOnCrash, (bool isEnabled))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ResetToFactorySettings)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ResetToFactorySettingsWithoutUserSaveData)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ResetToFactorySettingsForRefurbishment)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CalculateUserSaveDataStatistics, (::nn::sf::Out<::nn::ns::UserSaveDataStatistics> pOut, const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteUserSaveDataAll, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IProgressMonitorForDeleteUserSaveDataAll>> pOut, const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteUserSystemSaveData, (const ::nn::account::Uid& uid, ::nn::fs::SystemSaveDataId sysSaveId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterNetworkServiceAccount, (const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterNetworkServiceAccountWithUserSaveDataDeletion, (const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationShellEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PopApplicationShellEventInfo, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationShellEventInfo>& outList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LaunchLibraryApplet, (::nn::sf::Out<::nn::os::ProcessId> outValue, ::nn::ncm::SystemProgramId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TerminateLibraryApplet, (::nn::os::ProcessId pid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LaunchSystemApplet, (::nn::sf::Out<::nn::os::ProcessId> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TerminateSystemApplet, (::nn::os::ProcessId pid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LaunchOverlayApplet, (::nn::sf::Out<::nn::os::ProcessId> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TerminateOverlayApplet, (::nn::os::ProcessId pid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(InvalidateAllApplicationControlCache)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestDownloadApplicationControlData, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetMaxApplicationControlCacheCount, (::nn::sf::Out<::std::int32_t> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(InvalidateApplicationControlCache, (::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationControlCacheEntryInfo, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationControlCacheEntryInfo>& outList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationControlProperty, (::nn::sf::Out<::nn::ns::ApplicationControlProperty> outValue, const ::nn::ns::ApplicationLaunchInfo& info, ::std::uint8_t programIndex))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestCheckGameCardRegistration, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId appId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestGameCardRegistrationGoldPoint, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync, const ::nn::account::Uid& uid, ::nn::ncm::ApplicationId appId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestRegisterGameCard, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, const ::nn::account::Uid& uid, ::nn::ncm::ApplicationId appId, ::std::int32_t goldPoint))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardMountFailureEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsGameCardInserted, (::nn::sf::Out<bool> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(EnsureGameCardAccess)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(GetLastGameCardMountFailureResult)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationIdOnGameCard, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ApplicationId>& outList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CountApplicationContentMeta, (::nn::sf::Out<::std::int32_t> outValue, ::nn::ncm::ApplicationId appId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationContentMetaStatus, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationContentMetaStatus>& outList, ::nn::ncm::ApplicationId appId, ::std::int32_t offset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListAvailableAddOnContent, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationContentMetaStatus>& outList, ::nn::ncm::ApplicationId appId, ::std::int32_t offset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetOwnedApplicationContentMetaStatus, (::nn::sf::Out<::nn::ns::ApplicationContentMetaStatus> outValue, ::nn::ncm::ApplicationId appId, ::nn::Bit64 contentMetaId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterContentsExternalKey, (::nn::ncm::ApplicationId appId, ::nn::Bit64 contentMetaId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationContentMetaStatusWithRightsCheck, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationContentMetaStatus>& outList, ::nn::ncm::ApplicationId appId, ::std::int32_t offset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetContentMetaStorage, (::nn::sf::Out<::nn::ncm::StorageId> outValue, const ::nn::ncm::ContentMetaKey& key))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PushDownloadTaskList, (const ::nn::sf::InBuffer& buffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ClearTaskStatusList)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(RequestDownloadTaskList)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestEnsureDownloadTask, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListDownloadTaskStatus, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::DownloadTaskStatus>& outList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestDownloadTaskListData, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(RequestVersionList)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListVersionList, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::VersionListEntry>& versionListEntries))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestVersionListData, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationRecord, (::nn::sf::Out<::nn::ns::ApplicationRecord> outValue, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationRecordProperty, (::nn::sf::Out<::nn::ns::ApplicationRecordProperty> outValue, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EnableApplicationAutoUpdate, (::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DisableApplicationAutoUpdate, (::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(TouchApplication, (::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestApplicationUpdate, (::nn::ncm::ApplicationId id, ::nn::Bit32 resultInnerValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsApplicationUpdateRequested, (::nn::sf::Out<bool> outValue, ::nn::sf::Out<::nn::Bit32> resultInnerValue, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(WithdrawApplicationUpdateRequest, (::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationRecordInstalledContentMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::nn::ncm::ApplicationId id, ::std::int32_t offset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(WithdrawCleanupAddOnContentsWithNoRightsRecommendation, (::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(HasApplicationRecord, (::nn::sf::Out<bool> outValue, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetPreInstalledApplication, (::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ClearPreInstalledApplicationFlag, (::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestVerifyApplicationDeprecated, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IProgressAsyncResult>> outAsync, ::nn::ncm::ApplicationId id, ::nn::sf::NativeHandle&& transferHandle, ::std::uint64_t transferSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CorruptApplicationForDebug, (::nn::ncm::ApplicationId id, ::nn::Bit32 flags, ::nn::ncm::StorageId storageId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestVerifyAddOnContentsRights, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IProgressAsyncResult>> outAsync, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestVerifyApplication, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IProgressAsyncResult>> outAsync, ::nn::ncm::ApplicationId id, ::nn::Bit32 flags, ::nn::sf::NativeHandle&& transferHandle, ::std::uint64_t transferSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CorruptContentForDebug, (const ::nn::ncm::ContentMetaKey& key, ::nn::ncm::StorageId storageId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(NeedsUpdateVulnerability, (::nn::sf::Out<bool> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsAnyApplicationEntityInstalled, (::nn::sf::Out<bool> outValue, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteApplicationContentEntities, (::nn::ncm::ApplicationId id, ::std::uint32_t innerValue, ::nn::ncm::StorageId storage))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CleanupUnrecordedApplicationEntity, (::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CleanupAddOnContentsWithNoRights, (::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteApplicationContentEntity, (const ::nn::ncm::ContentMetaKey& key))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteApplicationCompletelyForDebug, (::nn::ncm::ApplicationId id, ::std::uint32_t innerValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(PrepareShutdown)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(FormatSdCard)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(NeedsSystemUpdateToFormatSdCard, (::nn::sf::Out<bool> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(GetLastSdCardFormatUnexpectedResult)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(InsertSdCard)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(RemoveSdCard)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemSeedForPseudoDeviceId, (::nn::sf::Out<::nn::ns::SystemSeedForPseudoDeviceId> pOutSeed))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ResetSystemSeedForPseudoDeviceId)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationDownloadingContentMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::nn::ncm::ApplicationId id, ::std::int32_t offset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationView, (const ::nn::sf::OutArray<::nn::ns::ApplicationView>& outList, const ::nn::sf::InArray<::nn::ncm::ApplicationId>& idList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationDownloadTaskStatus, (::nn::sf::Out<::nn::ns::ApplicationDownloadTaskStatus> outValue, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationViewDownloadErrorContext, (::nn::sf::Out<::nn::err::ErrorContext> outValue, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsNotificationSetupCompleted, (::nn::sf::Out<bool> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLastNotificationInfoCount, (::nn::sf::Out<::std::int64_t> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListLastNotificationInfo, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::NotificationInfo>& outList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListNotificationTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::AsyncTask>& outList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsActiveAccount, (::nn::sf::Out<bool> outValue, ::nn::es::AccountId accountId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestDownloadApplicationPrepurchasedRights, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationTicketInfo, (::nn::sf::Out<::nn::ns::ApplicationTicketInfo> outValue, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemDeliveryInfo, (::nn::sf::Out<::nn::ns::SystemDeliveryInfo> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SelectLatestSystemDeliveryInfo, (::nn::sf::Out<::std::int32_t> outValue, const ::nn::sf::InArray<::nn::ns::SystemDeliveryInfo>& list, const ::nn::ns::SystemDeliveryInfo& receiverSystemInfo, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& receiverAppInfo))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(VerifyDeliveryProtocolVersion, (const ::nn::ns::SystemDeliveryInfo& info))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationDeliveryInfo, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationDeliveryInfo>& outValue, ::nn::ncm::ApplicationId id, ::nn::ns::ApplicationDeliveryAttribute attributes))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(HasAllContentsToDeliver, (::nn::sf::Out<bool> outValue, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& appInfoList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CompareApplicationDeliveryInfo, (::nn::sf::Out<::std::int32_t> outValue, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& lhs, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& rhs))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CanDeliverApplication, (::nn::sf::Out<bool> outValue, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& receiverInfoList, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& senderInfoList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListContentMetaKeyToDeliverApplication, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ContentMetaKey>& outList, ::std::int32_t offset, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& infoList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(NeedsSystemUpdateToDeliverApplication, (::nn::sf::Out<bool> outValue, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& applicationInfoList, const ::nn::ns::SystemDeliveryInfo& systemInfo))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EstimateRequiredSize, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestReceiveApplication, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::ApplicationId id, ::nn::ncm::StorageId storageId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CommitReceiveApplication, (::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetReceiveApplicationProgress, (::nn::sf::Out<::nn::ns::ReceiveApplicationProgress> outValue, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestSendApplication, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSendApplicationProgress, (::nn::sf::Out<::nn::ns::SendApplicationProgress> outValue, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CompareSystemDeliveryInfo, (::nn::sf::Out<::std::int32_t> outValue, const ::nn::ns::SystemDeliveryInfo& lhs, const ::nn::ns::SystemDeliveryInfo& rhs))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListNotCommittedContentMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ContentMetaKey>& outList, ::nn::ncm::ApplicationId id, ::std::int32_t offset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateDownloadTask, (const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationDeliveryInfoHash, (::nn::sf::Out<::nn::ns::ApplicationDeliveryInfoHash> outValue, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& infoList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationRightsOnClient, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationRightsOnClient>& outList, ::nn::ncm::ApplicationId appId, const ::nn::account::Uid& uid, ::nn::ns::ApplicationRightsOnClientQueryFlag flags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationTerminateResult, (::nn::sf::Out<::std::uint32_t> outValue, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRawApplicationTerminateResult, (::nn::sf::Out<::std::uint32_t> outValue, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateRightsEnvironment, (::nn::sf::Out<::nn::ns::RightsEnvironmentHandle> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DestroyRightsEnvironment, (::nn::ns::RightsEnvironmentHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ActivateRightsEnvironment, (::nn::ns::RightsEnvironmentHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeactivateRightsEnvironment, (::nn::ns::RightsEnvironmentHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AddTargetApplicationToRightsEnvironment, (::nn::ns::RightsEnvironmentHandle handle, ::nn::ncm::ApplicationId applicationId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetUsersToRightsEnvironment, (::nn::ns::RightsEnvironmentHandle handle, bool anyUser, const ::nn::sf::InArray<::nn::account::Uid>& uids))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRightsEnvironmentStatus, (::nn::sf::Out<::nn::ns::RightsEnvironmentStatus> pOut, ::nn::ns::RightsEnvironmentHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardApplicationCopyIdentifier, (::nn::sf::Out<::nn::ns::GameCardApplicationCopyIdentifier> outValue, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetInstalledApplicationCopyIdentifier, (::nn::sf::Out<::nn::ns::InstalledApplicationCopyIdentifier> outValue, ::nn::ncm::ApplicationId id, ::nn::ncm::StorageId storage))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IApplicationManagerInterface)

        ::nn::Result ListApplicationRecord(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationRecord>& outList, ::std::int32_t offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0), offset)), "_ >= 0 (where _ = offset)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListApplicationRecord, (outCount, outList, offset));
        }

        ::nn::Result GenerateApplicationRecordCount(::nn::sf::Out<::std::int64_t> outCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GenerateApplicationRecordCount, (outCount));
        }

        ::nn::Result GetApplicationRecordUpdateSystemEvent(::nn::sf::Out<::nn::sf::NativeHandle> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetApplicationRecordUpdateSystemEvent, (outValue));
        }

        ::nn::Result GetApplicationViewDeprecated(const ::nn::sf::OutArray<::nn::ns::ApplicationViewDeprecated>& outList, const ::nn::sf::InArray<::nn::ncm::ApplicationId>& idList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetApplicationViewDeprecated, (outList, idList));
        }

        ::nn::Result DeleteApplicationEntity(::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteApplicationEntity, (id));
        }

        ::nn::Result DeleteApplicationCompletely(::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteApplicationCompletely, (id));
        }

        ::nn::Result IsAnyApplicationEntityRedundant(::nn::sf::Out<bool> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsAnyApplicationEntityRedundant, (outValue));
        }

        ::nn::Result DeleteRedundantApplicationEntity() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DeleteRedundantApplicationEntity);
        }

        ::nn::Result IsApplicationEntityMovable(::nn::sf::Out<bool> outValue, ::nn::ncm::ApplicationId id, ::nn::ncm::StorageId storage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsApplicationEntityMovable, (outValue, id, storage));
        }

        ::nn::Result MoveApplicationEntity(::nn::ncm::ApplicationId id, ::nn::ncm::StorageId storage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(MoveApplicationEntity, (id, storage));
        }

        ::nn::Result CalculateApplicationOccupiedSize(::nn::sf::Out<::nn::ns::ApplicationOccupiedSize> outValue, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CalculateApplicationOccupiedSize, (outValue, id));
        }

        ::nn::Result PushApplicationRecord(::nn::ncm::ApplicationId id, ::nn::ns::ApplicationEvent appEvent, const ::nn::sf::InArray<::nn::ncm::StorageContentMetaKey>& keyList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PushApplicationRecord, (id, appEvent, keyList));
        }

        ::nn::Result ListApplicationRecordContentMeta(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::nn::ncm::ApplicationId id, ::std::int32_t offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0), offset)), "_ >= 0 (where _ = offset)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListApplicationRecordContentMeta, (outCount, outList, id, offset));
        }

        ::nn::Result GetApplicationContentPath(::nn::sf::Out<::nn::ncm::Path> outValue, ::nn::ncm::ApplicationId id, ::nn::ncm::ContentType type) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetApplicationContentPath, (outValue, id, type));
        }

        ::nn::Result TerminateApplication(::nn::os::ProcessId pid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TerminateApplication, (pid));
        }

        ::nn::Result ResolveApplicationContentPath(::nn::ncm::ProgramId id, ::nn::ncm::ContentType type) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ResolveApplicationContentPath, (id, type));
        }

        ::nn::Result BeginInstallApplication(::nn::ncm::ApplicationId id, ::std::uint32_t version, ::nn::ncm::StorageId storageId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BeginInstallApplication, (id, version, storageId));
        }

        ::nn::Result DeleteApplicationRecord(::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteApplicationRecord, (id));
        }

        ::nn::Result RequestApplicationUpdateInfo(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestApplicationUpdateInfo, (outHandle, outAsync, id));
        }

        ::nn::Result CancelApplicationDownload(::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CancelApplicationDownload, (id));
        }

        ::nn::Result ResumeApplicationDownload(::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ResumeApplicationDownload, (id));
        }

        ::nn::Result UpdateVersionList(const ::nn::sf::InBuffer& buffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UpdateVersionList, (buffer));
        }

        ::nn::Result PushLaunchVersion(::nn::ncm::ApplicationId id, ::std::uint32_t version) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PushLaunchVersion, (id, version));
        }

        ::nn::Result ListRequiredVersion(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::RequiredVersionEntry>& requiredVersionEntries) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListRequiredVersion, (outCount, requiredVersionEntries));
        }

        ::nn::Result CheckApplicationLaunchVersion(::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CheckApplicationLaunchVersion, (id));
        }

        ::nn::Result CheckApplicationLaunchRights(::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CheckApplicationLaunchRights, (id));
        }

        ::nn::Result GetApplicationLogoData(::nn::sf::Out<::std::int64_t> outSize, const ::nn::sf::OutBuffer& outBuffer, ::nn::ncm::ApplicationId id, const ::nn::ncm::Path& logoPath) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetApplicationLogoData, (outSize, outBuffer, id, logoPath));
        }

        ::nn::Result CalculateApplicationDownloadRequiredSize(::nn::sf::Out<::nn::ncm::StorageId> outStorage, ::nn::sf::Out<::std::int64_t> outValue, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CalculateApplicationDownloadRequiredSize, (outStorage, outValue, id));
        }

        ::nn::Result CleanupSdCard() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CleanupSdCard);
        }

        ::nn::Result CheckSdCardMountStatus() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CheckSdCardMountStatus);
        }

        ::nn::Result GetSdCardMountStatusChangedEvent(::nn::sf::Out<::nn::sf::NativeHandle> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSdCardMountStatusChangedEvent, (outValue));
        }

        ::nn::Result GetGameCardAttachmentEvent(::nn::sf::Out<::nn::sf::NativeHandle> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetGameCardAttachmentEvent, (outValue));
        }

        ::nn::Result GetGameCardAttachmentInfo(::nn::sf::Out<::nn::ns::GameCardAttachmentInfo> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetGameCardAttachmentInfo, (outValue));
        }

        ::nn::Result GetTotalSpaceSize(::nn::sf::Out<::std::int64_t> outSize, ::nn::ncm::StorageId storage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetTotalSpaceSize, (outSize, storage));
        }

        ::nn::Result GetFreeSpaceSize(::nn::sf::Out<::std::int64_t> outSize, ::nn::ncm::StorageId storage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFreeSpaceSize, (outSize, storage));
        }

        ::nn::Result GetSdCardRemovedEvent(::nn::sf::Out<::nn::sf::NativeHandle> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSdCardRemovedEvent, (outValue));
        }

        ::nn::Result GetGameCardUpdateDetectionEvent(::nn::sf::Out<::nn::sf::NativeHandle> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetGameCardUpdateDetectionEvent, (outValue));
        }

        ::nn::Result DisableApplicationAutoDelete(::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DisableApplicationAutoDelete, (id));
        }

        ::nn::Result EnableApplicationAutoDelete(::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EnableApplicationAutoDelete, (id));
        }

        ::nn::Result SetApplicationTerminateResult(::nn::ncm::ApplicationId id, ::std::uint32_t result) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetApplicationTerminateResult, (id, result));
        }

        ::nn::Result ClearApplicationTerminateResult(::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ClearApplicationTerminateResult, (id));
        }

        ::nn::Result GetLastSdCardMountUnexpectedResult() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(GetLastSdCardMountUnexpectedResult);
        }

        ::nn::Result GetBackgroundDownloadStressTaskInfo(::nn::sf::Out<::nn::nim::BackgroundDownloadStressTaskInfo> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetBackgroundDownloadStressTaskInfo, (outValue));
        }

        ::nn::Result GetGameCardStopper(::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IGameCardStopper>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetGameCardStopper, (outValue));
        }

        ::nn::Result IsSystemProgramInstalled(::nn::sf::Out<bool> outValue, ::nn::ncm::SystemProgramId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsSystemProgramInstalled, (outValue, id));
        }

        ::nn::Result StartApplyDeltaTask(::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartApplyDeltaTask, (id));
        }

        ::nn::Result GetRequestServerStopper(::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IRequestServerStopper>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRequestServerStopper, (outValue));
        }

        ::nn::Result GetBackgroundApplyDeltaStressTaskInfo(::nn::sf::Out<::nn::nim::BackgroundDownloadStressTaskInfo> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetBackgroundApplyDeltaStressTaskInfo, (outValue));
        }

        ::nn::Result CancelApplicationApplyDelta(::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CancelApplicationApplyDelta, (id));
        }

        ::nn::Result ResumeApplicationApplyDelta(::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ResumeApplicationApplyDelta, (id));
        }

        ::nn::Result CalculateApplicationApplyDeltaRequiredSize(::nn::sf::Out<::nn::ncm::StorageId> outStorage, ::nn::sf::Out<::std::int64_t> outValue, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CalculateApplicationApplyDeltaRequiredSize, (outStorage, outValue, id));
        }

        ::nn::Result ResumeAll() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ResumeAll);
        }

        ::nn::Result GetStorageSize(::nn::sf::Out<::std::int64_t> outTotalSize, ::nn::sf::Out<::std::int64_t> outFreeSize, ::nn::ncm::StorageId storage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetStorageSize, (outTotalSize, outFreeSize, storage));
        }

        ::nn::Result RequestDownloadApplication(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId applicationId, ::nn::ncm::StorageId storageId, bool forceDirectUpdate) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestDownloadApplication, (outHandle, outAsync, applicationId, storageId, forceDirectUpdate));
        }

        ::nn::Result RequestDownloadAddOnContent(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId id, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::StorageId storageId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestDownloadAddOnContent, (outHandle, outAsync, id, keyList, storageId));
        }

        ::nn::Result DownloadApplication(::nn::ncm::ApplicationId applicationId, ::nn::ncm::StorageId storageId, bool forceDirectUpdate) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DownloadApplication, (applicationId, storageId, forceDirectUpdate));
        }

        ::nn::Result CheckApplicationResumeRights(::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CheckApplicationResumeRights, (id));
        }

        ::nn::Result GetDynamicCommitEvent(::nn::sf::Out<::nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDynamicCommitEvent, (outHandle));
        }

        ::nn::Result RequestUpdateApplication2(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestUpdateApplication2, (outHandle, outAsync, id));
        }

        void EnableApplicationCrashReport(bool isEnable) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(EnableApplicationCrashReport, (isEnable));
        }

        bool IsApplicationCrashReportEnabled() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_0(IsApplicationCrashReportEnabled, (bool));
        }

        ::nn::Result BoostSystemMemoryResourceLimit(::std::int64_t boostSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(BoostSystemMemoryResourceLimit, (boostSize));
        }

        ::nn::Result DeprecatedLaunchApplication(::nn::sf::Out<::nn::os::ProcessId> outValue, ::nn::ncm::ApplicationId id, ::std::uint8_t programIndex) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeprecatedLaunchApplication, (outValue, id, programIndex));
        }

        ::nn::Result GetRunningApplicationProgramId(::nn::sf::Out<::nn::ncm::ProgramId> outValue, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRunningApplicationProgramId, (outValue, id));
        }

        ::nn::Result GetMainApplicationProgramIndex(::nn::sf::Out<::std::uint8_t> outValue, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetMainApplicationProgramIndex, (outValue, id));
        }

        ::nn::Result LaunchApplication(::nn::sf::Out<::nn::os::ProcessId> outValue, const ::nn::ns::ApplicationLaunchInfo& info, ::std::uint8_t programIndex) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LaunchApplication, (outValue, info, programIndex));
        }

        ::nn::Result GetApplicationLaunchInfo(::nn::sf::Out<::nn::ns::ApplicationLaunchInfo> outValue, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetApplicationLaunchInfo, (outValue, id));
        }

        ::nn::Result AcquireApplicationLaunchInfo(::nn::sf::Out<::nn::ns::ApplicationLaunchInfo> outValue, ::nn::os::ProcessId processId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AcquireApplicationLaunchInfo, (outValue, processId));
        }

        ::nn::Result GetMainApplicationProgramIndexByApplicationLaunchInfo(::nn::sf::Out<::std::uint8_t> outValue, const ::nn::ns::ApplicationLaunchInfo& info) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetMainApplicationProgramIndexByApplicationLaunchInfo, (outValue, info));
        }

        void EnableApplicationAllThreadDumpOnCrash(bool isEnabled) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_N(EnableApplicationAllThreadDumpOnCrash, (isEnabled));
        }

        ::nn::Result ResetToFactorySettings() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ResetToFactorySettings);
        }

        ::nn::Result ResetToFactorySettingsWithoutUserSaveData() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ResetToFactorySettingsWithoutUserSaveData);
        }

        ::nn::Result ResetToFactorySettingsForRefurbishment() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ResetToFactorySettingsForRefurbishment);
        }

        ::nn::Result CalculateUserSaveDataStatistics(::nn::sf::Out<::nn::ns::UserSaveDataStatistics> pOut, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CalculateUserSaveDataStatistics, (pOut, uid));
        }

        ::nn::Result DeleteUserSaveDataAll(::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IProgressMonitorForDeleteUserSaveDataAll>> pOut, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteUserSaveDataAll, (pOut, uid));
        }

        ::nn::Result DeleteUserSystemSaveData(const ::nn::account::Uid& uid, ::nn::fs::SystemSaveDataId sysSaveId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteUserSystemSaveData, (uid, sysSaveId));
        }

        ::nn::Result UnregisterNetworkServiceAccount(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnregisterNetworkServiceAccount, (uid));
        }

        ::nn::Result UnregisterNetworkServiceAccountWithUserSaveDataDeletion(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UnregisterNetworkServiceAccountWithUserSaveDataDeletion, (uid));
        }

        ::nn::Result GetApplicationShellEvent(::nn::sf::Out<::nn::sf::NativeHandle> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetApplicationShellEvent, (outValue));
        }

        ::nn::Result PopApplicationShellEventInfo(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationShellEventInfo>& outList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PopApplicationShellEventInfo, (outCount, outList));
        }

        ::nn::Result LaunchLibraryApplet(::nn::sf::Out<::nn::os::ProcessId> outValue, ::nn::ncm::SystemProgramId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LaunchLibraryApplet, (outValue, id));
        }

        ::nn::Result TerminateLibraryApplet(::nn::os::ProcessId pid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TerminateLibraryApplet, (pid));
        }

        ::nn::Result LaunchSystemApplet(::nn::sf::Out<::nn::os::ProcessId> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LaunchSystemApplet, (outValue));
        }

        ::nn::Result TerminateSystemApplet(::nn::os::ProcessId pid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TerminateSystemApplet, (pid));
        }

        ::nn::Result LaunchOverlayApplet(::nn::sf::Out<::nn::os::ProcessId> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LaunchOverlayApplet, (outValue));
        }

        ::nn::Result TerminateOverlayApplet(::nn::os::ProcessId pid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TerminateOverlayApplet, (pid));
        }

        ::nn::Result InvalidateAllApplicationControlCache() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(InvalidateAllApplicationControlCache);
        }

        ::nn::Result RequestDownloadApplicationControlData(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestDownloadApplicationControlData, (outHandle, outAsync, id));
        }

        ::nn::Result GetMaxApplicationControlCacheCount(::nn::sf::Out<::std::int32_t> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetMaxApplicationControlCacheCount, (outValue));
        }

        ::nn::Result InvalidateApplicationControlCache(::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(InvalidateApplicationControlCache, (id));
        }

        ::nn::Result ListApplicationControlCacheEntryInfo(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationControlCacheEntryInfo>& outList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListApplicationControlCacheEntryInfo, (outCount, outList));
        }

        ::nn::Result GetApplicationControlProperty(::nn::sf::Out<::nn::ns::ApplicationControlProperty> outValue, const ::nn::ns::ApplicationLaunchInfo& info, ::std::uint8_t programIndex) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetApplicationControlProperty, (outValue, info, programIndex));
        }

        ::nn::Result RequestCheckGameCardRegistration(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId appId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestCheckGameCardRegistration, (outHandle, outAsync, appId));
        }

        ::nn::Result RequestGameCardRegistrationGoldPoint(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync, const ::nn::account::Uid& uid, ::nn::ncm::ApplicationId appId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestGameCardRegistrationGoldPoint, (outHandle, outAsync, uid, appId));
        }

        ::nn::Result RequestRegisterGameCard(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, const ::nn::account::Uid& uid, ::nn::ncm::ApplicationId appId, ::std::int32_t goldPoint) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestRegisterGameCard, (outHandle, outAsync, uid, appId, goldPoint));
        }

        ::nn::Result GetGameCardMountFailureEvent(::nn::sf::Out<::nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetGameCardMountFailureEvent, (outHandle));
        }

        ::nn::Result IsGameCardInserted(::nn::sf::Out<bool> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsGameCardInserted, (outValue));
        }

        ::nn::Result EnsureGameCardAccess() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(EnsureGameCardAccess);
        }

        ::nn::Result GetLastGameCardMountFailureResult() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(GetLastGameCardMountFailureResult);
        }

        ::nn::Result ListApplicationIdOnGameCard(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ApplicationId>& outList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListApplicationIdOnGameCard, (outCount, outList));
        }

        ::nn::Result CountApplicationContentMeta(::nn::sf::Out<::std::int32_t> outValue, ::nn::ncm::ApplicationId appId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CountApplicationContentMeta, (outValue, appId));
        }

        ::nn::Result ListApplicationContentMetaStatus(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationContentMetaStatus>& outList, ::nn::ncm::ApplicationId appId, ::std::int32_t offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0), offset)), "_ >= 0 (where _ = offset)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListApplicationContentMetaStatus, (outCount, outList, appId, offset));
        }

        ::nn::Result ListAvailableAddOnContent(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationContentMetaStatus>& outList, ::nn::ncm::ApplicationId appId, ::std::int32_t offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0), offset)), "_ >= 0 (where _ = offset)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListAvailableAddOnContent, (outCount, outList, appId, offset));
        }

        ::nn::Result GetOwnedApplicationContentMetaStatus(::nn::sf::Out<::nn::ns::ApplicationContentMetaStatus> outValue, ::nn::ncm::ApplicationId appId, ::nn::Bit64 contentMetaId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetOwnedApplicationContentMetaStatus, (outValue, appId, contentMetaId));
        }

        ::nn::Result RegisterContentsExternalKey(::nn::ncm::ApplicationId appId, ::nn::Bit64 contentMetaId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterContentsExternalKey, (appId, contentMetaId));
        }

        ::nn::Result ListApplicationContentMetaStatusWithRightsCheck(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationContentMetaStatus>& outList, ::nn::ncm::ApplicationId appId, ::std::int32_t offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0), offset)), "_ >= 0 (where _ = offset)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListApplicationContentMetaStatusWithRightsCheck, (outCount, outList, appId, offset));
        }

        ::nn::Result GetContentMetaStorage(::nn::sf::Out<::nn::ncm::StorageId> outValue, const ::nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetContentMetaStorage, (outValue, key));
        }

        ::nn::Result PushDownloadTaskList(const ::nn::sf::InBuffer& buffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PushDownloadTaskList, (buffer));
        }

        ::nn::Result ClearTaskStatusList() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ClearTaskStatusList);
        }

        ::nn::Result RequestDownloadTaskList() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(RequestDownloadTaskList);
        }

        ::nn::Result RequestEnsureDownloadTask(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestEnsureDownloadTask, (outHandle, outAsync));
        }

        ::nn::Result ListDownloadTaskStatus(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::DownloadTaskStatus>& outList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListDownloadTaskStatus, (outCount, outList));
        }

        ::nn::Result RequestDownloadTaskListData(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestDownloadTaskListData, (outHandle, outAsync));
        }

        ::nn::Result RequestVersionList() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(RequestVersionList);
        }

        ::nn::Result ListVersionList(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::VersionListEntry>& versionListEntries) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListVersionList, (outCount, versionListEntries));
        }

        ::nn::Result RequestVersionListData(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestVersionListData, (outHandle, outAsync));
        }

        ::nn::Result GetApplicationRecord(::nn::sf::Out<::nn::ns::ApplicationRecord> outValue, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetApplicationRecord, (outValue, id));
        }

        ::nn::Result GetApplicationRecordProperty(::nn::sf::Out<::nn::ns::ApplicationRecordProperty> outValue, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetApplicationRecordProperty, (outValue, id));
        }

        ::nn::Result EnableApplicationAutoUpdate(::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EnableApplicationAutoUpdate, (id));
        }

        ::nn::Result DisableApplicationAutoUpdate(::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DisableApplicationAutoUpdate, (id));
        }

        ::nn::Result TouchApplication(::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(TouchApplication, (id));
        }

        ::nn::Result RequestApplicationUpdate(::nn::ncm::ApplicationId id, ::nn::Bit32 resultInnerValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestApplicationUpdate, (id, resultInnerValue));
        }

        ::nn::Result IsApplicationUpdateRequested(::nn::sf::Out<bool> outValue, ::nn::sf::Out<::nn::Bit32> resultInnerValue, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsApplicationUpdateRequested, (outValue, resultInnerValue, id));
        }

        ::nn::Result WithdrawApplicationUpdateRequest(::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(WithdrawApplicationUpdateRequest, (id));
        }

        ::nn::Result ListApplicationRecordInstalledContentMeta(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::nn::ncm::ApplicationId id, ::std::int32_t offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0), offset)), "_ >= 0 (where _ = offset)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListApplicationRecordInstalledContentMeta, (outCount, outList, id, offset));
        }

        ::nn::Result WithdrawCleanupAddOnContentsWithNoRightsRecommendation(::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(WithdrawCleanupAddOnContentsWithNoRightsRecommendation, (id));
        }

        ::nn::Result HasApplicationRecord(::nn::sf::Out<bool> outValue, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(HasApplicationRecord, (outValue, id));
        }

        ::nn::Result SetPreInstalledApplication(::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetPreInstalledApplication, (id));
        }

        ::nn::Result ClearPreInstalledApplicationFlag(::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ClearPreInstalledApplicationFlag, (id));
        }

        ::nn::Result RequestVerifyApplicationDeprecated(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IProgressAsyncResult>> outAsync, ::nn::ncm::ApplicationId id, ::nn::sf::NativeHandle&& transferHandle, ::std::uint64_t transferSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestVerifyApplicationDeprecated, (outHandle, outAsync, id, ::std::move(transferHandle), transferSize));
        }

        ::nn::Result CorruptApplicationForDebug(::nn::ncm::ApplicationId id, ::nn::Bit32 flags, ::nn::ncm::StorageId storageId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CorruptApplicationForDebug, (id, flags, storageId));
        }

        ::nn::Result RequestVerifyAddOnContentsRights(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IProgressAsyncResult>> outAsync, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestVerifyAddOnContentsRights, (outHandle, outAsync, id));
        }

        ::nn::Result RequestVerifyApplication(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IProgressAsyncResult>> outAsync, ::nn::ncm::ApplicationId id, ::nn::Bit32 flags, ::nn::sf::NativeHandle&& transferHandle, ::std::uint64_t transferSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestVerifyApplication, (outHandle, outAsync, id, flags, ::std::move(transferHandle), transferSize));
        }

        ::nn::Result CorruptContentForDebug(const ::nn::ncm::ContentMetaKey& key, ::nn::ncm::StorageId storageId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CorruptContentForDebug, (key, storageId));
        }

        ::nn::Result NeedsUpdateVulnerability(::nn::sf::Out<bool> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(NeedsUpdateVulnerability, (outValue));
        }

        ::nn::Result IsAnyApplicationEntityInstalled(::nn::sf::Out<bool> outValue, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsAnyApplicationEntityInstalled, (outValue, id));
        }

        ::nn::Result DeleteApplicationContentEntities(::nn::ncm::ApplicationId id, ::std::uint32_t innerValue, ::nn::ncm::StorageId storage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteApplicationContentEntities, (id, innerValue, storage));
        }

        ::nn::Result CleanupUnrecordedApplicationEntity(::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CleanupUnrecordedApplicationEntity, (id));
        }

        ::nn::Result CleanupAddOnContentsWithNoRights(::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CleanupAddOnContentsWithNoRights, (id));
        }

        ::nn::Result DeleteApplicationContentEntity(const ::nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteApplicationContentEntity, (key));
        }

        ::nn::Result DeleteApplicationCompletelyForDebug(::nn::ncm::ApplicationId id, ::std::uint32_t innerValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteApplicationCompletelyForDebug, (id, innerValue));
        }

        ::nn::Result PrepareShutdown() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(PrepareShutdown);
        }

        ::nn::Result FormatSdCard() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(FormatSdCard);
        }

        ::nn::Result NeedsSystemUpdateToFormatSdCard(::nn::sf::Out<bool> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(NeedsSystemUpdateToFormatSdCard, (outValue));
        }

        ::nn::Result GetLastSdCardFormatUnexpectedResult() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(GetLastSdCardFormatUnexpectedResult);
        }

        ::nn::Result InsertSdCard() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(InsertSdCard);
        }

        ::nn::Result RemoveSdCard() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(RemoveSdCard);
        }

        ::nn::Result GetSystemSeedForPseudoDeviceId(::nn::sf::Out<::nn::ns::SystemSeedForPseudoDeviceId> pOutSeed) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSystemSeedForPseudoDeviceId, (pOutSeed));
        }

        ::nn::Result ResetSystemSeedForPseudoDeviceId() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ResetSystemSeedForPseudoDeviceId);
        }

        ::nn::Result ListApplicationDownloadingContentMeta(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::nn::ncm::ApplicationId id, ::std::int32_t offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_CALL_INTERNAL_ASSERT_PRE((NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0), offset)), "_ >= 0 (where _ = offset)")
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListApplicationDownloadingContentMeta, (outCount, outList, id, offset));
        }

        ::nn::Result GetApplicationView(const ::nn::sf::OutArray<::nn::ns::ApplicationView>& outList, const ::nn::sf::InArray<::nn::ncm::ApplicationId>& idList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetApplicationView, (outList, idList));
        }

        ::nn::Result GetApplicationDownloadTaskStatus(::nn::sf::Out<::nn::ns::ApplicationDownloadTaskStatus> outValue, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetApplicationDownloadTaskStatus, (outValue, id));
        }

        ::nn::Result GetApplicationViewDownloadErrorContext(::nn::sf::Out<::nn::err::ErrorContext> outValue, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetApplicationViewDownloadErrorContext, (outValue, id));
        }

        ::nn::Result IsNotificationSetupCompleted(::nn::sf::Out<bool> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsNotificationSetupCompleted, (outValue));
        }

        ::nn::Result GetLastNotificationInfoCount(::nn::sf::Out<::std::int64_t> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLastNotificationInfoCount, (outValue));
        }

        ::nn::Result ListLastNotificationInfo(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::NotificationInfo>& outList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListLastNotificationInfo, (outCount, outList));
        }

        ::nn::Result ListNotificationTask(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::AsyncTask>& outList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListNotificationTask, (outCount, outList));
        }

        ::nn::Result IsActiveAccount(::nn::sf::Out<bool> outValue, ::nn::es::AccountId accountId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsActiveAccount, (outValue, accountId));
        }

        ::nn::Result RequestDownloadApplicationPrepurchasedRights(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestDownloadApplicationPrepurchasedRights, (outHandle, outAsync, id));
        }

        ::nn::Result GetApplicationTicketInfo(::nn::sf::Out<::nn::ns::ApplicationTicketInfo> outValue, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetApplicationTicketInfo, (outValue, id));
        }

        ::nn::Result GetSystemDeliveryInfo(::nn::sf::Out<::nn::ns::SystemDeliveryInfo> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSystemDeliveryInfo, (outValue));
        }

        ::nn::Result SelectLatestSystemDeliveryInfo(::nn::sf::Out<::std::int32_t> outValue, const ::nn::sf::InArray<::nn::ns::SystemDeliveryInfo>& list, const ::nn::ns::SystemDeliveryInfo& receiverSystemInfo, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& receiverAppInfo) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SelectLatestSystemDeliveryInfo, (outValue, list, receiverSystemInfo, receiverAppInfo));
        }

        ::nn::Result VerifyDeliveryProtocolVersion(const ::nn::ns::SystemDeliveryInfo& info) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(VerifyDeliveryProtocolVersion, (info));
        }

        ::nn::Result GetApplicationDeliveryInfo(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationDeliveryInfo>& outValue, ::nn::ncm::ApplicationId id, ::nn::ns::ApplicationDeliveryAttribute attributes) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetApplicationDeliveryInfo, (outCount, outValue, id, attributes));
        }

        ::nn::Result HasAllContentsToDeliver(::nn::sf::Out<bool> outValue, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& appInfoList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(HasAllContentsToDeliver, (outValue, appInfoList));
        }

        ::nn::Result CompareApplicationDeliveryInfo(::nn::sf::Out<::std::int32_t> outValue, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& lhs, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& rhs) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CompareApplicationDeliveryInfo, (outValue, lhs, rhs));
        }

        ::nn::Result CanDeliverApplication(::nn::sf::Out<bool> outValue, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& receiverInfoList, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& senderInfoList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CanDeliverApplication, (outValue, receiverInfoList, senderInfoList));
        }

        ::nn::Result ListContentMetaKeyToDeliverApplication(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ContentMetaKey>& outList, ::std::int32_t offset, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& infoList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListContentMetaKeyToDeliverApplication, (outCount, outList, offset, infoList));
        }

        ::nn::Result NeedsSystemUpdateToDeliverApplication(::nn::sf::Out<bool> outValue, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& applicationInfoList, const ::nn::ns::SystemDeliveryInfo& systemInfo) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(NeedsSystemUpdateToDeliverApplication, (outValue, applicationInfoList, systemInfo));
        }

        ::nn::Result EstimateRequiredSize(::nn::sf::Out<::std::int64_t> outValue, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EstimateRequiredSize, (outValue, keyList));
        }

        ::nn::Result RequestReceiveApplication(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::ApplicationId id, ::nn::ncm::StorageId storageId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestReceiveApplication, (outHandle, outAsync, ipv4, port, keyList, id, storageId));
        }

        ::nn::Result CommitReceiveApplication(::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CommitReceiveApplication, (id));
        }

        ::nn::Result GetReceiveApplicationProgress(::nn::sf::Out<::nn::ns::ReceiveApplicationProgress> outValue, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetReceiveApplicationProgress, (outValue, id));
        }

        ::nn::Result RequestSendApplication(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestSendApplication, (outHandle, outAsync, ipv4, port, keyList, id));
        }

        ::nn::Result GetSendApplicationProgress(::nn::sf::Out<::nn::ns::SendApplicationProgress> outValue, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSendApplicationProgress, (outValue, id));
        }

        ::nn::Result CompareSystemDeliveryInfo(::nn::sf::Out<::std::int32_t> outValue, const ::nn::ns::SystemDeliveryInfo& lhs, const ::nn::ns::SystemDeliveryInfo& rhs) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CompareSystemDeliveryInfo, (outValue, lhs, rhs));
        }

        ::nn::Result ListNotCommittedContentMeta(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ContentMetaKey>& outList, ::nn::ncm::ApplicationId id, ::std::int32_t offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListNotCommittedContentMeta, (outCount, outList, id, offset));
        }

        ::nn::Result CreateDownloadTask(const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateDownloadTask, (keyList, id));
        }

        ::nn::Result GetApplicationDeliveryInfoHash(::nn::sf::Out<::nn::ns::ApplicationDeliveryInfoHash> outValue, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& infoList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetApplicationDeliveryInfoHash, (outValue, infoList));
        }

        ::nn::Result GetApplicationRightsOnClient(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationRightsOnClient>& outList, ::nn::ncm::ApplicationId appId, const ::nn::account::Uid& uid, ::nn::ns::ApplicationRightsOnClientQueryFlag flags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetApplicationRightsOnClient, (outCount, outList, appId, uid, flags));
        }

        ::nn::Result GetApplicationTerminateResult(::nn::sf::Out<::std::uint32_t> outValue, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetApplicationTerminateResult, (outValue, id));
        }

        ::nn::Result GetRawApplicationTerminateResult(::nn::sf::Out<::std::uint32_t> outValue, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRawApplicationTerminateResult, (outValue, id));
        }

        ::nn::Result CreateRightsEnvironment(::nn::sf::Out<::nn::ns::RightsEnvironmentHandle> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateRightsEnvironment, (pOut));
        }

        ::nn::Result DestroyRightsEnvironment(::nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DestroyRightsEnvironment, (handle));
        }

        ::nn::Result ActivateRightsEnvironment(::nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ActivateRightsEnvironment, (handle));
        }

        ::nn::Result DeactivateRightsEnvironment(::nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeactivateRightsEnvironment, (handle));
        }

        ::nn::Result AddTargetApplicationToRightsEnvironment(::nn::ns::RightsEnvironmentHandle handle, ::nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AddTargetApplicationToRightsEnvironment, (handle, applicationId));
        }

        ::nn::Result SetUsersToRightsEnvironment(::nn::ns::RightsEnvironmentHandle handle, bool anyUser, const ::nn::sf::InArray<::nn::account::Uid>& uids) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetUsersToRightsEnvironment, (handle, anyUser, uids));
        }

        ::nn::Result GetRightsEnvironmentStatus(::nn::sf::Out<::nn::ns::RightsEnvironmentStatus> pOut, ::nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRightsEnvironmentStatus, (pOut, handle));
        }

        ::nn::Result GetGameCardApplicationCopyIdentifier(::nn::sf::Out<::nn::ns::GameCardApplicationCopyIdentifier> outValue, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetGameCardApplicationCopyIdentifier, (outValue, id));
        }

        ::nn::Result GetInstalledApplicationCopyIdentifier(::nn::sf::Out<::nn::ns::InstalledApplicationCopyIdentifier> outValue, ::nn::ncm::ApplicationId id, ::nn::ncm::StorageId storage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetInstalledApplicationCopyIdentifier, (outValue, id, storage));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IApplicationManagerInterface
    {
    public:
        nn::Result ListApplicationRecord(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationRecord>& outList, std::int32_t offset) NN_NOEXCEPT;
        nn::Result GenerateApplicationRecordCount(nn::sf::Out<std::int64_t> outCount) NN_NOEXCEPT;
        nn::Result GetApplicationRecordUpdateSystemEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT;
        nn::Result GetApplicationViewDeprecated(const nn::sf::OutArray<nn::ns::ApplicationViewDeprecated>& outList, const nn::sf::InArray<nn::ncm::ApplicationId>& idList) NN_NOEXCEPT;
        nn::Result DeleteApplicationEntity(nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result DeleteApplicationCompletely(nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result IsAnyApplicationEntityRedundant(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result DeleteRedundantApplicationEntity() NN_NOEXCEPT;
        nn::Result IsApplicationEntityMovable(nn::sf::Out<bool> outValue, nn::ncm::ApplicationId id, nn::ncm::StorageId storage) NN_NOEXCEPT;
        nn::Result MoveApplicationEntity(nn::ncm::ApplicationId id, nn::ncm::StorageId storage) NN_NOEXCEPT;
        nn::Result CalculateApplicationOccupiedSize(nn::sf::Out<nn::ns::ApplicationOccupiedSize> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result PushApplicationRecord(nn::ncm::ApplicationId id, nn::ns::ApplicationEvent appEvent, const nn::sf::InArray<nn::ncm::StorageContentMetaKey>& keyList) NN_NOEXCEPT;
        nn::Result ListApplicationRecordContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, nn::ncm::ApplicationId id, std::int32_t offset) NN_NOEXCEPT;
        nn::Result GetApplicationContentPath(nn::sf::Out<nn::ncm::Path> outValue, nn::ncm::ApplicationId id, nn::ncm::ContentType type) NN_NOEXCEPT;
        nn::Result TerminateApplication(nn::os::ProcessId pid) NN_NOEXCEPT;
        nn::Result ResolveApplicationContentPath(nn::ncm::ProgramId id, nn::ncm::ContentType type) NN_NOEXCEPT;
        nn::Result BeginInstallApplication(nn::ncm::ApplicationId id, std::uint32_t version, nn::ncm::StorageId storageId) NN_NOEXCEPT;
        nn::Result DeleteApplicationRecord(nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result RequestApplicationUpdateInfo(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result CancelApplicationDownload(nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result ResumeApplicationDownload(nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result UpdateVersionList(const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
        nn::Result PushLaunchVersion(nn::ncm::ApplicationId id, std::uint32_t version) NN_NOEXCEPT;
        nn::Result ListRequiredVersion(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::RequiredVersionEntry>& requiredVersionEntries) NN_NOEXCEPT;
        nn::Result CheckApplicationLaunchVersion(nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result CheckApplicationLaunchRights(nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result GetApplicationLogoData(nn::sf::Out<std::int64_t> outSize, const nn::sf::OutBuffer& outBuffer, nn::ncm::ApplicationId id, const nn::ncm::Path& logoPath) NN_NOEXCEPT;
        nn::Result CalculateApplicationDownloadRequiredSize(nn::sf::Out<nn::ncm::StorageId> outStorage, nn::sf::Out<std::int64_t> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result CleanupSdCard() NN_NOEXCEPT;
        nn::Result CheckSdCardMountStatus() NN_NOEXCEPT;
        nn::Result GetSdCardMountStatusChangedEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT;
        nn::Result GetGameCardAttachmentEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT;
        nn::Result GetGameCardAttachmentInfo(nn::sf::Out<nn::ns::GameCardAttachmentInfo> outValue) NN_NOEXCEPT;
        nn::Result GetTotalSpaceSize(nn::sf::Out<std::int64_t> outSize, nn::ncm::StorageId storage) NN_NOEXCEPT;
        nn::Result GetFreeSpaceSize(nn::sf::Out<std::int64_t> outSize, nn::ncm::StorageId storage) NN_NOEXCEPT;
        nn::Result GetSdCardRemovedEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT;
        nn::Result GetGameCardUpdateDetectionEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT;
        nn::Result DisableApplicationAutoDelete(nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result EnableApplicationAutoDelete(nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result SetApplicationTerminateResult(nn::ncm::ApplicationId id, std::uint32_t result) NN_NOEXCEPT;
        nn::Result ClearApplicationTerminateResult(nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result GetLastSdCardMountUnexpectedResult() NN_NOEXCEPT;
        nn::Result GetBackgroundDownloadStressTaskInfo(nn::sf::Out<nn::nim::BackgroundDownloadStressTaskInfo> outValue) NN_NOEXCEPT;
        nn::Result GetGameCardStopper(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IGameCardStopper>> outValue) NN_NOEXCEPT;
        nn::Result IsSystemProgramInstalled(nn::sf::Out<bool> outValue, nn::ncm::SystemProgramId id) NN_NOEXCEPT;
        nn::Result StartApplyDeltaTask(nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result GetRequestServerStopper(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IRequestServerStopper>> outValue) NN_NOEXCEPT;
        nn::Result GetBackgroundApplyDeltaStressTaskInfo(nn::sf::Out<nn::nim::BackgroundDownloadStressTaskInfo> outValue) NN_NOEXCEPT;
        nn::Result CancelApplicationApplyDelta(nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result ResumeApplicationApplyDelta(nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result CalculateApplicationApplyDeltaRequiredSize(nn::sf::Out<nn::ncm::StorageId> outStorage, nn::sf::Out<std::int64_t> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result ResumeAll() NN_NOEXCEPT;
        nn::Result GetStorageSize(nn::sf::Out<std::int64_t> outTotalSize, nn::sf::Out<std::int64_t> outFreeSize, nn::ncm::StorageId storage) NN_NOEXCEPT;
        nn::Result RequestDownloadApplication(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId applicationId, nn::ncm::StorageId storageId, bool forceDirectUpdate) NN_NOEXCEPT;
        nn::Result RequestDownloadAddOnContent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId id, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::StorageId storageId) NN_NOEXCEPT;
        nn::Result DownloadApplication(nn::ncm::ApplicationId applicationId, nn::ncm::StorageId storageId, bool forceDirectUpdate) NN_NOEXCEPT;
        nn::Result CheckApplicationResumeRights(nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result GetDynamicCommitEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
        nn::Result RequestUpdateApplication2(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        void EnableApplicationCrashReport(bool isEnable) NN_NOEXCEPT;
        bool IsApplicationCrashReportEnabled() NN_NOEXCEPT;
        nn::Result BoostSystemMemoryResourceLimit(std::int64_t boostSize) NN_NOEXCEPT;
        nn::Result DeprecatedLaunchApplication(nn::sf::Out<nn::os::ProcessId> outValue, nn::ncm::ApplicationId id, std::uint8_t programIndex) NN_NOEXCEPT;
        nn::Result GetRunningApplicationProgramId(nn::sf::Out<nn::ncm::ProgramId> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result GetMainApplicationProgramIndex(nn::sf::Out<std::uint8_t> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result LaunchApplication(nn::sf::Out<nn::os::ProcessId> outValue, const nn::ns::ApplicationLaunchInfo& info, std::uint8_t programIndex) NN_NOEXCEPT;
        nn::Result GetApplicationLaunchInfo(nn::sf::Out<nn::ns::ApplicationLaunchInfo> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result AcquireApplicationLaunchInfo(nn::sf::Out<nn::ns::ApplicationLaunchInfo> outValue, nn::os::ProcessId processId) NN_NOEXCEPT;
        nn::Result GetMainApplicationProgramIndexByApplicationLaunchInfo(nn::sf::Out<std::uint8_t> outValue, const nn::ns::ApplicationLaunchInfo& info) NN_NOEXCEPT;
        void EnableApplicationAllThreadDumpOnCrash(bool isEnabled) NN_NOEXCEPT;
        nn::Result ResetToFactorySettings() NN_NOEXCEPT;
        nn::Result ResetToFactorySettingsWithoutUserSaveData() NN_NOEXCEPT;
        nn::Result ResetToFactorySettingsForRefurbishment() NN_NOEXCEPT;
        nn::Result CalculateUserSaveDataStatistics(nn::sf::Out<nn::ns::UserSaveDataStatistics> pOut, const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result DeleteUserSaveDataAll(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IProgressMonitorForDeleteUserSaveDataAll>> pOut, const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result DeleteUserSystemSaveData(const nn::account::Uid& uid, nn::fs::SystemSaveDataId sysSaveId) NN_NOEXCEPT;
        nn::Result UnregisterNetworkServiceAccount(const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result UnregisterNetworkServiceAccountWithUserSaveDataDeletion(const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result GetApplicationShellEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT;
        nn::Result PopApplicationShellEventInfo(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationShellEventInfo>& outList) NN_NOEXCEPT;
        nn::Result LaunchLibraryApplet(nn::sf::Out<nn::os::ProcessId> outValue, nn::ncm::SystemProgramId id) NN_NOEXCEPT;
        nn::Result TerminateLibraryApplet(nn::os::ProcessId pid) NN_NOEXCEPT;
        nn::Result LaunchSystemApplet(nn::sf::Out<nn::os::ProcessId> outValue) NN_NOEXCEPT;
        nn::Result TerminateSystemApplet(nn::os::ProcessId pid) NN_NOEXCEPT;
        nn::Result LaunchOverlayApplet(nn::sf::Out<nn::os::ProcessId> outValue) NN_NOEXCEPT;
        nn::Result TerminateOverlayApplet(nn::os::ProcessId pid) NN_NOEXCEPT;
        nn::Result InvalidateAllApplicationControlCache() NN_NOEXCEPT;
        nn::Result RequestDownloadApplicationControlData(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result GetMaxApplicationControlCacheCount(nn::sf::Out<std::int32_t> outValue) NN_NOEXCEPT;
        nn::Result InvalidateApplicationControlCache(nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result ListApplicationControlCacheEntryInfo(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationControlCacheEntryInfo>& outList) NN_NOEXCEPT;
        nn::Result GetApplicationControlProperty(nn::sf::Out<nn::ns::ApplicationControlProperty> outValue, const nn::ns::ApplicationLaunchInfo& info, std::uint8_t programIndex) NN_NOEXCEPT;
        nn::Result RequestCheckGameCardRegistration(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId appId) NN_NOEXCEPT;
        nn::Result RequestGameCardRegistrationGoldPoint(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync, const nn::account::Uid& uid, nn::ncm::ApplicationId appId) NN_NOEXCEPT;
        nn::Result RequestRegisterGameCard(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, const nn::account::Uid& uid, nn::ncm::ApplicationId appId, std::int32_t goldPoint) NN_NOEXCEPT;
        nn::Result GetGameCardMountFailureEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
        nn::Result IsGameCardInserted(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result EnsureGameCardAccess() NN_NOEXCEPT;
        nn::Result GetLastGameCardMountFailureResult() NN_NOEXCEPT;
        nn::Result ListApplicationIdOnGameCard(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ApplicationId>& outList) NN_NOEXCEPT;
        nn::Result CountApplicationContentMeta(nn::sf::Out<std::int32_t> outValue, nn::ncm::ApplicationId appId) NN_NOEXCEPT;
        nn::Result ListApplicationContentMetaStatus(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationContentMetaStatus>& outList, nn::ncm::ApplicationId appId, std::int32_t offset) NN_NOEXCEPT;
        nn::Result ListAvailableAddOnContent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationContentMetaStatus>& outList, nn::ncm::ApplicationId appId, std::int32_t offset) NN_NOEXCEPT;
        nn::Result GetOwnedApplicationContentMetaStatus(nn::sf::Out<nn::ns::ApplicationContentMetaStatus> outValue, nn::ncm::ApplicationId appId, nn::Bit64 contentMetaId) NN_NOEXCEPT;
        nn::Result RegisterContentsExternalKey(nn::ncm::ApplicationId appId, nn::Bit64 contentMetaId) NN_NOEXCEPT;
        nn::Result ListApplicationContentMetaStatusWithRightsCheck(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationContentMetaStatus>& outList, nn::ncm::ApplicationId appId, std::int32_t offset) NN_NOEXCEPT;
        nn::Result GetContentMetaStorage(nn::sf::Out<nn::ncm::StorageId> outValue, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT;
        nn::Result PushDownloadTaskList(const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
        nn::Result ClearTaskStatusList() NN_NOEXCEPT;
        nn::Result RequestDownloadTaskList() NN_NOEXCEPT;
        nn::Result RequestEnsureDownloadTask(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT;
        nn::Result ListDownloadTaskStatus(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::DownloadTaskStatus>& outList) NN_NOEXCEPT;
        nn::Result RequestDownloadTaskListData(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync) NN_NOEXCEPT;
        nn::Result RequestVersionList() NN_NOEXCEPT;
        nn::Result ListVersionList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::VersionListEntry>& versionListEntries) NN_NOEXCEPT;
        nn::Result RequestVersionListData(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync) NN_NOEXCEPT;
        nn::Result GetApplicationRecord(nn::sf::Out<nn::ns::ApplicationRecord> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result GetApplicationRecordProperty(nn::sf::Out<nn::ns::ApplicationRecordProperty> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result EnableApplicationAutoUpdate(nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result DisableApplicationAutoUpdate(nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result TouchApplication(nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result RequestApplicationUpdate(nn::ncm::ApplicationId id, nn::Bit32 resultInnerValue) NN_NOEXCEPT;
        nn::Result IsApplicationUpdateRequested(nn::sf::Out<bool> outValue, nn::sf::Out<nn::Bit32> resultInnerValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result WithdrawApplicationUpdateRequest(nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result ListApplicationRecordInstalledContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, nn::ncm::ApplicationId id, std::int32_t offset) NN_NOEXCEPT;
        nn::Result WithdrawCleanupAddOnContentsWithNoRightsRecommendation(nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result HasApplicationRecord(nn::sf::Out<bool> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result SetPreInstalledApplication(nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result ClearPreInstalledApplicationFlag(nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result RequestVerifyApplicationDeprecated(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IProgressAsyncResult>> outAsync, nn::ncm::ApplicationId id, nn::sf::NativeHandle&& transferHandle, std::uint64_t transferSize) NN_NOEXCEPT;
        nn::Result CorruptApplicationForDebug(nn::ncm::ApplicationId id, nn::Bit32 flags, nn::ncm::StorageId storageId) NN_NOEXCEPT;
        nn::Result RequestVerifyAddOnContentsRights(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IProgressAsyncResult>> outAsync, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result RequestVerifyApplication(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IProgressAsyncResult>> outAsync, nn::ncm::ApplicationId id, nn::Bit32 flags, nn::sf::NativeHandle&& transferHandle, std::uint64_t transferSize) NN_NOEXCEPT;
        nn::Result CorruptContentForDebug(const nn::ncm::ContentMetaKey& key, nn::ncm::StorageId storageId) NN_NOEXCEPT;
        nn::Result NeedsUpdateVulnerability(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result IsAnyApplicationEntityInstalled(nn::sf::Out<bool> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result DeleteApplicationContentEntities(nn::ncm::ApplicationId id, std::uint32_t innerValue, nn::ncm::StorageId storage) NN_NOEXCEPT;
        nn::Result CleanupUnrecordedApplicationEntity(nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result CleanupAddOnContentsWithNoRights(nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result DeleteApplicationContentEntity(const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT;
        nn::Result DeleteApplicationCompletelyForDebug(nn::ncm::ApplicationId id, std::uint32_t innerValue) NN_NOEXCEPT;
        nn::Result PrepareShutdown() NN_NOEXCEPT;
        nn::Result FormatSdCard() NN_NOEXCEPT;
        nn::Result NeedsSystemUpdateToFormatSdCard(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result GetLastSdCardFormatUnexpectedResult() NN_NOEXCEPT;
        nn::Result InsertSdCard() NN_NOEXCEPT;
        nn::Result RemoveSdCard() NN_NOEXCEPT;
        nn::Result GetSystemSeedForPseudoDeviceId(nn::sf::Out<nn::ns::SystemSeedForPseudoDeviceId> pOutSeed) NN_NOEXCEPT;
        nn::Result ResetSystemSeedForPseudoDeviceId() NN_NOEXCEPT;
        nn::Result ListApplicationDownloadingContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, nn::ncm::ApplicationId id, std::int32_t offset) NN_NOEXCEPT;
        nn::Result GetApplicationView(const nn::sf::OutArray<nn::ns::ApplicationView>& outList, const nn::sf::InArray<nn::ncm::ApplicationId>& idList) NN_NOEXCEPT;
        nn::Result GetApplicationDownloadTaskStatus(nn::sf::Out<nn::ns::ApplicationDownloadTaskStatus> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result GetApplicationViewDownloadErrorContext(nn::sf::Out<nn::err::ErrorContext> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result IsNotificationSetupCompleted(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result GetLastNotificationInfoCount(nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT;
        nn::Result ListLastNotificationInfo(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::NotificationInfo>& outList) NN_NOEXCEPT;
        nn::Result ListNotificationTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::AsyncTask>& outList) NN_NOEXCEPT;
        nn::Result IsActiveAccount(nn::sf::Out<bool> outValue, nn::es::AccountId accountId) NN_NOEXCEPT;
        nn::Result RequestDownloadApplicationPrepurchasedRights(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result GetApplicationTicketInfo(nn::sf::Out<nn::ns::ApplicationTicketInfo> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result GetSystemDeliveryInfo(nn::sf::Out<nn::ns::SystemDeliveryInfo> outValue) NN_NOEXCEPT;
        nn::Result SelectLatestSystemDeliveryInfo(nn::sf::Out<std::int32_t> outValue, const nn::sf::InArray<nn::ns::SystemDeliveryInfo>& list, const nn::ns::SystemDeliveryInfo& receiverSystemInfo, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& receiverAppInfo) NN_NOEXCEPT;
        nn::Result VerifyDeliveryProtocolVersion(const nn::ns::SystemDeliveryInfo& info) NN_NOEXCEPT;
        nn::Result GetApplicationDeliveryInfo(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationDeliveryInfo>& outValue, nn::ncm::ApplicationId id, nn::ns::ApplicationDeliveryAttribute attributes) NN_NOEXCEPT;
        nn::Result HasAllContentsToDeliver(nn::sf::Out<bool> outValue, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& appInfoList) NN_NOEXCEPT;
        nn::Result CompareApplicationDeliveryInfo(nn::sf::Out<std::int32_t> outValue, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& lhs, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& rhs) NN_NOEXCEPT;
        nn::Result CanDeliverApplication(nn::sf::Out<bool> outValue, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& receiverInfoList, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& senderInfoList) NN_NOEXCEPT;
        nn::Result ListContentMetaKeyToDeliverApplication(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ContentMetaKey>& outList, std::int32_t offset, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& infoList) NN_NOEXCEPT;
        nn::Result NeedsSystemUpdateToDeliverApplication(nn::sf::Out<bool> outValue, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& applicationInfoList, const nn::ns::SystemDeliveryInfo& systemInfo) NN_NOEXCEPT;
        nn::Result EstimateRequiredSize(nn::sf::Out<std::int64_t> outValue, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList) NN_NOEXCEPT;
        nn::Result RequestReceiveApplication(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, std::uint32_t ipv4, std::uint16_t port, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::ApplicationId id, nn::ncm::StorageId storageId) NN_NOEXCEPT;
        nn::Result CommitReceiveApplication(nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result GetReceiveApplicationProgress(nn::sf::Out<nn::ns::ReceiveApplicationProgress> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result RequestSendApplication(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, std::uint32_t ipv4, std::uint16_t port, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result GetSendApplicationProgress(nn::sf::Out<nn::ns::SendApplicationProgress> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result CompareSystemDeliveryInfo(nn::sf::Out<std::int32_t> outValue, const nn::ns::SystemDeliveryInfo& lhs, const nn::ns::SystemDeliveryInfo& rhs) NN_NOEXCEPT;
        nn::Result ListNotCommittedContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ContentMetaKey>& outList, nn::ncm::ApplicationId id, std::int32_t offset) NN_NOEXCEPT;
        nn::Result CreateDownloadTask(const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result GetApplicationDeliveryInfoHash(nn::sf::Out<nn::ns::ApplicationDeliveryInfoHash> outValue, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& infoList) NN_NOEXCEPT;
        nn::Result GetApplicationRightsOnClient(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationRightsOnClient>& outList, nn::ncm::ApplicationId appId, const nn::account::Uid& uid, nn::ns::ApplicationRightsOnClientQueryFlag flags) NN_NOEXCEPT;
        nn::Result GetApplicationTerminateResult(nn::sf::Out<std::uint32_t> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result GetRawApplicationTerminateResult(nn::sf::Out<std::uint32_t> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result CreateRightsEnvironment(nn::sf::Out<nn::ns::RightsEnvironmentHandle> pOut) NN_NOEXCEPT;
        nn::Result DestroyRightsEnvironment(nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT;
        nn::Result ActivateRightsEnvironment(nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT;
        nn::Result DeactivateRightsEnvironment(nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT;
        nn::Result AddTargetApplicationToRightsEnvironment(nn::ns::RightsEnvironmentHandle handle, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
        nn::Result SetUsersToRightsEnvironment(nn::ns::RightsEnvironmentHandle handle, bool anyUser, const nn::sf::InArray<nn::account::Uid>& uids) NN_NOEXCEPT;
        nn::Result GetRightsEnvironmentStatus(nn::sf::Out<nn::ns::RightsEnvironmentStatus> pOut, nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT;
        nn::Result GetGameCardApplicationCopyIdentifier(nn::sf::Out<nn::ns::GameCardApplicationCopyIdentifier> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result GetInstalledApplicationCopyIdentifier(nn::sf::Out<nn::ns::InstalledApplicationCopyIdentifier> outValue, nn::ncm::ApplicationId id, nn::ncm::StorageId storage) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result ListApplicationRecord(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationRecord>& outList, std::int32_t offset) NN_NOEXCEPT;
    nn::Result GenerateApplicationRecordCount(nn::sf::Out<std::int64_t> outCount) NN_NOEXCEPT;
    nn::Result GetApplicationRecordUpdateSystemEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT;
    nn::Result GetApplicationViewDeprecated(const nn::sf::OutArray<nn::ns::ApplicationViewDeprecated>& outList, const nn::sf::InArray<nn::ncm::ApplicationId>& idList) NN_NOEXCEPT;
    nn::Result DeleteApplicationEntity(nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result DeleteApplicationCompletely(nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result IsAnyApplicationEntityRedundant(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
    nn::Result DeleteRedundantApplicationEntity() NN_NOEXCEPT;
    nn::Result IsApplicationEntityMovable(nn::sf::Out<bool> outValue, nn::ncm::ApplicationId id, nn::ncm::StorageId storage) NN_NOEXCEPT;
    nn::Result MoveApplicationEntity(nn::ncm::ApplicationId id, nn::ncm::StorageId storage) NN_NOEXCEPT;
    nn::Result CalculateApplicationOccupiedSize(nn::sf::Out<nn::ns::ApplicationOccupiedSize> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result PushApplicationRecord(nn::ncm::ApplicationId id, nn::ns::ApplicationEvent appEvent, const nn::sf::InArray<nn::ncm::StorageContentMetaKey>& keyList) NN_NOEXCEPT;
    nn::Result ListApplicationRecordContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, nn::ncm::ApplicationId id, std::int32_t offset) NN_NOEXCEPT;
    nn::Result GetApplicationContentPath(nn::sf::Out<nn::ncm::Path> outValue, nn::ncm::ApplicationId id, nn::ncm::ContentType type) NN_NOEXCEPT;
    nn::Result TerminateApplication(nn::os::ProcessId pid) NN_NOEXCEPT;
    nn::Result ResolveApplicationContentPath(nn::ncm::ProgramId id, nn::ncm::ContentType type) NN_NOEXCEPT;
    nn::Result BeginInstallApplication(nn::ncm::ApplicationId id, std::uint32_t version, nn::ncm::StorageId storageId) NN_NOEXCEPT;
    nn::Result DeleteApplicationRecord(nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result RequestApplicationUpdateInfo(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result CancelApplicationDownload(nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result ResumeApplicationDownload(nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result UpdateVersionList(const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
    nn::Result PushLaunchVersion(nn::ncm::ApplicationId id, std::uint32_t version) NN_NOEXCEPT;
    nn::Result ListRequiredVersion(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::RequiredVersionEntry>& requiredVersionEntries) NN_NOEXCEPT;
    nn::Result CheckApplicationLaunchVersion(nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result CheckApplicationLaunchRights(nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result GetApplicationLogoData(nn::sf::Out<std::int64_t> outSize, const nn::sf::OutBuffer& outBuffer, nn::ncm::ApplicationId id, const nn::ncm::Path& logoPath) NN_NOEXCEPT;
    nn::Result CalculateApplicationDownloadRequiredSize(nn::sf::Out<nn::ncm::StorageId> outStorage, nn::sf::Out<std::int64_t> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result CleanupSdCard() NN_NOEXCEPT;
    nn::Result CheckSdCardMountStatus() NN_NOEXCEPT;
    nn::Result GetSdCardMountStatusChangedEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT;
    nn::Result GetGameCardAttachmentEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT;
    nn::Result GetGameCardAttachmentInfo(nn::sf::Out<nn::ns::GameCardAttachmentInfo> outValue) NN_NOEXCEPT;
    nn::Result GetTotalSpaceSize(nn::sf::Out<std::int64_t> outSize, nn::ncm::StorageId storage) NN_NOEXCEPT;
    nn::Result GetFreeSpaceSize(nn::sf::Out<std::int64_t> outSize, nn::ncm::StorageId storage) NN_NOEXCEPT;
    nn::Result GetSdCardRemovedEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT;
    nn::Result GetGameCardUpdateDetectionEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT;
    nn::Result DisableApplicationAutoDelete(nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result EnableApplicationAutoDelete(nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result SetApplicationTerminateResult(nn::ncm::ApplicationId id, std::uint32_t result) NN_NOEXCEPT;
    nn::Result ClearApplicationTerminateResult(nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result GetLastSdCardMountUnexpectedResult() NN_NOEXCEPT;
    nn::Result GetBackgroundDownloadStressTaskInfo(nn::sf::Out<nn::nim::BackgroundDownloadStressTaskInfo> outValue) NN_NOEXCEPT;
    nn::Result GetGameCardStopper(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IGameCardStopper>> outValue) NN_NOEXCEPT;
    nn::Result IsSystemProgramInstalled(nn::sf::Out<bool> outValue, nn::ncm::SystemProgramId id) NN_NOEXCEPT;
    nn::Result StartApplyDeltaTask(nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result GetRequestServerStopper(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IRequestServerStopper>> outValue) NN_NOEXCEPT;
    nn::Result GetBackgroundApplyDeltaStressTaskInfo(nn::sf::Out<nn::nim::BackgroundDownloadStressTaskInfo> outValue) NN_NOEXCEPT;
    nn::Result CancelApplicationApplyDelta(nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result ResumeApplicationApplyDelta(nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result CalculateApplicationApplyDeltaRequiredSize(nn::sf::Out<nn::ncm::StorageId> outStorage, nn::sf::Out<std::int64_t> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result ResumeAll() NN_NOEXCEPT;
    nn::Result GetStorageSize(nn::sf::Out<std::int64_t> outTotalSize, nn::sf::Out<std::int64_t> outFreeSize, nn::ncm::StorageId storage) NN_NOEXCEPT;
    nn::Result RequestDownloadApplication(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId applicationId, nn::ncm::StorageId storageId, bool forceDirectUpdate) NN_NOEXCEPT;
    nn::Result RequestDownloadAddOnContent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId id, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::StorageId storageId) NN_NOEXCEPT;
    nn::Result DownloadApplication(nn::ncm::ApplicationId applicationId, nn::ncm::StorageId storageId, bool forceDirectUpdate) NN_NOEXCEPT;
    nn::Result CheckApplicationResumeRights(nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result GetDynamicCommitEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
    nn::Result RequestUpdateApplication2(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    void EnableApplicationCrashReport(bool isEnable) NN_NOEXCEPT;
    bool IsApplicationCrashReportEnabled() NN_NOEXCEPT;
    nn::Result BoostSystemMemoryResourceLimit(std::int64_t boostSize) NN_NOEXCEPT;
    nn::Result DeprecatedLaunchApplication(nn::sf::Out<nn::os::ProcessId> outValue, nn::ncm::ApplicationId id, std::uint8_t programIndex) NN_NOEXCEPT;
    nn::Result GetRunningApplicationProgramId(nn::sf::Out<nn::ncm::ProgramId> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result GetMainApplicationProgramIndex(nn::sf::Out<std::uint8_t> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result LaunchApplication(nn::sf::Out<nn::os::ProcessId> outValue, const nn::ns::ApplicationLaunchInfo& info, std::uint8_t programIndex) NN_NOEXCEPT;
    nn::Result GetApplicationLaunchInfo(nn::sf::Out<nn::ns::ApplicationLaunchInfo> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result AcquireApplicationLaunchInfo(nn::sf::Out<nn::ns::ApplicationLaunchInfo> outValue, nn::os::ProcessId processId) NN_NOEXCEPT;
    nn::Result GetMainApplicationProgramIndexByApplicationLaunchInfo(nn::sf::Out<std::uint8_t> outValue, const nn::ns::ApplicationLaunchInfo& info) NN_NOEXCEPT;
    void EnableApplicationAllThreadDumpOnCrash(bool isEnabled) NN_NOEXCEPT;
    nn::Result ResetToFactorySettings() NN_NOEXCEPT;
    nn::Result ResetToFactorySettingsWithoutUserSaveData() NN_NOEXCEPT;
    nn::Result ResetToFactorySettingsForRefurbishment() NN_NOEXCEPT;
    nn::Result CalculateUserSaveDataStatistics(nn::sf::Out<nn::ns::UserSaveDataStatistics> pOut, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result DeleteUserSaveDataAll(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IProgressMonitorForDeleteUserSaveDataAll>> pOut, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result DeleteUserSystemSaveData(const nn::account::Uid& uid, nn::fs::SystemSaveDataId sysSaveId) NN_NOEXCEPT;
    nn::Result UnregisterNetworkServiceAccount(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result UnregisterNetworkServiceAccountWithUserSaveDataDeletion(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result GetApplicationShellEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT;
    nn::Result PopApplicationShellEventInfo(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationShellEventInfo>& outList) NN_NOEXCEPT;
    nn::Result LaunchLibraryApplet(nn::sf::Out<nn::os::ProcessId> outValue, nn::ncm::SystemProgramId id) NN_NOEXCEPT;
    nn::Result TerminateLibraryApplet(nn::os::ProcessId pid) NN_NOEXCEPT;
    nn::Result LaunchSystemApplet(nn::sf::Out<nn::os::ProcessId> outValue) NN_NOEXCEPT;
    nn::Result TerminateSystemApplet(nn::os::ProcessId pid) NN_NOEXCEPT;
    nn::Result LaunchOverlayApplet(nn::sf::Out<nn::os::ProcessId> outValue) NN_NOEXCEPT;
    nn::Result TerminateOverlayApplet(nn::os::ProcessId pid) NN_NOEXCEPT;
    nn::Result InvalidateAllApplicationControlCache() NN_NOEXCEPT;
    nn::Result RequestDownloadApplicationControlData(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result GetMaxApplicationControlCacheCount(nn::sf::Out<std::int32_t> outValue) NN_NOEXCEPT;
    nn::Result InvalidateApplicationControlCache(nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result ListApplicationControlCacheEntryInfo(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationControlCacheEntryInfo>& outList) NN_NOEXCEPT;
    nn::Result GetApplicationControlProperty(nn::sf::Out<nn::ns::ApplicationControlProperty> outValue, const nn::ns::ApplicationLaunchInfo& info, std::uint8_t programIndex) NN_NOEXCEPT;
    nn::Result RequestCheckGameCardRegistration(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId appId) NN_NOEXCEPT;
    nn::Result RequestGameCardRegistrationGoldPoint(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync, const nn::account::Uid& uid, nn::ncm::ApplicationId appId) NN_NOEXCEPT;
    nn::Result RequestRegisterGameCard(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, const nn::account::Uid& uid, nn::ncm::ApplicationId appId, std::int32_t goldPoint) NN_NOEXCEPT;
    nn::Result GetGameCardMountFailureEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
    nn::Result IsGameCardInserted(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
    nn::Result EnsureGameCardAccess() NN_NOEXCEPT;
    nn::Result GetLastGameCardMountFailureResult() NN_NOEXCEPT;
    nn::Result ListApplicationIdOnGameCard(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ApplicationId>& outList) NN_NOEXCEPT;
    nn::Result CountApplicationContentMeta(nn::sf::Out<std::int32_t> outValue, nn::ncm::ApplicationId appId) NN_NOEXCEPT;
    nn::Result ListApplicationContentMetaStatus(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationContentMetaStatus>& outList, nn::ncm::ApplicationId appId, std::int32_t offset) NN_NOEXCEPT;
    nn::Result ListAvailableAddOnContent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationContentMetaStatus>& outList, nn::ncm::ApplicationId appId, std::int32_t offset) NN_NOEXCEPT;
    nn::Result GetOwnedApplicationContentMetaStatus(nn::sf::Out<nn::ns::ApplicationContentMetaStatus> outValue, nn::ncm::ApplicationId appId, nn::Bit64 contentMetaId) NN_NOEXCEPT;
    nn::Result RegisterContentsExternalKey(nn::ncm::ApplicationId appId, nn::Bit64 contentMetaId) NN_NOEXCEPT;
    nn::Result ListApplicationContentMetaStatusWithRightsCheck(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationContentMetaStatus>& outList, nn::ncm::ApplicationId appId, std::int32_t offset) NN_NOEXCEPT;
    nn::Result GetContentMetaStorage(nn::sf::Out<nn::ncm::StorageId> outValue, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT;
    nn::Result PushDownloadTaskList(const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
    nn::Result ClearTaskStatusList() NN_NOEXCEPT;
    nn::Result RequestDownloadTaskList() NN_NOEXCEPT;
    nn::Result RequestEnsureDownloadTask(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT;
    nn::Result ListDownloadTaskStatus(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::DownloadTaskStatus>& outList) NN_NOEXCEPT;
    nn::Result RequestDownloadTaskListData(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync) NN_NOEXCEPT;
    nn::Result RequestVersionList() NN_NOEXCEPT;
    nn::Result ListVersionList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::VersionListEntry>& versionListEntries) NN_NOEXCEPT;
    nn::Result RequestVersionListData(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync) NN_NOEXCEPT;
    nn::Result GetApplicationRecord(nn::sf::Out<nn::ns::ApplicationRecord> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result GetApplicationRecordProperty(nn::sf::Out<nn::ns::ApplicationRecordProperty> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result EnableApplicationAutoUpdate(nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result DisableApplicationAutoUpdate(nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result TouchApplication(nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result RequestApplicationUpdate(nn::ncm::ApplicationId id, nn::Bit32 resultInnerValue) NN_NOEXCEPT;
    nn::Result IsApplicationUpdateRequested(nn::sf::Out<bool> outValue, nn::sf::Out<nn::Bit32> resultInnerValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result WithdrawApplicationUpdateRequest(nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result ListApplicationRecordInstalledContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, nn::ncm::ApplicationId id, std::int32_t offset) NN_NOEXCEPT;
    nn::Result WithdrawCleanupAddOnContentsWithNoRightsRecommendation(nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result HasApplicationRecord(nn::sf::Out<bool> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result SetPreInstalledApplication(nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result ClearPreInstalledApplicationFlag(nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result RequestVerifyApplicationDeprecated(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IProgressAsyncResult>> outAsync, nn::ncm::ApplicationId id, nn::sf::NativeHandle&& transferHandle, std::uint64_t transferSize) NN_NOEXCEPT;
    nn::Result CorruptApplicationForDebug(nn::ncm::ApplicationId id, nn::Bit32 flags, nn::ncm::StorageId storageId) NN_NOEXCEPT;
    nn::Result RequestVerifyAddOnContentsRights(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IProgressAsyncResult>> outAsync, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result RequestVerifyApplication(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IProgressAsyncResult>> outAsync, nn::ncm::ApplicationId id, nn::Bit32 flags, nn::sf::NativeHandle&& transferHandle, std::uint64_t transferSize) NN_NOEXCEPT;
    nn::Result CorruptContentForDebug(const nn::ncm::ContentMetaKey& key, nn::ncm::StorageId storageId) NN_NOEXCEPT;
    nn::Result NeedsUpdateVulnerability(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
    nn::Result IsAnyApplicationEntityInstalled(nn::sf::Out<bool> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result DeleteApplicationContentEntities(nn::ncm::ApplicationId id, std::uint32_t innerValue, nn::ncm::StorageId storage) NN_NOEXCEPT;
    nn::Result CleanupUnrecordedApplicationEntity(nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result CleanupAddOnContentsWithNoRights(nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result DeleteApplicationContentEntity(const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT;
    nn::Result DeleteApplicationCompletelyForDebug(nn::ncm::ApplicationId id, std::uint32_t innerValue) NN_NOEXCEPT;
    nn::Result PrepareShutdown() NN_NOEXCEPT;
    nn::Result FormatSdCard() NN_NOEXCEPT;
    nn::Result NeedsSystemUpdateToFormatSdCard(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
    nn::Result GetLastSdCardFormatUnexpectedResult() NN_NOEXCEPT;
    nn::Result InsertSdCard() NN_NOEXCEPT;
    nn::Result RemoveSdCard() NN_NOEXCEPT;
    nn::Result GetSystemSeedForPseudoDeviceId(nn::sf::Out<nn::ns::SystemSeedForPseudoDeviceId> pOutSeed) NN_NOEXCEPT;
    nn::Result ResetSystemSeedForPseudoDeviceId() NN_NOEXCEPT;
    nn::Result ListApplicationDownloadingContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, nn::ncm::ApplicationId id, std::int32_t offset) NN_NOEXCEPT;
    nn::Result GetApplicationView(const nn::sf::OutArray<nn::ns::ApplicationView>& outList, const nn::sf::InArray<nn::ncm::ApplicationId>& idList) NN_NOEXCEPT;
    nn::Result GetApplicationDownloadTaskStatus(nn::sf::Out<nn::ns::ApplicationDownloadTaskStatus> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result GetApplicationViewDownloadErrorContext(nn::sf::Out<nn::err::ErrorContext> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result IsNotificationSetupCompleted(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
    nn::Result GetLastNotificationInfoCount(nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT;
    nn::Result ListLastNotificationInfo(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::NotificationInfo>& outList) NN_NOEXCEPT;
    nn::Result ListNotificationTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::AsyncTask>& outList) NN_NOEXCEPT;
    nn::Result IsActiveAccount(nn::sf::Out<bool> outValue, nn::es::AccountId accountId) NN_NOEXCEPT;
    nn::Result RequestDownloadApplicationPrepurchasedRights(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result GetApplicationTicketInfo(nn::sf::Out<nn::ns::ApplicationTicketInfo> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result GetSystemDeliveryInfo(nn::sf::Out<nn::ns::SystemDeliveryInfo> outValue) NN_NOEXCEPT;
    nn::Result SelectLatestSystemDeliveryInfo(nn::sf::Out<std::int32_t> outValue, const nn::sf::InArray<nn::ns::SystemDeliveryInfo>& list, const nn::ns::SystemDeliveryInfo& receiverSystemInfo, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& receiverAppInfo) NN_NOEXCEPT;
    nn::Result VerifyDeliveryProtocolVersion(const nn::ns::SystemDeliveryInfo& info) NN_NOEXCEPT;
    nn::Result GetApplicationDeliveryInfo(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationDeliveryInfo>& outValue, nn::ncm::ApplicationId id, nn::ns::ApplicationDeliveryAttribute attributes) NN_NOEXCEPT;
    nn::Result HasAllContentsToDeliver(nn::sf::Out<bool> outValue, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& appInfoList) NN_NOEXCEPT;
    nn::Result CompareApplicationDeliveryInfo(nn::sf::Out<std::int32_t> outValue, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& lhs, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& rhs) NN_NOEXCEPT;
    nn::Result CanDeliverApplication(nn::sf::Out<bool> outValue, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& receiverInfoList, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& senderInfoList) NN_NOEXCEPT;
    nn::Result ListContentMetaKeyToDeliverApplication(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ContentMetaKey>& outList, std::int32_t offset, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& infoList) NN_NOEXCEPT;
    nn::Result NeedsSystemUpdateToDeliverApplication(nn::sf::Out<bool> outValue, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& applicationInfoList, const nn::ns::SystemDeliveryInfo& systemInfo) NN_NOEXCEPT;
    nn::Result EstimateRequiredSize(nn::sf::Out<std::int64_t> outValue, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList) NN_NOEXCEPT;
    nn::Result RequestReceiveApplication(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, std::uint32_t ipv4, std::uint16_t port, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::ApplicationId id, nn::ncm::StorageId storageId) NN_NOEXCEPT;
    nn::Result CommitReceiveApplication(nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result GetReceiveApplicationProgress(nn::sf::Out<nn::ns::ReceiveApplicationProgress> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result RequestSendApplication(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, std::uint32_t ipv4, std::uint16_t port, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result GetSendApplicationProgress(nn::sf::Out<nn::ns::SendApplicationProgress> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result CompareSystemDeliveryInfo(nn::sf::Out<std::int32_t> outValue, const nn::ns::SystemDeliveryInfo& lhs, const nn::ns::SystemDeliveryInfo& rhs) NN_NOEXCEPT;
    nn::Result ListNotCommittedContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ContentMetaKey>& outList, nn::ncm::ApplicationId id, std::int32_t offset) NN_NOEXCEPT;
    nn::Result CreateDownloadTask(const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result GetApplicationDeliveryInfoHash(nn::sf::Out<nn::ns::ApplicationDeliveryInfoHash> outValue, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& infoList) NN_NOEXCEPT;
    nn::Result GetApplicationRightsOnClient(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationRightsOnClient>& outList, nn::ncm::ApplicationId appId, const nn::account::Uid& uid, nn::ns::ApplicationRightsOnClientQueryFlag flags) NN_NOEXCEPT;
    nn::Result GetApplicationTerminateResult(nn::sf::Out<std::uint32_t> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result GetRawApplicationTerminateResult(nn::sf::Out<std::uint32_t> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result CreateRightsEnvironment(nn::sf::Out<nn::ns::RightsEnvironmentHandle> pOut) NN_NOEXCEPT;
    nn::Result DestroyRightsEnvironment(nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT;
    nn::Result ActivateRightsEnvironment(nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT;
    nn::Result DeactivateRightsEnvironment(nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT;
    nn::Result AddTargetApplicationToRightsEnvironment(nn::ns::RightsEnvironmentHandle handle, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
    nn::Result SetUsersToRightsEnvironment(nn::ns::RightsEnvironmentHandle handle, bool anyUser, const nn::sf::InArray<nn::account::Uid>& uids) NN_NOEXCEPT;
    nn::Result GetRightsEnvironmentStatus(nn::sf::Out<nn::ns::RightsEnvironmentStatus> pOut, nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT;
    nn::Result GetGameCardApplicationCopyIdentifier(nn::sf::Out<nn::ns::GameCardApplicationCopyIdentifier> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result GetInstalledApplicationCopyIdentifier(nn::sf::Out<nn::ns::InstalledApplicationCopyIdentifier> outValue, nn::ncm::ApplicationId id, nn::ncm::StorageId storage) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ns::detail::IApplicationManagerInterface))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationRecord, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationRecord>& outList, ::std::int32_t offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListApplicationRecord, (outCount, outList, offset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GenerateApplicationRecordCount, (::nn::sf::Out<::std::int64_t> outCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GenerateApplicationRecordCount, (outCount));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationRecordUpdateSystemEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetApplicationRecordUpdateSystemEvent, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationViewDeprecated, (const ::nn::sf::OutArray<::nn::ns::ApplicationViewDeprecated>& outList, const ::nn::sf::InArray<::nn::ncm::ApplicationId>& idList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetApplicationViewDeprecated, (outList, idList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteApplicationEntity, (::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteApplicationEntity, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteApplicationCompletely, (::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteApplicationCompletely, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsAnyApplicationEntityRedundant, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsAnyApplicationEntityRedundant, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeleteRedundantApplicationEntity)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DeleteRedundantApplicationEntity);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsApplicationEntityMovable, (::nn::sf::Out<bool> outValue, ::nn::ncm::ApplicationId id, ::nn::ncm::StorageId storage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsApplicationEntityMovable, (outValue, id, storage));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(MoveApplicationEntity, (::nn::ncm::ApplicationId id, ::nn::ncm::StorageId storage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(MoveApplicationEntity, (id, storage));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CalculateApplicationOccupiedSize, (::nn::sf::Out<::nn::ns::ApplicationOccupiedSize> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CalculateApplicationOccupiedSize, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PushApplicationRecord, (::nn::ncm::ApplicationId id, ::nn::ns::ApplicationEvent appEvent, const ::nn::sf::InArray<::nn::ncm::StorageContentMetaKey>& keyList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PushApplicationRecord, (id, appEvent, keyList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationRecordContentMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::nn::ncm::ApplicationId id, ::std::int32_t offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListApplicationRecordContentMeta, (outCount, outList, id, offset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationContentPath, (::nn::sf::Out<::nn::ncm::Path> outValue, ::nn::ncm::ApplicationId id, ::nn::ncm::ContentType type))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetApplicationContentPath, (outValue, id, type));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TerminateApplication, (::nn::os::ProcessId pid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TerminateApplication, (pid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResolveApplicationContentPath, (::nn::ncm::ProgramId id, ::nn::ncm::ContentType type))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ResolveApplicationContentPath, (id, type));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BeginInstallApplication, (::nn::ncm::ApplicationId id, ::std::uint32_t version, ::nn::ncm::StorageId storageId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BeginInstallApplication, (id, version, storageId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteApplicationRecord, (::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteApplicationRecord, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestApplicationUpdateInfo, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestApplicationUpdateInfo, (outHandle, outAsync, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelApplicationDownload, (::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CancelApplicationDownload, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResumeApplicationDownload, (::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ResumeApplicationDownload, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpdateVersionList, (const ::nn::sf::InBuffer& buffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UpdateVersionList, (buffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PushLaunchVersion, (::nn::ncm::ApplicationId id, ::std::uint32_t version))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PushLaunchVersion, (id, version));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListRequiredVersion, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::RequiredVersionEntry>& requiredVersionEntries))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListRequiredVersion, (outCount, requiredVersionEntries));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckApplicationLaunchVersion, (::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CheckApplicationLaunchVersion, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckApplicationLaunchRights, (::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CheckApplicationLaunchRights, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationLogoData, (::nn::sf::Out<::std::int64_t> outSize, const ::nn::sf::OutBuffer& outBuffer, ::nn::ncm::ApplicationId id, const ::nn::ncm::Path& logoPath))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetApplicationLogoData, (outSize, outBuffer, id, logoPath));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CalculateApplicationDownloadRequiredSize, (::nn::sf::Out<::nn::ncm::StorageId> outStorage, ::nn::sf::Out<::std::int64_t> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CalculateApplicationDownloadRequiredSize, (outStorage, outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CleanupSdCard)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CleanupSdCard);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CheckSdCardMountStatus)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CheckSdCardMountStatus);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSdCardMountStatusChangedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSdCardMountStatusChangedEvent, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardAttachmentEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetGameCardAttachmentEvent, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardAttachmentInfo, (::nn::sf::Out<::nn::ns::GameCardAttachmentInfo> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetGameCardAttachmentInfo, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTotalSpaceSize, (::nn::sf::Out<::std::int64_t> outSize, ::nn::ncm::StorageId storage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetTotalSpaceSize, (outSize, storage));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFreeSpaceSize, (::nn::sf::Out<::std::int64_t> outSize, ::nn::ncm::StorageId storage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFreeSpaceSize, (outSize, storage));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSdCardRemovedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSdCardRemovedEvent, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardUpdateDetectionEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetGameCardUpdateDetectionEvent, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DisableApplicationAutoDelete, (::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DisableApplicationAutoDelete, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnableApplicationAutoDelete, (::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EnableApplicationAutoDelete, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetApplicationTerminateResult, (::nn::ncm::ApplicationId id, ::std::uint32_t result))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetApplicationTerminateResult, (id, result));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ClearApplicationTerminateResult, (::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ClearApplicationTerminateResult, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(GetLastSdCardMountUnexpectedResult)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(GetLastSdCardMountUnexpectedResult);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBackgroundDownloadStressTaskInfo, (::nn::sf::Out<::nn::nim::BackgroundDownloadStressTaskInfo> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetBackgroundDownloadStressTaskInfo, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardStopper, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IGameCardStopper>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetGameCardStopper, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsSystemProgramInstalled, (::nn::sf::Out<bool> outValue, ::nn::ncm::SystemProgramId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsSystemProgramInstalled, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartApplyDeltaTask, (::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartApplyDeltaTask, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRequestServerStopper, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IRequestServerStopper>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRequestServerStopper, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBackgroundApplyDeltaStressTaskInfo, (::nn::sf::Out<::nn::nim::BackgroundDownloadStressTaskInfo> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetBackgroundApplyDeltaStressTaskInfo, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelApplicationApplyDelta, (::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CancelApplicationApplyDelta, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResumeApplicationApplyDelta, (::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ResumeApplicationApplyDelta, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CalculateApplicationApplyDeltaRequiredSize, (::nn::sf::Out<::nn::ncm::StorageId> outStorage, ::nn::sf::Out<::std::int64_t> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CalculateApplicationApplyDeltaRequiredSize, (outStorage, outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ResumeAll)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ResumeAll);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStorageSize, (::nn::sf::Out<::std::int64_t> outTotalSize, ::nn::sf::Out<::std::int64_t> outFreeSize, ::nn::ncm::StorageId storage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetStorageSize, (outTotalSize, outFreeSize, storage));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestDownloadApplication, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId applicationId, ::nn::ncm::StorageId storageId, bool forceDirectUpdate))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestDownloadApplication, (outHandle, outAsync, applicationId, storageId, forceDirectUpdate));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestDownloadAddOnContent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId id, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::StorageId storageId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestDownloadAddOnContent, (outHandle, outAsync, id, keyList, storageId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DownloadApplication, (::nn::ncm::ApplicationId applicationId, ::nn::ncm::StorageId storageId, bool forceDirectUpdate))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DownloadApplication, (applicationId, storageId, forceDirectUpdate));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckApplicationResumeRights, (::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CheckApplicationResumeRights, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDynamicCommitEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDynamicCommitEvent, (outHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestUpdateApplication2, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestUpdateApplication2, (outHandle, outAsync, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(EnableApplicationCrashReport, (bool isEnable))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(EnableApplicationCrashReport, (isEnable));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(IsApplicationCrashReportEnabled, (bool))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_0(IsApplicationCrashReportEnabled, (bool));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BoostSystemMemoryResourceLimit, (::std::int64_t boostSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(BoostSystemMemoryResourceLimit, (boostSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeprecatedLaunchApplication, (::nn::sf::Out<::nn::os::ProcessId> outValue, ::nn::ncm::ApplicationId id, ::std::uint8_t programIndex))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeprecatedLaunchApplication, (outValue, id, programIndex));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRunningApplicationProgramId, (::nn::sf::Out<::nn::ncm::ProgramId> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRunningApplicationProgramId, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMainApplicationProgramIndex, (::nn::sf::Out<::std::uint8_t> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetMainApplicationProgramIndex, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LaunchApplication, (::nn::sf::Out<::nn::os::ProcessId> outValue, const ::nn::ns::ApplicationLaunchInfo& info, ::std::uint8_t programIndex))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LaunchApplication, (outValue, info, programIndex));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationLaunchInfo, (::nn::sf::Out<::nn::ns::ApplicationLaunchInfo> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetApplicationLaunchInfo, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcquireApplicationLaunchInfo, (::nn::sf::Out<::nn::ns::ApplicationLaunchInfo> outValue, ::nn::os::ProcessId processId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AcquireApplicationLaunchInfo, (outValue, processId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMainApplicationProgramIndexByApplicationLaunchInfo, (::nn::sf::Out<::std::uint8_t> outValue, const ::nn::ns::ApplicationLaunchInfo& info))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetMainApplicationProgramIndexByApplicationLaunchInfo, (outValue, info));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(EnableApplicationAllThreadDumpOnCrash, (bool isEnabled))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_N(EnableApplicationAllThreadDumpOnCrash, (isEnabled));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ResetToFactorySettings)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ResetToFactorySettings);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ResetToFactorySettingsWithoutUserSaveData)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ResetToFactorySettingsWithoutUserSaveData);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ResetToFactorySettingsForRefurbishment)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ResetToFactorySettingsForRefurbishment);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CalculateUserSaveDataStatistics, (::nn::sf::Out<::nn::ns::UserSaveDataStatistics> pOut, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CalculateUserSaveDataStatistics, (pOut, uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteUserSaveDataAll, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IProgressMonitorForDeleteUserSaveDataAll>> pOut, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteUserSaveDataAll, (pOut, uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteUserSystemSaveData, (const ::nn::account::Uid& uid, ::nn::fs::SystemSaveDataId sysSaveId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteUserSystemSaveData, (uid, sysSaveId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterNetworkServiceAccount, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnregisterNetworkServiceAccount, (uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterNetworkServiceAccountWithUserSaveDataDeletion, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UnregisterNetworkServiceAccountWithUserSaveDataDeletion, (uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationShellEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetApplicationShellEvent, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PopApplicationShellEventInfo, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationShellEventInfo>& outList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PopApplicationShellEventInfo, (outCount, outList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LaunchLibraryApplet, (::nn::sf::Out<::nn::os::ProcessId> outValue, ::nn::ncm::SystemProgramId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LaunchLibraryApplet, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TerminateLibraryApplet, (::nn::os::ProcessId pid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TerminateLibraryApplet, (pid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LaunchSystemApplet, (::nn::sf::Out<::nn::os::ProcessId> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LaunchSystemApplet, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TerminateSystemApplet, (::nn::os::ProcessId pid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TerminateSystemApplet, (pid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LaunchOverlayApplet, (::nn::sf::Out<::nn::os::ProcessId> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LaunchOverlayApplet, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TerminateOverlayApplet, (::nn::os::ProcessId pid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TerminateOverlayApplet, (pid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(InvalidateAllApplicationControlCache)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(InvalidateAllApplicationControlCache);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestDownloadApplicationControlData, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestDownloadApplicationControlData, (outHandle, outAsync, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMaxApplicationControlCacheCount, (::nn::sf::Out<::std::int32_t> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetMaxApplicationControlCacheCount, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InvalidateApplicationControlCache, (::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(InvalidateApplicationControlCache, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationControlCacheEntryInfo, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationControlCacheEntryInfo>& outList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListApplicationControlCacheEntryInfo, (outCount, outList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationControlProperty, (::nn::sf::Out<::nn::ns::ApplicationControlProperty> outValue, const ::nn::ns::ApplicationLaunchInfo& info, ::std::uint8_t programIndex))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetApplicationControlProperty, (outValue, info, programIndex));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestCheckGameCardRegistration, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId appId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestCheckGameCardRegistration, (outHandle, outAsync, appId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestGameCardRegistrationGoldPoint, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync, const ::nn::account::Uid& uid, ::nn::ncm::ApplicationId appId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestGameCardRegistrationGoldPoint, (outHandle, outAsync, uid, appId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestRegisterGameCard, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, const ::nn::account::Uid& uid, ::nn::ncm::ApplicationId appId, ::std::int32_t goldPoint))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestRegisterGameCard, (outHandle, outAsync, uid, appId, goldPoint));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardMountFailureEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetGameCardMountFailureEvent, (outHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsGameCardInserted, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsGameCardInserted, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(EnsureGameCardAccess)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(EnsureGameCardAccess);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(GetLastGameCardMountFailureResult)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(GetLastGameCardMountFailureResult);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationIdOnGameCard, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ApplicationId>& outList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListApplicationIdOnGameCard, (outCount, outList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CountApplicationContentMeta, (::nn::sf::Out<::std::int32_t> outValue, ::nn::ncm::ApplicationId appId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CountApplicationContentMeta, (outValue, appId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationContentMetaStatus, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationContentMetaStatus>& outList, ::nn::ncm::ApplicationId appId, ::std::int32_t offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListApplicationContentMetaStatus, (outCount, outList, appId, offset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListAvailableAddOnContent, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationContentMetaStatus>& outList, ::nn::ncm::ApplicationId appId, ::std::int32_t offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListAvailableAddOnContent, (outCount, outList, appId, offset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetOwnedApplicationContentMetaStatus, (::nn::sf::Out<::nn::ns::ApplicationContentMetaStatus> outValue, ::nn::ncm::ApplicationId appId, ::nn::Bit64 contentMetaId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetOwnedApplicationContentMetaStatus, (outValue, appId, contentMetaId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterContentsExternalKey, (::nn::ncm::ApplicationId appId, ::nn::Bit64 contentMetaId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterContentsExternalKey, (appId, contentMetaId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationContentMetaStatusWithRightsCheck, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationContentMetaStatus>& outList, ::nn::ncm::ApplicationId appId, ::std::int32_t offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListApplicationContentMetaStatusWithRightsCheck, (outCount, outList, appId, offset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetContentMetaStorage, (::nn::sf::Out<::nn::ncm::StorageId> outValue, const ::nn::ncm::ContentMetaKey& key))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetContentMetaStorage, (outValue, key));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PushDownloadTaskList, (const ::nn::sf::InBuffer& buffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PushDownloadTaskList, (buffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ClearTaskStatusList)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ClearTaskStatusList);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RequestDownloadTaskList)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(RequestDownloadTaskList);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestEnsureDownloadTask, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestEnsureDownloadTask, (outHandle, outAsync));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListDownloadTaskStatus, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::DownloadTaskStatus>& outList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListDownloadTaskStatus, (outCount, outList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestDownloadTaskListData, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestDownloadTaskListData, (outHandle, outAsync));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RequestVersionList)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(RequestVersionList);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListVersionList, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::VersionListEntry>& versionListEntries))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListVersionList, (outCount, versionListEntries));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestVersionListData, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestVersionListData, (outHandle, outAsync));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationRecord, (::nn::sf::Out<::nn::ns::ApplicationRecord> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetApplicationRecord, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationRecordProperty, (::nn::sf::Out<::nn::ns::ApplicationRecordProperty> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetApplicationRecordProperty, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnableApplicationAutoUpdate, (::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EnableApplicationAutoUpdate, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DisableApplicationAutoUpdate, (::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DisableApplicationAutoUpdate, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TouchApplication, (::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(TouchApplication, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestApplicationUpdate, (::nn::ncm::ApplicationId id, ::nn::Bit32 resultInnerValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestApplicationUpdate, (id, resultInnerValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsApplicationUpdateRequested, (::nn::sf::Out<bool> outValue, ::nn::sf::Out<::nn::Bit32> resultInnerValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsApplicationUpdateRequested, (outValue, resultInnerValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WithdrawApplicationUpdateRequest, (::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(WithdrawApplicationUpdateRequest, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationRecordInstalledContentMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::nn::ncm::ApplicationId id, ::std::int32_t offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListApplicationRecordInstalledContentMeta, (outCount, outList, id, offset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WithdrawCleanupAddOnContentsWithNoRightsRecommendation, (::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(WithdrawCleanupAddOnContentsWithNoRightsRecommendation, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasApplicationRecord, (::nn::sf::Out<bool> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(HasApplicationRecord, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPreInstalledApplication, (::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetPreInstalledApplication, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ClearPreInstalledApplicationFlag, (::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ClearPreInstalledApplicationFlag, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestVerifyApplicationDeprecated, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IProgressAsyncResult>> outAsync, ::nn::ncm::ApplicationId id, ::nn::sf::NativeHandle&& transferHandle, ::std::uint64_t transferSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestVerifyApplicationDeprecated, (outHandle, outAsync, id, ::std::move(transferHandle), transferSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CorruptApplicationForDebug, (::nn::ncm::ApplicationId id, ::nn::Bit32 flags, ::nn::ncm::StorageId storageId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CorruptApplicationForDebug, (id, flags, storageId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestVerifyAddOnContentsRights, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IProgressAsyncResult>> outAsync, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestVerifyAddOnContentsRights, (outHandle, outAsync, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestVerifyApplication, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IProgressAsyncResult>> outAsync, ::nn::ncm::ApplicationId id, ::nn::Bit32 flags, ::nn::sf::NativeHandle&& transferHandle, ::std::uint64_t transferSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestVerifyApplication, (outHandle, outAsync, id, flags, ::std::move(transferHandle), transferSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CorruptContentForDebug, (const ::nn::ncm::ContentMetaKey& key, ::nn::ncm::StorageId storageId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CorruptContentForDebug, (key, storageId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NeedsUpdateVulnerability, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(NeedsUpdateVulnerability, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsAnyApplicationEntityInstalled, (::nn::sf::Out<bool> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsAnyApplicationEntityInstalled, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteApplicationContentEntities, (::nn::ncm::ApplicationId id, ::std::uint32_t innerValue, ::nn::ncm::StorageId storage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteApplicationContentEntities, (id, innerValue, storage));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CleanupUnrecordedApplicationEntity, (::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CleanupUnrecordedApplicationEntity, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CleanupAddOnContentsWithNoRights, (::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CleanupAddOnContentsWithNoRights, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteApplicationContentEntity, (const ::nn::ncm::ContentMetaKey& key))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteApplicationContentEntity, (key));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteApplicationCompletelyForDebug, (::nn::ncm::ApplicationId id, ::std::uint32_t innerValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteApplicationCompletelyForDebug, (id, innerValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(PrepareShutdown)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(PrepareShutdown);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(FormatSdCard)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(FormatSdCard);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NeedsSystemUpdateToFormatSdCard, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(NeedsSystemUpdateToFormatSdCard, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(GetLastSdCardFormatUnexpectedResult)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(GetLastSdCardFormatUnexpectedResult);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(InsertSdCard)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(InsertSdCard);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RemoveSdCard)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(RemoveSdCard);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemSeedForPseudoDeviceId, (::nn::sf::Out<::nn::ns::SystemSeedForPseudoDeviceId> pOutSeed))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSystemSeedForPseudoDeviceId, (pOutSeed));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ResetSystemSeedForPseudoDeviceId)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ResetSystemSeedForPseudoDeviceId);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationDownloadingContentMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::nn::ncm::ApplicationId id, ::std::int32_t offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListApplicationDownloadingContentMeta, (outCount, outList, id, offset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationView, (const ::nn::sf::OutArray<::nn::ns::ApplicationView>& outList, const ::nn::sf::InArray<::nn::ncm::ApplicationId>& idList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetApplicationView, (outList, idList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationDownloadTaskStatus, (::nn::sf::Out<::nn::ns::ApplicationDownloadTaskStatus> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetApplicationDownloadTaskStatus, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationViewDownloadErrorContext, (::nn::sf::Out<::nn::err::ErrorContext> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetApplicationViewDownloadErrorContext, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsNotificationSetupCompleted, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsNotificationSetupCompleted, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLastNotificationInfoCount, (::nn::sf::Out<::std::int64_t> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLastNotificationInfoCount, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListLastNotificationInfo, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::NotificationInfo>& outList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListLastNotificationInfo, (outCount, outList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListNotificationTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::AsyncTask>& outList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListNotificationTask, (outCount, outList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsActiveAccount, (::nn::sf::Out<bool> outValue, ::nn::es::AccountId accountId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsActiveAccount, (outValue, accountId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestDownloadApplicationPrepurchasedRights, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestDownloadApplicationPrepurchasedRights, (outHandle, outAsync, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationTicketInfo, (::nn::sf::Out<::nn::ns::ApplicationTicketInfo> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetApplicationTicketInfo, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemDeliveryInfo, (::nn::sf::Out<::nn::ns::SystemDeliveryInfo> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSystemDeliveryInfo, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SelectLatestSystemDeliveryInfo, (::nn::sf::Out<::std::int32_t> outValue, const ::nn::sf::InArray<::nn::ns::SystemDeliveryInfo>& list, const ::nn::ns::SystemDeliveryInfo& receiverSystemInfo, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& receiverAppInfo))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SelectLatestSystemDeliveryInfo, (outValue, list, receiverSystemInfo, receiverAppInfo));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(VerifyDeliveryProtocolVersion, (const ::nn::ns::SystemDeliveryInfo& info))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(VerifyDeliveryProtocolVersion, (info));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationDeliveryInfo, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationDeliveryInfo>& outValue, ::nn::ncm::ApplicationId id, ::nn::ns::ApplicationDeliveryAttribute attributes))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetApplicationDeliveryInfo, (outCount, outValue, id, attributes));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasAllContentsToDeliver, (::nn::sf::Out<bool> outValue, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& appInfoList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(HasAllContentsToDeliver, (outValue, appInfoList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CompareApplicationDeliveryInfo, (::nn::sf::Out<::std::int32_t> outValue, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& lhs, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& rhs))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CompareApplicationDeliveryInfo, (outValue, lhs, rhs));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CanDeliverApplication, (::nn::sf::Out<bool> outValue, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& receiverInfoList, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& senderInfoList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CanDeliverApplication, (outValue, receiverInfoList, senderInfoList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListContentMetaKeyToDeliverApplication, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ContentMetaKey>& outList, ::std::int32_t offset, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& infoList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListContentMetaKeyToDeliverApplication, (outCount, outList, offset, infoList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NeedsSystemUpdateToDeliverApplication, (::nn::sf::Out<bool> outValue, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& applicationInfoList, const ::nn::ns::SystemDeliveryInfo& systemInfo))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(NeedsSystemUpdateToDeliverApplication, (outValue, applicationInfoList, systemInfo));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EstimateRequiredSize, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EstimateRequiredSize, (outValue, keyList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestReceiveApplication, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::ApplicationId id, ::nn::ncm::StorageId storageId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestReceiveApplication, (outHandle, outAsync, ipv4, port, keyList, id, storageId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CommitReceiveApplication, (::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CommitReceiveApplication, (id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReceiveApplicationProgress, (::nn::sf::Out<::nn::ns::ReceiveApplicationProgress> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetReceiveApplicationProgress, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestSendApplication, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestSendApplication, (outHandle, outAsync, ipv4, port, keyList, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSendApplicationProgress, (::nn::sf::Out<::nn::ns::SendApplicationProgress> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSendApplicationProgress, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CompareSystemDeliveryInfo, (::nn::sf::Out<::std::int32_t> outValue, const ::nn::ns::SystemDeliveryInfo& lhs, const ::nn::ns::SystemDeliveryInfo& rhs))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CompareSystemDeliveryInfo, (outValue, lhs, rhs));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListNotCommittedContentMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ContentMetaKey>& outList, ::nn::ncm::ApplicationId id, ::std::int32_t offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListNotCommittedContentMeta, (outCount, outList, id, offset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateDownloadTask, (const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateDownloadTask, (keyList, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationDeliveryInfoHash, (::nn::sf::Out<::nn::ns::ApplicationDeliveryInfoHash> outValue, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& infoList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetApplicationDeliveryInfoHash, (outValue, infoList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationRightsOnClient, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationRightsOnClient>& outList, ::nn::ncm::ApplicationId appId, const ::nn::account::Uid& uid, ::nn::ns::ApplicationRightsOnClientQueryFlag flags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetApplicationRightsOnClient, (outCount, outList, appId, uid, flags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationTerminateResult, (::nn::sf::Out<::std::uint32_t> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetApplicationTerminateResult, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRawApplicationTerminateResult, (::nn::sf::Out<::std::uint32_t> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRawApplicationTerminateResult, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateRightsEnvironment, (::nn::sf::Out<::nn::ns::RightsEnvironmentHandle> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateRightsEnvironment, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyRightsEnvironment, (::nn::ns::RightsEnvironmentHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DestroyRightsEnvironment, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateRightsEnvironment, (::nn::ns::RightsEnvironmentHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ActivateRightsEnvironment, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeactivateRightsEnvironment, (::nn::ns::RightsEnvironmentHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeactivateRightsEnvironment, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddTargetApplicationToRightsEnvironment, (::nn::ns::RightsEnvironmentHandle handle, ::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AddTargetApplicationToRightsEnvironment, (handle, applicationId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetUsersToRightsEnvironment, (::nn::ns::RightsEnvironmentHandle handle, bool anyUser, const ::nn::sf::InArray<::nn::account::Uid>& uids))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetUsersToRightsEnvironment, (handle, anyUser, uids));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRightsEnvironmentStatus, (::nn::sf::Out<::nn::ns::RightsEnvironmentStatus> pOut, ::nn::ns::RightsEnvironmentHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRightsEnvironmentStatus, (pOut, handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardApplicationCopyIdentifier, (::nn::sf::Out<::nn::ns::GameCardApplicationCopyIdentifier> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetGameCardApplicationCopyIdentifier, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetInstalledApplicationCopyIdentifier, (::nn::sf::Out<::nn::ns::InstalledApplicationCopyIdentifier> outValue, ::nn::ncm::ApplicationId id, ::nn::ncm::StorageId storage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetInstalledApplicationCopyIdentifier, (outValue, id, storage));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ns::detail::IApplicationManagerInterface>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ns::detail::IApplicationManagerInterface))

    // nn::Result ListApplicationRecord(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationRecord>& outList, std::int32_t offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListApplicationRecord)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ns::ApplicationRecord>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (offset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListApplicationRecord)

    // nn::Result GenerateApplicationRecordCount(nn::sf::Out<std::int64_t> outCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GenerateApplicationRecordCount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GenerateApplicationRecordCount)

    // nn::Result GetApplicationRecordUpdateSystemEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetApplicationRecordUpdateSystemEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outValue, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetApplicationRecordUpdateSystemEvent)

    // nn::Result GetApplicationViewDeprecated(const nn::sf::OutArray<nn::ns::ApplicationViewDeprecated>& outList, const nn::sf::InArray<nn::ncm::ApplicationId>& idList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetApplicationViewDeprecated)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ns::ApplicationViewDeprecated>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(idList, 1, (const ::nn::sf::InArray<::nn::ncm::ApplicationId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outList, idList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(idList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetApplicationViewDeprecated)

    // nn::Result DeleteApplicationEntity(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteApplicationEntity)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteApplicationEntity)

    // nn::Result DeleteApplicationCompletely(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteApplicationCompletely)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteApplicationCompletely)

    // nn::Result IsAnyApplicationEntityRedundant(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsAnyApplicationEntityRedundant)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsAnyApplicationEntityRedundant)

    // nn::Result DeleteRedundantApplicationEntity() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteRedundantApplicationEntity)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteRedundantApplicationEntity)

    // nn::Result IsApplicationEntityMovable(nn::sf::Out<bool> outValue, nn::ncm::ApplicationId id, nn::ncm::StorageId storage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsApplicationEntityMovable)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storage, (::nn::ncm::StorageId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (storage, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsApplicationEntityMovable)

    // nn::Result MoveApplicationEntity(nn::ncm::ApplicationId id, nn::ncm::StorageId storage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(MoveApplicationEntity)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storage, (::nn::ncm::StorageId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (storage, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(MoveApplicationEntity)

    // nn::Result CalculateApplicationOccupiedSize(nn::sf::Out<nn::ns::ApplicationOccupiedSize> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CalculateApplicationOccupiedSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::ns::ApplicationOccupiedSize), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(128)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CalculateApplicationOccupiedSize)

    // nn::Result PushApplicationRecord(nn::ncm::ApplicationId id, nn::ns::ApplicationEvent appEvent, const nn::sf::InArray<nn::ncm::StorageContentMetaKey>& keyList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PushApplicationRecord)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(keyList, 0, (const ::nn::sf::InArray<::nn::ncm::StorageContentMetaKey>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (keyList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appEvent, (::nn::ns::ApplicationEvent), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (appEvent, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appEvent), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(keyList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PushApplicationRecord)

    // nn::Result ListApplicationRecordContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, nn::ncm::ApplicationId id, std::int32_t offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListApplicationRecordContentMeta)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (offset, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListApplicationRecordContentMeta)

    // nn::Result GetApplicationContentPath(nn::sf::Out<nn::ncm::Path> outValue, nn::ncm::ApplicationId id, nn::ncm::ContentType type) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetApplicationContentPath)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outValue, 0, (::nn::sf::Out<::nn::ncm::Path>), 768, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::nn::ncm::ContentType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (type, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetApplicationContentPath)

    // nn::Result TerminateApplication(nn::os::ProcessId pid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TerminateApplication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(22)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::os::ProcessId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TerminateApplication)

    // nn::Result ResolveApplicationContentPath(nn::ncm::ProgramId id, nn::ncm::ContentType type) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResolveApplicationContentPath)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(23)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::nn::ncm::ContentType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ProgramId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (type, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResolveApplicationContentPath)

    // nn::Result BeginInstallApplication(nn::ncm::ApplicationId id, std::uint32_t version, nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BeginInstallApplication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(26)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::nn::ncm::StorageId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(version, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (storageId, version, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(version), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BeginInstallApplication)

    // nn::Result DeleteApplicationRecord(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteApplicationRecord)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(27)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteApplicationRecord)

    // nn::Result RequestApplicationUpdateInfo(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestApplicationUpdateInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestApplicationUpdateInfo)

    // nn::Result CancelApplicationDownload(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelApplicationDownload)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelApplicationDownload)

    // nn::Result ResumeApplicationDownload(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResumeApplicationDownload)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(33)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResumeApplicationDownload)

    // nn::Result UpdateVersionList(const nn::sf::InBuffer& buffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UpdateVersionList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(35)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UpdateVersionList)

    // nn::Result PushLaunchVersion(nn::ncm::ApplicationId id, std::uint32_t version) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PushLaunchVersion)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(36)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(version, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (version, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(version)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PushLaunchVersion)

    // nn::Result ListRequiredVersion(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::RequiredVersionEntry>& requiredVersionEntries) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListRequiredVersion)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(37)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(requiredVersionEntries, 0, (const ::nn::sf::OutArray<::nn::ns::RequiredVersionEntry>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (requiredVersionEntries))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(requiredVersionEntries)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListRequiredVersion)

    // nn::Result CheckApplicationLaunchVersion(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CheckApplicationLaunchVersion)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(38)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CheckApplicationLaunchVersion)

    // nn::Result CheckApplicationLaunchRights(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CheckApplicationLaunchRights)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(39)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CheckApplicationLaunchRights)

    // nn::Result GetApplicationLogoData(nn::sf::Out<std::int64_t> outSize, const nn::sf::OutBuffer& outBuffer, nn::ncm::ApplicationId id, const nn::ncm::Path& logoPath) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetApplicationLogoData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(40)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(logoPath, 0, (const ::nn::ncm::Path&), 768, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (logoPath, outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(logoPath)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetApplicationLogoData)

    // nn::Result CalculateApplicationDownloadRequiredSize(nn::sf::Out<nn::ncm::StorageId> outStorage, nn::sf::Out<std::int64_t> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CalculateApplicationDownloadRequiredSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(41)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outStorage, (::nn::ncm::StorageId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outStorage, outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outStorage), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CalculateApplicationDownloadRequiredSize)

    // nn::Result CleanupSdCard() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CleanupSdCard)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(42)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CleanupSdCard)

    // nn::Result CheckSdCardMountStatus() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CheckSdCardMountStatus)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(43)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CheckSdCardMountStatus)

    // nn::Result GetSdCardMountStatusChangedEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSdCardMountStatusChangedEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(44)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outValue, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSdCardMountStatusChangedEvent)

    // nn::Result GetGameCardAttachmentEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGameCardAttachmentEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(45)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outValue, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGameCardAttachmentEvent)

    // nn::Result GetGameCardAttachmentInfo(nn::sf::Out<nn::ns::GameCardAttachmentInfo> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGameCardAttachmentInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(46)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::ns::GameCardAttachmentInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGameCardAttachmentInfo)

    // nn::Result GetTotalSpaceSize(nn::sf::Out<std::int64_t> outSize, nn::ncm::StorageId storage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetTotalSpaceSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(47)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storage, (::nn::ncm::StorageId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storage))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetTotalSpaceSize)

    // nn::Result GetFreeSpaceSize(nn::sf::Out<std::int64_t> outSize, nn::ncm::StorageId storage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFreeSpaceSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(48)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storage, (::nn::ncm::StorageId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storage))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFreeSpaceSize)

    // nn::Result GetSdCardRemovedEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSdCardRemovedEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(49)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outValue, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSdCardRemovedEvent)

    // nn::Result GetGameCardUpdateDetectionEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGameCardUpdateDetectionEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(52)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outValue, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGameCardUpdateDetectionEvent)

    // nn::Result DisableApplicationAutoDelete(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DisableApplicationAutoDelete)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(53)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DisableApplicationAutoDelete)

    // nn::Result EnableApplicationAutoDelete(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableApplicationAutoDelete)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(54)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableApplicationAutoDelete)

    // nn::Result SetApplicationTerminateResult(nn::ncm::ApplicationId id, std::uint32_t result) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetApplicationTerminateResult)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(56)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(result, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (result, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(result)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetApplicationTerminateResult)

    // nn::Result ClearApplicationTerminateResult(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ClearApplicationTerminateResult)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(57)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ClearApplicationTerminateResult)

    // nn::Result GetLastSdCardMountUnexpectedResult() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLastSdCardMountUnexpectedResult)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(58)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLastSdCardMountUnexpectedResult)

    // nn::Result GetBackgroundDownloadStressTaskInfo(nn::sf::Out<nn::nim::BackgroundDownloadStressTaskInfo> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBackgroundDownloadStressTaskInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(61)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::nim::BackgroundDownloadStressTaskInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBackgroundDownloadStressTaskInfo)

    // nn::Result GetGameCardStopper(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IGameCardStopper>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGameCardStopper)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(62)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGameCardStopper)

    // nn::Result IsSystemProgramInstalled(nn::sf::Out<bool> outValue, nn::ncm::SystemProgramId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsSystemProgramInstalled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(63)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::SystemProgramId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsSystemProgramInstalled)

    // nn::Result StartApplyDeltaTask(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartApplyDeltaTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(64)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartApplyDeltaTask)

    // nn::Result GetRequestServerStopper(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IRequestServerStopper>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRequestServerStopper)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(65)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRequestServerStopper)

    // nn::Result GetBackgroundApplyDeltaStressTaskInfo(nn::sf::Out<nn::nim::BackgroundDownloadStressTaskInfo> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBackgroundApplyDeltaStressTaskInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(66)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::nim::BackgroundDownloadStressTaskInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBackgroundApplyDeltaStressTaskInfo)

    // nn::Result CancelApplicationApplyDelta(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelApplicationApplyDelta)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(67)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelApplicationApplyDelta)

    // nn::Result ResumeApplicationApplyDelta(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResumeApplicationApplyDelta)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(68)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResumeApplicationApplyDelta)

    // nn::Result CalculateApplicationApplyDeltaRequiredSize(nn::sf::Out<nn::ncm::StorageId> outStorage, nn::sf::Out<std::int64_t> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CalculateApplicationApplyDeltaRequiredSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(69)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outStorage, (::nn::ncm::StorageId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outStorage, outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outStorage), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CalculateApplicationApplyDeltaRequiredSize)

    // nn::Result ResumeAll() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResumeAll)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(70)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResumeAll)

    // nn::Result GetStorageSize(nn::sf::Out<std::int64_t> outTotalSize, nn::sf::Out<std::int64_t> outFreeSize, nn::ncm::StorageId storage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetStorageSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(71)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storage, (::nn::ncm::StorageId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storage))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outTotalSize, (::std::int64_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outFreeSize, (::std::int64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outTotalSize, outFreeSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outTotalSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outFreeSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetStorageSize)

    // nn::Result RequestDownloadApplication(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId applicationId, nn::ncm::StorageId storageId, bool forceDirectUpdate) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestDownloadApplication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(80)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::nn::ncm::StorageId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(forceDirectUpdate, (bool), 1)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (storageId, forceDirectUpdate, applicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(forceDirectUpdate)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestDownloadApplication)

    // nn::Result RequestDownloadAddOnContent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId id, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestDownloadAddOnContent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(81)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(keyList, 0, (const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (keyList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::nn::ncm::StorageId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (storageId, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(keyList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestDownloadAddOnContent)

    // nn::Result DownloadApplication(nn::ncm::ApplicationId applicationId, nn::ncm::StorageId storageId, bool forceDirectUpdate) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DownloadApplication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(82)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::nn::ncm::StorageId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(forceDirectUpdate, (bool), 1)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (storageId, forceDirectUpdate, applicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(forceDirectUpdate)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DownloadApplication)

    // nn::Result CheckApplicationResumeRights(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CheckApplicationResumeRights)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(83)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CheckApplicationResumeRights)

    // nn::Result GetDynamicCommitEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDynamicCommitEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(84)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDynamicCommitEvent)

    // nn::Result RequestUpdateApplication2(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestUpdateApplication2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(85)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestUpdateApplication2)

    // void EnableApplicationCrashReport(bool isEnable) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableApplicationCrashReport)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(86)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isEnable, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isEnable))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isEnable)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableApplicationCrashReport)

    // bool IsApplicationCrashReportEnabled() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsApplicationCrashReportEnabled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(87)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsApplicationCrashReportEnabled)

    // nn::Result BoostSystemMemoryResourceLimit(std::int64_t boostSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(BoostSystemMemoryResourceLimit)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(90)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(boostSize, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (boostSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(boostSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(BoostSystemMemoryResourceLimit)

    // nn::Result DeprecatedLaunchApplication(nn::sf::Out<nn::os::ProcessId> outValue, nn::ncm::ApplicationId id, std::uint8_t programIndex) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeprecatedLaunchApplication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(91)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(programIndex, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (programIndex, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::os::ProcessId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(programIndex)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeprecatedLaunchApplication)

    // nn::Result GetRunningApplicationProgramId(nn::sf::Out<nn::ncm::ProgramId> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRunningApplicationProgramId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(92)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::ncm::ProgramId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRunningApplicationProgramId)

    // nn::Result GetMainApplicationProgramIndex(nn::sf::Out<std::uint8_t> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetMainApplicationProgramIndex)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(93)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetMainApplicationProgramIndex)

    // nn::Result LaunchApplication(nn::sf::Out<nn::os::ProcessId> outValue, const nn::ns::ApplicationLaunchInfo& info, std::uint8_t programIndex) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LaunchApplication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(94)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(programIndex, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(info, (::nn::ns::ApplicationLaunchInfo), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (programIndex, info))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(72)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::os::ProcessId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(info), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(programIndex)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LaunchApplication)

    // nn::Result GetApplicationLaunchInfo(nn::sf::Out<nn::ns::ApplicationLaunchInfo> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetApplicationLaunchInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(95)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::ns::ApplicationLaunchInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(64)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetApplicationLaunchInfo)

    // nn::Result AcquireApplicationLaunchInfo(nn::sf::Out<nn::ns::ApplicationLaunchInfo> outValue, nn::os::ProcessId processId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AcquireApplicationLaunchInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(96)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::os::ProcessId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::ns::ApplicationLaunchInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(64)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AcquireApplicationLaunchInfo)

    // nn::Result GetMainApplicationProgramIndexByApplicationLaunchInfo(nn::sf::Out<std::uint8_t> outValue, const nn::ns::ApplicationLaunchInfo& info) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetMainApplicationProgramIndexByApplicationLaunchInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(97)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(info, (::nn::ns::ApplicationLaunchInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (info))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(64)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(info)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetMainApplicationProgramIndexByApplicationLaunchInfo)

    // void EnableApplicationAllThreadDumpOnCrash(bool isEnabled) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableApplicationAllThreadDumpOnCrash)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(98)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isEnabled, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (isEnabled))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isEnabled)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableApplicationAllThreadDumpOnCrash)

    // nn::Result ResetToFactorySettings() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResetToFactorySettings)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResetToFactorySettings)

    // nn::Result ResetToFactorySettingsWithoutUserSaveData() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResetToFactorySettingsWithoutUserSaveData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResetToFactorySettingsWithoutUserSaveData)

    // nn::Result ResetToFactorySettingsForRefurbishment() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResetToFactorySettingsForRefurbishment)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(102)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResetToFactorySettingsForRefurbishment)

    // nn::Result CalculateUserSaveDataStatistics(nn::sf::Out<nn::ns::UserSaveDataStatistics> pOut, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CalculateUserSaveDataStatistics)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(200)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::nn::ns::UserSaveDataStatistics), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CalculateUserSaveDataStatistics)

    // nn::Result DeleteUserSaveDataAll(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IProgressMonitorForDeleteUserSaveDataAll>> pOut, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteUserSaveDataAll)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(pOut, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteUserSaveDataAll)

    // nn::Result DeleteUserSystemSaveData(const nn::account::Uid& uid, nn::fs::SystemSaveDataId sysSaveId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteUserSystemSaveData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(210)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(sysSaveId, (::nn::fs::SystemSaveDataId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (uid, sysSaveId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sysSaveId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteUserSystemSaveData)

    // nn::Result UnregisterNetworkServiceAccount(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnregisterNetworkServiceAccount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(220)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnregisterNetworkServiceAccount)

    // nn::Result UnregisterNetworkServiceAccountWithUserSaveDataDeletion(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnregisterNetworkServiceAccountWithUserSaveDataDeletion)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(221)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnregisterNetworkServiceAccountWithUserSaveDataDeletion)

    // nn::Result GetApplicationShellEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetApplicationShellEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(300)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outValue, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetApplicationShellEvent)

    // nn::Result PopApplicationShellEventInfo(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationShellEventInfo>& outList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PopApplicationShellEventInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(301)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ns::ApplicationShellEventInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PopApplicationShellEventInfo)

    // nn::Result LaunchLibraryApplet(nn::sf::Out<nn::os::ProcessId> outValue, nn::ncm::SystemProgramId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LaunchLibraryApplet)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(302)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::SystemProgramId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::os::ProcessId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LaunchLibraryApplet)

    // nn::Result TerminateLibraryApplet(nn::os::ProcessId pid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TerminateLibraryApplet)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(303)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::os::ProcessId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TerminateLibraryApplet)

    // nn::Result LaunchSystemApplet(nn::sf::Out<nn::os::ProcessId> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LaunchSystemApplet)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(304)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::os::ProcessId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LaunchSystemApplet)

    // nn::Result TerminateSystemApplet(nn::os::ProcessId pid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TerminateSystemApplet)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(305)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::os::ProcessId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TerminateSystemApplet)

    // nn::Result LaunchOverlayApplet(nn::sf::Out<nn::os::ProcessId> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LaunchOverlayApplet)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(306)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::os::ProcessId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LaunchOverlayApplet)

    // nn::Result TerminateOverlayApplet(nn::os::ProcessId pid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TerminateOverlayApplet)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(307)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::os::ProcessId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TerminateOverlayApplet)

    // nn::Result InvalidateAllApplicationControlCache() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(InvalidateAllApplicationControlCache)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(401)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(InvalidateAllApplicationControlCache)

    // nn::Result RequestDownloadApplicationControlData(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestDownloadApplicationControlData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(402)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestDownloadApplicationControlData)

    // nn::Result GetMaxApplicationControlCacheCount(nn::sf::Out<std::int32_t> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetMaxApplicationControlCacheCount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(403)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetMaxApplicationControlCacheCount)

    // nn::Result InvalidateApplicationControlCache(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(InvalidateApplicationControlCache)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(404)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(InvalidateApplicationControlCache)

    // nn::Result ListApplicationControlCacheEntryInfo(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationControlCacheEntryInfo>& outList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListApplicationControlCacheEntryInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(405)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ns::ApplicationControlCacheEntryInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListApplicationControlCacheEntryInfo)

    // nn::Result GetApplicationControlProperty(nn::sf::Out<nn::ns::ApplicationControlProperty> outValue, const nn::ns::ApplicationLaunchInfo& info, std::uint8_t programIndex) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetApplicationControlProperty)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(406)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outValue, 0, (::nn::sf::Out<::nn::ns::ApplicationControlProperty>), 16384, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(programIndex, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(info, (::nn::ns::ApplicationLaunchInfo), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (programIndex, info))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(72)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(info), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(programIndex)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetApplicationControlProperty)

    // nn::Result RequestCheckGameCardRegistration(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId appId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestCheckGameCardRegistration)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(502)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestCheckGameCardRegistration)

    // nn::Result RequestGameCardRegistrationGoldPoint(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync, const nn::account::Uid& uid, nn::ncm::ApplicationId appId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestGameCardRegistrationGoldPoint)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(503)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ncm::ApplicationId), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (uid, appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestGameCardRegistrationGoldPoint)

    // nn::Result RequestRegisterGameCard(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, const nn::account::Uid& uid, nn::ncm::ApplicationId appId, std::int32_t goldPoint) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestRegisterGameCard)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(504)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(goldPoint, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ncm::ApplicationId), 24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (goldPoint, uid, appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(goldPoint)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestRegisterGameCard)

    // nn::Result GetGameCardMountFailureEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGameCardMountFailureEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(505)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGameCardMountFailureEvent)

    // nn::Result IsGameCardInserted(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsGameCardInserted)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(506)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsGameCardInserted)

    // nn::Result EnsureGameCardAccess() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnsureGameCardAccess)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(507)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnsureGameCardAccess)

    // nn::Result GetLastGameCardMountFailureResult() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLastGameCardMountFailureResult)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(508)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLastGameCardMountFailureResult)

    // nn::Result ListApplicationIdOnGameCard(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ApplicationId>& outList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListApplicationIdOnGameCard)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(509)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ncm::ApplicationId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListApplicationIdOnGameCard)

    // nn::Result CountApplicationContentMeta(nn::sf::Out<std::int32_t> outValue, nn::ncm::ApplicationId appId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CountApplicationContentMeta)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(600)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CountApplicationContentMeta)

    // nn::Result ListApplicationContentMetaStatus(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationContentMetaStatus>& outList, nn::ncm::ApplicationId appId, std::int32_t offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListApplicationContentMetaStatus)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(601)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ns::ApplicationContentMetaStatus>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (offset, appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListApplicationContentMetaStatus)

    // nn::Result ListAvailableAddOnContent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationContentMetaStatus>& outList, nn::ncm::ApplicationId appId, std::int32_t offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListAvailableAddOnContent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(602)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ns::ApplicationContentMetaStatus>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (offset, appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListAvailableAddOnContent)

    // nn::Result GetOwnedApplicationContentMetaStatus(nn::sf::Out<nn::ns::ApplicationContentMetaStatus> outValue, nn::ncm::ApplicationId appId, nn::Bit64 contentMetaId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetOwnedApplicationContentMetaStatus)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(603)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ncm::ApplicationId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(contentMetaId, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (appId, contentMetaId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::ns::ApplicationContentMetaStatus), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(contentMetaId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetOwnedApplicationContentMetaStatus)

    // nn::Result RegisterContentsExternalKey(nn::ncm::ApplicationId appId, nn::Bit64 contentMetaId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterContentsExternalKey)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(604)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ncm::ApplicationId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(contentMetaId, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (appId, contentMetaId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(contentMetaId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterContentsExternalKey)

    // nn::Result ListApplicationContentMetaStatusWithRightsCheck(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationContentMetaStatus>& outList, nn::ncm::ApplicationId appId, std::int32_t offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListApplicationContentMetaStatusWithRightsCheck)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(605)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ns::ApplicationContentMetaStatus>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (offset, appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListApplicationContentMetaStatusWithRightsCheck)

    // nn::Result GetContentMetaStorage(nn::sf::Out<nn::ncm::StorageId> outValue, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetContentMetaStorage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(606)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(key, (::nn::ncm::ContentMetaKey), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (key))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::ncm::StorageId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetContentMetaStorage)

    // nn::Result PushDownloadTaskList(const nn::sf::InBuffer& buffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PushDownloadTaskList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(700)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PushDownloadTaskList)

    // nn::Result ClearTaskStatusList() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ClearTaskStatusList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(701)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ClearTaskStatusList)

    // nn::Result RequestDownloadTaskList() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestDownloadTaskList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(702)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestDownloadTaskList)

    // nn::Result RequestEnsureDownloadTask(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestEnsureDownloadTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(703)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestEnsureDownloadTask)

    // nn::Result ListDownloadTaskStatus(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::DownloadTaskStatus>& outList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListDownloadTaskStatus)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(704)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ns::DownloadTaskStatus>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListDownloadTaskStatus)

    // nn::Result RequestDownloadTaskListData(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestDownloadTaskListData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(705)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestDownloadTaskListData)

    // nn::Result RequestVersionList() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestVersionList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(800)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestVersionList)

    // nn::Result ListVersionList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::VersionListEntry>& versionListEntries) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListVersionList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(801)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(versionListEntries, 0, (const ::nn::sf::OutArray<::nn::ns::VersionListEntry>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (versionListEntries))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(versionListEntries)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListVersionList)

    // nn::Result RequestVersionListData(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestVersionListData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(802)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestVersionListData)

    // nn::Result GetApplicationRecord(nn::sf::Out<nn::ns::ApplicationRecord> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetApplicationRecord)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(900)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::ns::ApplicationRecord), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetApplicationRecord)

    // nn::Result GetApplicationRecordProperty(nn::sf::Out<nn::ns::ApplicationRecordProperty> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetApplicationRecordProperty)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(901)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outValue, 0, (::nn::sf::Out<::nn::ns::ApplicationRecordProperty>), 512, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetApplicationRecordProperty)

    // nn::Result EnableApplicationAutoUpdate(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableApplicationAutoUpdate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(902)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableApplicationAutoUpdate)

    // nn::Result DisableApplicationAutoUpdate(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DisableApplicationAutoUpdate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(903)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DisableApplicationAutoUpdate)

    // nn::Result TouchApplication(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TouchApplication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(904)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TouchApplication)

    // nn::Result RequestApplicationUpdate(nn::ncm::ApplicationId id, nn::Bit32 resultInnerValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestApplicationUpdate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(905)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(resultInnerValue, (::nn::Bit32), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (resultInnerValue, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(resultInnerValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestApplicationUpdate)

    // nn::Result IsApplicationUpdateRequested(nn::sf::Out<bool> outValue, nn::sf::Out<nn::Bit32> resultInnerValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsApplicationUpdateRequested)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(906)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(resultInnerValue, (::nn::Bit32), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (outValue, resultInnerValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(resultInnerValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsApplicationUpdateRequested)

    // nn::Result WithdrawApplicationUpdateRequest(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(WithdrawApplicationUpdateRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(907)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(WithdrawApplicationUpdateRequest)

    // nn::Result ListApplicationRecordInstalledContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, nn::ncm::ApplicationId id, std::int32_t offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListApplicationRecordInstalledContentMeta)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(908)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (offset, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListApplicationRecordInstalledContentMeta)

    // nn::Result WithdrawCleanupAddOnContentsWithNoRightsRecommendation(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(WithdrawCleanupAddOnContentsWithNoRightsRecommendation)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(909)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(WithdrawCleanupAddOnContentsWithNoRightsRecommendation)

    // nn::Result HasApplicationRecord(nn::sf::Out<bool> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HasApplicationRecord)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(910)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HasApplicationRecord)

    // nn::Result SetPreInstalledApplication(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetPreInstalledApplication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(911)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetPreInstalledApplication)

    // nn::Result ClearPreInstalledApplicationFlag(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ClearPreInstalledApplicationFlag)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(912)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ClearPreInstalledApplicationFlag)

    // nn::Result RequestVerifyApplicationDeprecated(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IProgressAsyncResult>> outAsync, nn::ncm::ApplicationId id, nn::sf::NativeHandle&& transferHandle, std::uint64_t transferSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestVerifyApplicationDeprecated)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1000)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(transferHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (transferHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(transferSize, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (id, transferSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(transferHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(transferSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestVerifyApplicationDeprecated)

    // nn::Result CorruptApplicationForDebug(nn::ncm::ApplicationId id, nn::Bit32 flags, nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CorruptApplicationForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1001)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::nn::ncm::StorageId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flags, (::nn::Bit32), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (storageId, flags, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flags), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CorruptApplicationForDebug)

    // nn::Result RequestVerifyAddOnContentsRights(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IProgressAsyncResult>> outAsync, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestVerifyAddOnContentsRights)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1002)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestVerifyAddOnContentsRights)

    // nn::Result RequestVerifyApplication(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IProgressAsyncResult>> outAsync, nn::ncm::ApplicationId id, nn::Bit32 flags, nn::sf::NativeHandle&& transferHandle, std::uint64_t transferSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestVerifyApplication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1003)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(transferHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (transferHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flags, (::nn::Bit32), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(transferSize, (::std::uint64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (flags, id, transferSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flags), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(transferHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(transferSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestVerifyApplication)

    // nn::Result CorruptContentForDebug(const nn::ncm::ContentMetaKey& key, nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CorruptContentForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1004)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::nn::ncm::StorageId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(key, (::nn::ncm::ContentMetaKey), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (storageId, key))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CorruptContentForDebug)

    // nn::Result NeedsUpdateVulnerability(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(NeedsUpdateVulnerability)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1200)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(NeedsUpdateVulnerability)

    // nn::Result IsAnyApplicationEntityInstalled(nn::sf::Out<bool> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsAnyApplicationEntityInstalled)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1300)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsAnyApplicationEntityInstalled)

    // nn::Result DeleteApplicationContentEntities(nn::ncm::ApplicationId id, std::uint32_t innerValue, nn::ncm::StorageId storage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteApplicationContentEntities)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1301)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storage, (::nn::ncm::StorageId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(innerValue, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (storage, innerValue, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(innerValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteApplicationContentEntities)

    // nn::Result CleanupUnrecordedApplicationEntity(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CleanupUnrecordedApplicationEntity)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1302)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CleanupUnrecordedApplicationEntity)

    // nn::Result CleanupAddOnContentsWithNoRights(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CleanupAddOnContentsWithNoRights)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1303)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CleanupAddOnContentsWithNoRights)

    // nn::Result DeleteApplicationContentEntity(const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteApplicationContentEntity)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1304)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(key, (::nn::ncm::ContentMetaKey), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (key))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteApplicationContentEntity)

    // nn::Result DeleteApplicationCompletelyForDebug(nn::ncm::ApplicationId id, std::uint32_t innerValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteApplicationCompletelyForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1308)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(innerValue, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (innerValue, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(innerValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteApplicationCompletelyForDebug)

    // nn::Result PrepareShutdown() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PrepareShutdown)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1400)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PrepareShutdown)

    // nn::Result FormatSdCard() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(FormatSdCard)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1500)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(FormatSdCard)

    // nn::Result NeedsSystemUpdateToFormatSdCard(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(NeedsSystemUpdateToFormatSdCard)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1501)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(NeedsSystemUpdateToFormatSdCard)

    // nn::Result GetLastSdCardFormatUnexpectedResult() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLastSdCardFormatUnexpectedResult)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1502)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLastSdCardFormatUnexpectedResult)

    // nn::Result InsertSdCard() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(InsertSdCard)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1504)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(InsertSdCard)

    // nn::Result RemoveSdCard() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RemoveSdCard)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1505)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RemoveSdCard)

    // nn::Result GetSystemSeedForPseudoDeviceId(nn::sf::Out<nn::ns::SystemSeedForPseudoDeviceId> pOutSeed) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSystemSeedForPseudoDeviceId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1600)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSeed, (::nn::ns::SystemSeedForPseudoDeviceId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutSeed))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSeed)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSystemSeedForPseudoDeviceId)

    // nn::Result ResetSystemSeedForPseudoDeviceId() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResetSystemSeedForPseudoDeviceId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1601)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResetSystemSeedForPseudoDeviceId)

    // nn::Result ListApplicationDownloadingContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, nn::ncm::ApplicationId id, std::int32_t offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListApplicationDownloadingContentMeta)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1700)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (offset, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListApplicationDownloadingContentMeta)

    // nn::Result GetApplicationView(const nn::sf::OutArray<nn::ns::ApplicationView>& outList, const nn::sf::InArray<nn::ncm::ApplicationId>& idList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetApplicationView)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1701)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ns::ApplicationView>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(idList, 1, (const ::nn::sf::InArray<::nn::ncm::ApplicationId>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outList, idList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(idList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetApplicationView)

    // nn::Result GetApplicationDownloadTaskStatus(nn::sf::Out<nn::ns::ApplicationDownloadTaskStatus> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetApplicationDownloadTaskStatus)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1702)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::ns::ApplicationDownloadTaskStatus), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetApplicationDownloadTaskStatus)

    // nn::Result GetApplicationViewDownloadErrorContext(nn::sf::Out<nn::err::ErrorContext> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetApplicationViewDownloadErrorContext)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1703)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outValue, 0, (::nn::sf::Out<::nn::err::ErrorContext>), 512, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetApplicationViewDownloadErrorContext)

    // nn::Result IsNotificationSetupCompleted(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsNotificationSetupCompleted)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1800)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsNotificationSetupCompleted)

    // nn::Result GetLastNotificationInfoCount(nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLastNotificationInfoCount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1801)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLastNotificationInfoCount)

    // nn::Result ListLastNotificationInfo(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::NotificationInfo>& outList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListLastNotificationInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1802)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ns::NotificationInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListLastNotificationInfo)

    // nn::Result ListNotificationTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::AsyncTask>& outList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListNotificationTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1803)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ns::AsyncTask>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListNotificationTask)

    // nn::Result IsActiveAccount(nn::sf::Out<bool> outValue, nn::es::AccountId accountId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsActiveAccount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1900)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accountId, (::nn::es::AccountId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (accountId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accountId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsActiveAccount)

    // nn::Result RequestDownloadApplicationPrepurchasedRights(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestDownloadApplicationPrepurchasedRights)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1901)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestDownloadApplicationPrepurchasedRights)

    // nn::Result GetApplicationTicketInfo(nn::sf::Out<nn::ns::ApplicationTicketInfo> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetApplicationTicketInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1902)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::ns::ApplicationTicketInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetApplicationTicketInfo)

    // nn::Result GetSystemDeliveryInfo(nn::sf::Out<nn::ns::SystemDeliveryInfo> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSystemDeliveryInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2000)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outValue, 0, (::nn::sf::Out<::nn::ns::SystemDeliveryInfo>), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSystemDeliveryInfo)

    // nn::Result SelectLatestSystemDeliveryInfo(nn::sf::Out<std::int32_t> outValue, const nn::sf::InArray<nn::ns::SystemDeliveryInfo>& list, const nn::ns::SystemDeliveryInfo& receiverSystemInfo, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& receiverAppInfo) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SelectLatestSystemDeliveryInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2001)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(receiverSystemInfo, 0, (const ::nn::ns::SystemDeliveryInfo&), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(list, 1, (const ::nn::sf::InArray<::nn::ns::SystemDeliveryInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(receiverAppInfo, 2, (const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (receiverSystemInfo, list, receiverAppInfo))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(list), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(receiverSystemInfo), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(receiverAppInfo)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SelectLatestSystemDeliveryInfo)

    // nn::Result VerifyDeliveryProtocolVersion(const nn::ns::SystemDeliveryInfo& info) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(VerifyDeliveryProtocolVersion)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2002)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(info, 0, (const ::nn::ns::SystemDeliveryInfo&), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (info))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(info)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(VerifyDeliveryProtocolVersion)

    // nn::Result GetApplicationDeliveryInfo(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationDeliveryInfo>& outValue, nn::ncm::ApplicationId id, nn::ns::ApplicationDeliveryAttribute attributes) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetApplicationDeliveryInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2003)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outValue, 0, (const ::nn::sf::OutArray<::nn::ns::ApplicationDeliveryInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(attributes, (::nn::ns::ApplicationDeliveryAttribute), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (attributes, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(attributes)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetApplicationDeliveryInfo)

    // nn::Result HasAllContentsToDeliver(nn::sf::Out<bool> outValue, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& appInfoList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HasAllContentsToDeliver)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2004)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(appInfoList, 0, (const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (appInfoList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appInfoList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HasAllContentsToDeliver)

    // nn::Result CompareApplicationDeliveryInfo(nn::sf::Out<std::int32_t> outValue, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& lhs, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& rhs) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CompareApplicationDeliveryInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2005)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(lhs, 0, (const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(rhs, 1, (const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (lhs, rhs))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(lhs), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rhs)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CompareApplicationDeliveryInfo)

    // nn::Result CanDeliverApplication(nn::sf::Out<bool> outValue, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& receiverInfoList, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& senderInfoList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CanDeliverApplication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2006)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(receiverInfoList, 0, (const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(senderInfoList, 1, (const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (receiverInfoList, senderInfoList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(receiverInfoList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(senderInfoList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CanDeliverApplication)

    // nn::Result ListContentMetaKeyToDeliverApplication(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ContentMetaKey>& outList, std::int32_t offset, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& infoList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListContentMetaKeyToDeliverApplication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2007)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ncm::ContentMetaKey>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(infoList, 1, (const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (outList, infoList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (offset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(infoList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListContentMetaKeyToDeliverApplication)

    // nn::Result NeedsSystemUpdateToDeliverApplication(nn::sf::Out<bool> outValue, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& applicationInfoList, const nn::ns::SystemDeliveryInfo& systemInfo) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(NeedsSystemUpdateToDeliverApplication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2008)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(systemInfo, 0, (const ::nn::ns::SystemDeliveryInfo&), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(applicationInfoList, 1, (const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (systemInfo, applicationInfoList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationInfoList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(systemInfo)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(NeedsSystemUpdateToDeliverApplication)

    // nn::Result EstimateRequiredSize(nn::sf::Out<std::int64_t> outValue, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EstimateRequiredSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2009)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(keyList, 0, (const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (keyList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(keyList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EstimateRequiredSize)

    // nn::Result RequestReceiveApplication(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, std::uint32_t ipv4, std::uint16_t port, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::ApplicationId id, nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestReceiveApplication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2010)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(keyList, 0, (const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (keyList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::nn::ncm::StorageId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(port, (::std::uint16_t), 2)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ipv4, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (storageId, port, ipv4, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ipv4), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(port), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(keyList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestReceiveApplication)

    // nn::Result CommitReceiveApplication(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CommitReceiveApplication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2011)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CommitReceiveApplication)

    // nn::Result GetReceiveApplicationProgress(nn::sf::Out<nn::ns::ReceiveApplicationProgress> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetReceiveApplicationProgress)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2012)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::ns::ReceiveApplicationProgress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetReceiveApplicationProgress)

    // nn::Result RequestSendApplication(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, std::uint32_t ipv4, std::uint16_t port, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestSendApplication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2013)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(keyList, 0, (const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (keyList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(port, (::std::uint16_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ipv4, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (port, ipv4, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ipv4), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(port), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(keyList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestSendApplication)

    // nn::Result GetSendApplicationProgress(nn::sf::Out<nn::ns::SendApplicationProgress> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSendApplicationProgress)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2014)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::ns::SendApplicationProgress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSendApplicationProgress)

    // nn::Result CompareSystemDeliveryInfo(nn::sf::Out<std::int32_t> outValue, const nn::ns::SystemDeliveryInfo& lhs, const nn::ns::SystemDeliveryInfo& rhs) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CompareSystemDeliveryInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2015)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(lhs, 0, (const ::nn::ns::SystemDeliveryInfo&), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(rhs, 1, (const ::nn::ns::SystemDeliveryInfo&), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (lhs, rhs))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(lhs), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rhs)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CompareSystemDeliveryInfo)

    // nn::Result ListNotCommittedContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ContentMetaKey>& outList, nn::ncm::ApplicationId id, std::int32_t offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListNotCommittedContentMeta)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2016)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ncm::ContentMetaKey>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (offset, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListNotCommittedContentMeta)

    // nn::Result CreateDownloadTask(const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateDownloadTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2017)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(keyList, 0, (const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (keyList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(keyList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateDownloadTask)

    // nn::Result GetApplicationDeliveryInfoHash(nn::sf::Out<nn::ns::ApplicationDeliveryInfoHash> outValue, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& infoList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetApplicationDeliveryInfoHash)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2018)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(infoList, 0, (const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (infoList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::ns::ApplicationDeliveryInfoHash), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(infoList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetApplicationDeliveryInfoHash)

    // nn::Result GetApplicationRightsOnClient(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationRightsOnClient>& outList, nn::ncm::ApplicationId appId, const nn::account::Uid& uid, nn::ns::ApplicationRightsOnClientQueryFlag flags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetApplicationRightsOnClient)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2050)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ns::ApplicationRightsOnClient>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flags, (::nn::ns::ApplicationRightsOnClientQueryFlag), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ncm::ApplicationId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (flags, appId, uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetApplicationRightsOnClient)

    // nn::Result GetApplicationTerminateResult(nn::sf::Out<std::uint32_t> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetApplicationTerminateResult)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetApplicationTerminateResult)

    // nn::Result GetRawApplicationTerminateResult(nn::sf::Out<std::uint32_t> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRawApplicationTerminateResult)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRawApplicationTerminateResult)

    // nn::Result CreateRightsEnvironment(nn::sf::Out<nn::ns::RightsEnvironmentHandle> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateRightsEnvironment)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2150)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::nn::ns::RightsEnvironmentHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateRightsEnvironment)

    // nn::Result DestroyRightsEnvironment(nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroyRightsEnvironment)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2151)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::ns::RightsEnvironmentHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroyRightsEnvironment)

    // nn::Result ActivateRightsEnvironment(nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ActivateRightsEnvironment)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2152)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::ns::RightsEnvironmentHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ActivateRightsEnvironment)

    // nn::Result DeactivateRightsEnvironment(nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeactivateRightsEnvironment)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2153)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::ns::RightsEnvironmentHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeactivateRightsEnvironment)

    // nn::Result AddTargetApplicationToRightsEnvironment(nn::ns::RightsEnvironmentHandle handle, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AddTargetApplicationToRightsEnvironment)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2160)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::ns::RightsEnvironmentHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(applicationId, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, applicationId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(applicationId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AddTargetApplicationToRightsEnvironment)

    // nn::Result SetUsersToRightsEnvironment(nn::ns::RightsEnvironmentHandle handle, bool anyUser, const nn::sf::InArray<nn::account::Uid>& uids) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetUsersToRightsEnvironment)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2161)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(uids, 0, (const ::nn::sf::InArray<::nn::account::Uid>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (uids))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(anyUser, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::ns::RightsEnvironmentHandle), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (anyUser, handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(anyUser), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uids)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetUsersToRightsEnvironment)

    // nn::Result GetRightsEnvironmentStatus(nn::sf::Out<nn::ns::RightsEnvironmentStatus> pOut, nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRightsEnvironmentStatus)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2170)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::ns::RightsEnvironmentHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::nn::ns::RightsEnvironmentStatus), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRightsEnvironmentStatus)

    // nn::Result GetGameCardApplicationCopyIdentifier(nn::sf::Out<nn::ns::GameCardApplicationCopyIdentifier> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGameCardApplicationCopyIdentifier)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2200)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outValue, 0, (::nn::sf::Out<::nn::ns::GameCardApplicationCopyIdentifier>), 528, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGameCardApplicationCopyIdentifier)

    // nn::Result GetInstalledApplicationCopyIdentifier(nn::sf::Out<nn::ns::InstalledApplicationCopyIdentifier> outValue, nn::ncm::ApplicationId id, nn::ncm::StorageId storage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetInstalledApplicationCopyIdentifier)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2201)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outValue, 0, (::nn::sf::Out<::nn::ns::InstalledApplicationCopyIdentifier>), 1312, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storage, (::nn::ncm::StorageId), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (storage, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetInstalledApplicationCopyIdentifier)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::ApplicationRecord), 24, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::ApplicationViewDeprecated), 64, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ApplicationId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::StorageId), 1, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::ApplicationOccupiedSize), 128, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::ApplicationEvent), 1, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::StorageContentMetaKey), 24, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::Path), 768, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ContentType), 1, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::os::ProcessId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ProgramId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::RequiredVersionEntry), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::GameCardAttachmentInfo), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nim::BackgroundDownloadStressTaskInfo), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::SystemProgramId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ContentMetaKey), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::ApplicationLaunchInfo), 64, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::UserSaveDataStatistics), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::Uid), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::fs::SystemSaveDataId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::ApplicationShellEventInfo), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::ApplicationControlCacheEntryInfo), 32, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::ApplicationControlProperty), 16384, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::ApplicationContentMetaStatus), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::DownloadTaskStatus), 32, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::VersionListEntry), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::ApplicationRecordProperty), 512, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::SystemSeedForPseudoDeviceId), 32, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::ApplicationView), 80, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::ApplicationDownloadTaskStatus), 1, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::err::ErrorContext), 512, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::NotificationInfo), 136, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::AsyncTask), 168, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::es::AccountId), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::ApplicationTicketInfo), 8, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::SystemDeliveryInfo), 256, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::ApplicationDeliveryInfo), 256, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::ApplicationDeliveryAttribute), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::ReceiveApplicationProgress), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::SendApplicationProgress), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::ApplicationDeliveryInfoHash), 32, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::ApplicationRightsOnClient), 32, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::ApplicationRightsOnClientQueryFlag), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::RightsEnvironmentHandle), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::RightsEnvironmentStatus), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::GameCardApplicationCopyIdentifier), 528, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::InstalledApplicationCopyIdentifier), 1312, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ns::detail::IApplicationManagerInterface, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ns::detail::IApplicationManagerInterface))

    // nn::Result ListApplicationRecord(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationRecord>& outList, std::int32_t offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationRecord, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationRecord>& outList, ::std::int32_t offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListApplicationRecord)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListApplicationRecord)
    }

    // nn::Result GenerateApplicationRecordCount(nn::sf::Out<std::int64_t> outCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GenerateApplicationRecordCount, (::nn::sf::Out<::std::int64_t> outCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GenerateApplicationRecordCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GenerateApplicationRecordCount)
    }

    // nn::Result GetApplicationRecordUpdateSystemEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationRecordUpdateSystemEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetApplicationRecordUpdateSystemEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetApplicationRecordUpdateSystemEvent)
    }

    // nn::Result GetApplicationViewDeprecated(const nn::sf::OutArray<nn::ns::ApplicationViewDeprecated>& outList, const nn::sf::InArray<nn::ncm::ApplicationId>& idList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationViewDeprecated, (const ::nn::sf::OutArray<::nn::ns::ApplicationViewDeprecated>& outList, const ::nn::sf::InArray<::nn::ncm::ApplicationId>& idList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetApplicationViewDeprecated)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(idList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetApplicationViewDeprecated)
    }

    // nn::Result DeleteApplicationEntity(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteApplicationEntity, (::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteApplicationEntity)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteApplicationEntity)
    }

    // nn::Result DeleteApplicationCompletely(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteApplicationCompletely, (::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteApplicationCompletely)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteApplicationCompletely)
    }

    // nn::Result IsAnyApplicationEntityRedundant(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsAnyApplicationEntityRedundant, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsAnyApplicationEntityRedundant)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsAnyApplicationEntityRedundant)
    }

    // nn::Result DeleteRedundantApplicationEntity() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DeleteRedundantApplicationEntity)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteRedundantApplicationEntity)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteRedundantApplicationEntity)
    }

    // nn::Result IsApplicationEntityMovable(nn::sf::Out<bool> outValue, nn::ncm::ApplicationId id, nn::ncm::StorageId storage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsApplicationEntityMovable, (::nn::sf::Out<bool> outValue, ::nn::ncm::ApplicationId id, ::nn::ncm::StorageId storage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsApplicationEntityMovable)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsApplicationEntityMovable)
    }

    // nn::Result MoveApplicationEntity(nn::ncm::ApplicationId id, nn::ncm::StorageId storage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(MoveApplicationEntity, (::nn::ncm::ApplicationId id, ::nn::ncm::StorageId storage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(MoveApplicationEntity)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(MoveApplicationEntity)
    }

    // nn::Result CalculateApplicationOccupiedSize(nn::sf::Out<nn::ns::ApplicationOccupiedSize> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CalculateApplicationOccupiedSize, (::nn::sf::Out<::nn::ns::ApplicationOccupiedSize> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CalculateApplicationOccupiedSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CalculateApplicationOccupiedSize)
    }

    // nn::Result PushApplicationRecord(nn::ncm::ApplicationId id, nn::ns::ApplicationEvent appEvent, const nn::sf::InArray<nn::ncm::StorageContentMetaKey>& keyList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PushApplicationRecord, (::nn::ncm::ApplicationId id, ::nn::ns::ApplicationEvent appEvent, const ::nn::sf::InArray<::nn::ncm::StorageContentMetaKey>& keyList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PushApplicationRecord)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(keyList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PushApplicationRecord)
    }

    // nn::Result ListApplicationRecordContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, nn::ncm::ApplicationId id, std::int32_t offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationRecordContentMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::nn::ncm::ApplicationId id, ::std::int32_t offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListApplicationRecordContentMeta)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListApplicationRecordContentMeta)
    }

    // nn::Result GetApplicationContentPath(nn::sf::Out<nn::ncm::Path> outValue, nn::ncm::ApplicationId id, nn::ncm::ContentType type) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationContentPath, (::nn::sf::Out<::nn::ncm::Path> outValue, ::nn::ncm::ApplicationId id, ::nn::ncm::ContentType type))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetApplicationContentPath)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetApplicationContentPath)
    }

    // nn::Result TerminateApplication(nn::os::ProcessId pid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TerminateApplication, (::nn::os::ProcessId pid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TerminateApplication)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TerminateApplication)
    }

    // nn::Result ResolveApplicationContentPath(nn::ncm::ProgramId id, nn::ncm::ContentType type) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResolveApplicationContentPath, (::nn::ncm::ProgramId id, ::nn::ncm::ContentType type))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResolveApplicationContentPath)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResolveApplicationContentPath)
    }

    // nn::Result BeginInstallApplication(nn::ncm::ApplicationId id, std::uint32_t version, nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BeginInstallApplication, (::nn::ncm::ApplicationId id, ::std::uint32_t version, ::nn::ncm::StorageId storageId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BeginInstallApplication)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(version)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BeginInstallApplication)
    }

    // nn::Result DeleteApplicationRecord(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteApplicationRecord, (::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteApplicationRecord)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteApplicationRecord)
    }

    // nn::Result RequestApplicationUpdateInfo(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestApplicationUpdateInfo, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestApplicationUpdateInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestApplicationUpdateInfo)
    }

    // nn::Result CancelApplicationDownload(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelApplicationDownload, (::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelApplicationDownload)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelApplicationDownload)
    }

    // nn::Result ResumeApplicationDownload(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResumeApplicationDownload, (::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResumeApplicationDownload)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResumeApplicationDownload)
    }

    // nn::Result UpdateVersionList(const nn::sf::InBuffer& buffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpdateVersionList, (const ::nn::sf::InBuffer& buffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UpdateVersionList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UpdateVersionList)
    }

    // nn::Result PushLaunchVersion(nn::ncm::ApplicationId id, std::uint32_t version) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PushLaunchVersion, (::nn::ncm::ApplicationId id, ::std::uint32_t version))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PushLaunchVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(version)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PushLaunchVersion)
    }

    // nn::Result ListRequiredVersion(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::RequiredVersionEntry>& requiredVersionEntries) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListRequiredVersion, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::RequiredVersionEntry>& requiredVersionEntries))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListRequiredVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(requiredVersionEntries)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListRequiredVersion)
    }

    // nn::Result CheckApplicationLaunchVersion(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckApplicationLaunchVersion, (::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CheckApplicationLaunchVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CheckApplicationLaunchVersion)
    }

    // nn::Result CheckApplicationLaunchRights(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckApplicationLaunchRights, (::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CheckApplicationLaunchRights)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CheckApplicationLaunchRights)
    }

    // nn::Result GetApplicationLogoData(nn::sf::Out<std::int64_t> outSize, const nn::sf::OutBuffer& outBuffer, nn::ncm::ApplicationId id, const nn::ncm::Path& logoPath) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationLogoData, (::nn::sf::Out<::std::int64_t> outSize, const ::nn::sf::OutBuffer& outBuffer, ::nn::ncm::ApplicationId id, const ::nn::ncm::Path& logoPath))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetApplicationLogoData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(logoPath)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetApplicationLogoData)
    }

    // nn::Result CalculateApplicationDownloadRequiredSize(nn::sf::Out<nn::ncm::StorageId> outStorage, nn::sf::Out<std::int64_t> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CalculateApplicationDownloadRequiredSize, (::nn::sf::Out<::nn::ncm::StorageId> outStorage, ::nn::sf::Out<::std::int64_t> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CalculateApplicationDownloadRequiredSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outStorage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CalculateApplicationDownloadRequiredSize)
    }

    // nn::Result CleanupSdCard() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CleanupSdCard)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CleanupSdCard)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CleanupSdCard)
    }

    // nn::Result CheckSdCardMountStatus() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CheckSdCardMountStatus)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CheckSdCardMountStatus)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CheckSdCardMountStatus)
    }

    // nn::Result GetSdCardMountStatusChangedEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSdCardMountStatusChangedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSdCardMountStatusChangedEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSdCardMountStatusChangedEvent)
    }

    // nn::Result GetGameCardAttachmentEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardAttachmentEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGameCardAttachmentEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGameCardAttachmentEvent)
    }

    // nn::Result GetGameCardAttachmentInfo(nn::sf::Out<nn::ns::GameCardAttachmentInfo> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardAttachmentInfo, (::nn::sf::Out<::nn::ns::GameCardAttachmentInfo> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGameCardAttachmentInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGameCardAttachmentInfo)
    }

    // nn::Result GetTotalSpaceSize(nn::sf::Out<std::int64_t> outSize, nn::ncm::StorageId storage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTotalSpaceSize, (::nn::sf::Out<::std::int64_t> outSize, ::nn::ncm::StorageId storage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetTotalSpaceSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetTotalSpaceSize)
    }

    // nn::Result GetFreeSpaceSize(nn::sf::Out<std::int64_t> outSize, nn::ncm::StorageId storage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFreeSpaceSize, (::nn::sf::Out<::std::int64_t> outSize, ::nn::ncm::StorageId storage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFreeSpaceSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFreeSpaceSize)
    }

    // nn::Result GetSdCardRemovedEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSdCardRemovedEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSdCardRemovedEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSdCardRemovedEvent)
    }

    // nn::Result GetGameCardUpdateDetectionEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardUpdateDetectionEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGameCardUpdateDetectionEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGameCardUpdateDetectionEvent)
    }

    // nn::Result DisableApplicationAutoDelete(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DisableApplicationAutoDelete, (::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DisableApplicationAutoDelete)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DisableApplicationAutoDelete)
    }

    // nn::Result EnableApplicationAutoDelete(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnableApplicationAutoDelete, (::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableApplicationAutoDelete)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableApplicationAutoDelete)
    }

    // nn::Result SetApplicationTerminateResult(nn::ncm::ApplicationId id, std::uint32_t result) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetApplicationTerminateResult, (::nn::ncm::ApplicationId id, ::std::uint32_t result))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetApplicationTerminateResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(result)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetApplicationTerminateResult)
    }

    // nn::Result ClearApplicationTerminateResult(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ClearApplicationTerminateResult, (::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ClearApplicationTerminateResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ClearApplicationTerminateResult)
    }

    // nn::Result GetLastSdCardMountUnexpectedResult() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(GetLastSdCardMountUnexpectedResult)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLastSdCardMountUnexpectedResult)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLastSdCardMountUnexpectedResult)
    }

    // nn::Result GetBackgroundDownloadStressTaskInfo(nn::sf::Out<nn::nim::BackgroundDownloadStressTaskInfo> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBackgroundDownloadStressTaskInfo, (::nn::sf::Out<::nn::nim::BackgroundDownloadStressTaskInfo> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBackgroundDownloadStressTaskInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBackgroundDownloadStressTaskInfo)
    }

    // nn::Result GetGameCardStopper(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IGameCardStopper>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardStopper, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IGameCardStopper>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGameCardStopper)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGameCardStopper)
    }

    // nn::Result IsSystemProgramInstalled(nn::sf::Out<bool> outValue, nn::ncm::SystemProgramId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsSystemProgramInstalled, (::nn::sf::Out<bool> outValue, ::nn::ncm::SystemProgramId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsSystemProgramInstalled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsSystemProgramInstalled)
    }

    // nn::Result StartApplyDeltaTask(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartApplyDeltaTask, (::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartApplyDeltaTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartApplyDeltaTask)
    }

    // nn::Result GetRequestServerStopper(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IRequestServerStopper>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRequestServerStopper, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IRequestServerStopper>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRequestServerStopper)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRequestServerStopper)
    }

    // nn::Result GetBackgroundApplyDeltaStressTaskInfo(nn::sf::Out<nn::nim::BackgroundDownloadStressTaskInfo> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBackgroundApplyDeltaStressTaskInfo, (::nn::sf::Out<::nn::nim::BackgroundDownloadStressTaskInfo> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBackgroundApplyDeltaStressTaskInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBackgroundApplyDeltaStressTaskInfo)
    }

    // nn::Result CancelApplicationApplyDelta(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelApplicationApplyDelta, (::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelApplicationApplyDelta)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelApplicationApplyDelta)
    }

    // nn::Result ResumeApplicationApplyDelta(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResumeApplicationApplyDelta, (::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResumeApplicationApplyDelta)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResumeApplicationApplyDelta)
    }

    // nn::Result CalculateApplicationApplyDeltaRequiredSize(nn::sf::Out<nn::ncm::StorageId> outStorage, nn::sf::Out<std::int64_t> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CalculateApplicationApplyDeltaRequiredSize, (::nn::sf::Out<::nn::ncm::StorageId> outStorage, ::nn::sf::Out<::std::int64_t> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CalculateApplicationApplyDeltaRequiredSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outStorage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CalculateApplicationApplyDeltaRequiredSize)
    }

    // nn::Result ResumeAll() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ResumeAll)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResumeAll)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResumeAll)
    }

    // nn::Result GetStorageSize(nn::sf::Out<std::int64_t> outTotalSize, nn::sf::Out<std::int64_t> outFreeSize, nn::ncm::StorageId storage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetStorageSize, (::nn::sf::Out<::std::int64_t> outTotalSize, ::nn::sf::Out<::std::int64_t> outFreeSize, ::nn::ncm::StorageId storage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetStorageSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outTotalSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outFreeSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetStorageSize)
    }

    // nn::Result RequestDownloadApplication(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId applicationId, nn::ncm::StorageId storageId, bool forceDirectUpdate) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestDownloadApplication, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId applicationId, ::nn::ncm::StorageId storageId, bool forceDirectUpdate))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestDownloadApplication)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(forceDirectUpdate)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestDownloadApplication)
    }

    // nn::Result RequestDownloadAddOnContent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId id, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestDownloadAddOnContent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId id, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::StorageId storageId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestDownloadAddOnContent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(keyList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestDownloadAddOnContent)
    }

    // nn::Result DownloadApplication(nn::ncm::ApplicationId applicationId, nn::ncm::StorageId storageId, bool forceDirectUpdate) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DownloadApplication, (::nn::ncm::ApplicationId applicationId, ::nn::ncm::StorageId storageId, bool forceDirectUpdate))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DownloadApplication)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(forceDirectUpdate)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DownloadApplication)
    }

    // nn::Result CheckApplicationResumeRights(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CheckApplicationResumeRights, (::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CheckApplicationResumeRights)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CheckApplicationResumeRights)
    }

    // nn::Result GetDynamicCommitEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDynamicCommitEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDynamicCommitEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDynamicCommitEvent)
    }

    // nn::Result RequestUpdateApplication2(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestUpdateApplication2, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestUpdateApplication2)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestUpdateApplication2)
    }

    // void EnableApplicationCrashReport(bool isEnable) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(EnableApplicationCrashReport, (bool isEnable))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableApplicationCrashReport)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isEnable)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableApplicationCrashReport)
    }

    // bool IsApplicationCrashReportEnabled() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(IsApplicationCrashReportEnabled, (bool))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsApplicationCrashReportEnabled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsApplicationCrashReportEnabled)
    }

    // nn::Result BoostSystemMemoryResourceLimit(std::int64_t boostSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(BoostSystemMemoryResourceLimit, (::std::int64_t boostSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(BoostSystemMemoryResourceLimit)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(boostSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(BoostSystemMemoryResourceLimit)
    }

    // nn::Result DeprecatedLaunchApplication(nn::sf::Out<nn::os::ProcessId> outValue, nn::ncm::ApplicationId id, std::uint8_t programIndex) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeprecatedLaunchApplication, (::nn::sf::Out<::nn::os::ProcessId> outValue, ::nn::ncm::ApplicationId id, ::std::uint8_t programIndex))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeprecatedLaunchApplication)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(programIndex)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeprecatedLaunchApplication)
    }

    // nn::Result GetRunningApplicationProgramId(nn::sf::Out<nn::ncm::ProgramId> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRunningApplicationProgramId, (::nn::sf::Out<::nn::ncm::ProgramId> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRunningApplicationProgramId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRunningApplicationProgramId)
    }

    // nn::Result GetMainApplicationProgramIndex(nn::sf::Out<std::uint8_t> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMainApplicationProgramIndex, (::nn::sf::Out<::std::uint8_t> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetMainApplicationProgramIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetMainApplicationProgramIndex)
    }

    // nn::Result LaunchApplication(nn::sf::Out<nn::os::ProcessId> outValue, const nn::ns::ApplicationLaunchInfo& info, std::uint8_t programIndex) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LaunchApplication, (::nn::sf::Out<::nn::os::ProcessId> outValue, const ::nn::ns::ApplicationLaunchInfo& info, ::std::uint8_t programIndex))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LaunchApplication)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(info)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(programIndex)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LaunchApplication)
    }

    // nn::Result GetApplicationLaunchInfo(nn::sf::Out<nn::ns::ApplicationLaunchInfo> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationLaunchInfo, (::nn::sf::Out<::nn::ns::ApplicationLaunchInfo> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetApplicationLaunchInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetApplicationLaunchInfo)
    }

    // nn::Result AcquireApplicationLaunchInfo(nn::sf::Out<nn::ns::ApplicationLaunchInfo> outValue, nn::os::ProcessId processId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AcquireApplicationLaunchInfo, (::nn::sf::Out<::nn::ns::ApplicationLaunchInfo> outValue, ::nn::os::ProcessId processId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AcquireApplicationLaunchInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AcquireApplicationLaunchInfo)
    }

    // nn::Result GetMainApplicationProgramIndexByApplicationLaunchInfo(nn::sf::Out<std::uint8_t> outValue, const nn::ns::ApplicationLaunchInfo& info) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMainApplicationProgramIndexByApplicationLaunchInfo, (::nn::sf::Out<::std::uint8_t> outValue, const ::nn::ns::ApplicationLaunchInfo& info))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetMainApplicationProgramIndexByApplicationLaunchInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(info)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetMainApplicationProgramIndexByApplicationLaunchInfo)
    }

    // void EnableApplicationAllThreadDumpOnCrash(bool isEnabled) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_N(EnableApplicationAllThreadDumpOnCrash, (bool isEnabled))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableApplicationAllThreadDumpOnCrash)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isEnabled)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableApplicationAllThreadDumpOnCrash)
    }

    // nn::Result ResetToFactorySettings() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ResetToFactorySettings)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResetToFactorySettings)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResetToFactorySettings)
    }

    // nn::Result ResetToFactorySettingsWithoutUserSaveData() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ResetToFactorySettingsWithoutUserSaveData)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResetToFactorySettingsWithoutUserSaveData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResetToFactorySettingsWithoutUserSaveData)
    }

    // nn::Result ResetToFactorySettingsForRefurbishment() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ResetToFactorySettingsForRefurbishment)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResetToFactorySettingsForRefurbishment)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResetToFactorySettingsForRefurbishment)
    }

    // nn::Result CalculateUserSaveDataStatistics(nn::sf::Out<nn::ns::UserSaveDataStatistics> pOut, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CalculateUserSaveDataStatistics, (::nn::sf::Out<::nn::ns::UserSaveDataStatistics> pOut, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CalculateUserSaveDataStatistics)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CalculateUserSaveDataStatistics)
    }

    // nn::Result DeleteUserSaveDataAll(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IProgressMonitorForDeleteUserSaveDataAll>> pOut, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteUserSaveDataAll, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IProgressMonitorForDeleteUserSaveDataAll>> pOut, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteUserSaveDataAll)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteUserSaveDataAll)
    }

    // nn::Result DeleteUserSystemSaveData(const nn::account::Uid& uid, nn::fs::SystemSaveDataId sysSaveId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteUserSystemSaveData, (const ::nn::account::Uid& uid, ::nn::fs::SystemSaveDataId sysSaveId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteUserSystemSaveData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sysSaveId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteUserSystemSaveData)
    }

    // nn::Result UnregisterNetworkServiceAccount(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterNetworkServiceAccount, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnregisterNetworkServiceAccount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnregisterNetworkServiceAccount)
    }

    // nn::Result UnregisterNetworkServiceAccountWithUserSaveDataDeletion(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UnregisterNetworkServiceAccountWithUserSaveDataDeletion, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnregisterNetworkServiceAccountWithUserSaveDataDeletion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnregisterNetworkServiceAccountWithUserSaveDataDeletion)
    }

    // nn::Result GetApplicationShellEvent(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationShellEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetApplicationShellEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetApplicationShellEvent)
    }

    // nn::Result PopApplicationShellEventInfo(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationShellEventInfo>& outList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PopApplicationShellEventInfo, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationShellEventInfo>& outList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PopApplicationShellEventInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PopApplicationShellEventInfo)
    }

    // nn::Result LaunchLibraryApplet(nn::sf::Out<nn::os::ProcessId> outValue, nn::ncm::SystemProgramId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LaunchLibraryApplet, (::nn::sf::Out<::nn::os::ProcessId> outValue, ::nn::ncm::SystemProgramId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LaunchLibraryApplet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LaunchLibraryApplet)
    }

    // nn::Result TerminateLibraryApplet(nn::os::ProcessId pid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TerminateLibraryApplet, (::nn::os::ProcessId pid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TerminateLibraryApplet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TerminateLibraryApplet)
    }

    // nn::Result LaunchSystemApplet(nn::sf::Out<nn::os::ProcessId> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LaunchSystemApplet, (::nn::sf::Out<::nn::os::ProcessId> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LaunchSystemApplet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LaunchSystemApplet)
    }

    // nn::Result TerminateSystemApplet(nn::os::ProcessId pid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TerminateSystemApplet, (::nn::os::ProcessId pid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TerminateSystemApplet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TerminateSystemApplet)
    }

    // nn::Result LaunchOverlayApplet(nn::sf::Out<nn::os::ProcessId> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LaunchOverlayApplet, (::nn::sf::Out<::nn::os::ProcessId> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LaunchOverlayApplet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LaunchOverlayApplet)
    }

    // nn::Result TerminateOverlayApplet(nn::os::ProcessId pid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TerminateOverlayApplet, (::nn::os::ProcessId pid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TerminateOverlayApplet)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TerminateOverlayApplet)
    }

    // nn::Result InvalidateAllApplicationControlCache() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(InvalidateAllApplicationControlCache)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(InvalidateAllApplicationControlCache)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(InvalidateAllApplicationControlCache)
    }

    // nn::Result RequestDownloadApplicationControlData(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestDownloadApplicationControlData, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestDownloadApplicationControlData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestDownloadApplicationControlData)
    }

    // nn::Result GetMaxApplicationControlCacheCount(nn::sf::Out<std::int32_t> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMaxApplicationControlCacheCount, (::nn::sf::Out<::std::int32_t> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetMaxApplicationControlCacheCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetMaxApplicationControlCacheCount)
    }

    // nn::Result InvalidateApplicationControlCache(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(InvalidateApplicationControlCache, (::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(InvalidateApplicationControlCache)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(InvalidateApplicationControlCache)
    }

    // nn::Result ListApplicationControlCacheEntryInfo(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationControlCacheEntryInfo>& outList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationControlCacheEntryInfo, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationControlCacheEntryInfo>& outList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListApplicationControlCacheEntryInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListApplicationControlCacheEntryInfo)
    }

    // nn::Result GetApplicationControlProperty(nn::sf::Out<nn::ns::ApplicationControlProperty> outValue, const nn::ns::ApplicationLaunchInfo& info, std::uint8_t programIndex) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationControlProperty, (::nn::sf::Out<::nn::ns::ApplicationControlProperty> outValue, const ::nn::ns::ApplicationLaunchInfo& info, ::std::uint8_t programIndex))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetApplicationControlProperty)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(info)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(programIndex)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetApplicationControlProperty)
    }

    // nn::Result RequestCheckGameCardRegistration(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId appId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestCheckGameCardRegistration, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId appId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestCheckGameCardRegistration)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestCheckGameCardRegistration)
    }

    // nn::Result RequestGameCardRegistrationGoldPoint(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync, const nn::account::Uid& uid, nn::ncm::ApplicationId appId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestGameCardRegistrationGoldPoint, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync, const ::nn::account::Uid& uid, ::nn::ncm::ApplicationId appId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestGameCardRegistrationGoldPoint)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestGameCardRegistrationGoldPoint)
    }

    // nn::Result RequestRegisterGameCard(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, const nn::account::Uid& uid, nn::ncm::ApplicationId appId, std::int32_t goldPoint) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestRegisterGameCard, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, const ::nn::account::Uid& uid, ::nn::ncm::ApplicationId appId, ::std::int32_t goldPoint))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestRegisterGameCard)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(goldPoint)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestRegisterGameCard)
    }

    // nn::Result GetGameCardMountFailureEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardMountFailureEvent, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGameCardMountFailureEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGameCardMountFailureEvent)
    }

    // nn::Result IsGameCardInserted(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsGameCardInserted, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsGameCardInserted)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsGameCardInserted)
    }

    // nn::Result EnsureGameCardAccess() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(EnsureGameCardAccess)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnsureGameCardAccess)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnsureGameCardAccess)
    }

    // nn::Result GetLastGameCardMountFailureResult() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(GetLastGameCardMountFailureResult)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLastGameCardMountFailureResult)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLastGameCardMountFailureResult)
    }

    // nn::Result ListApplicationIdOnGameCard(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ApplicationId>& outList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationIdOnGameCard, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ApplicationId>& outList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListApplicationIdOnGameCard)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListApplicationIdOnGameCard)
    }

    // nn::Result CountApplicationContentMeta(nn::sf::Out<std::int32_t> outValue, nn::ncm::ApplicationId appId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CountApplicationContentMeta, (::nn::sf::Out<::std::int32_t> outValue, ::nn::ncm::ApplicationId appId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CountApplicationContentMeta)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CountApplicationContentMeta)
    }

    // nn::Result ListApplicationContentMetaStatus(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationContentMetaStatus>& outList, nn::ncm::ApplicationId appId, std::int32_t offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationContentMetaStatus, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationContentMetaStatus>& outList, ::nn::ncm::ApplicationId appId, ::std::int32_t offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListApplicationContentMetaStatus)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListApplicationContentMetaStatus)
    }

    // nn::Result ListAvailableAddOnContent(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationContentMetaStatus>& outList, nn::ncm::ApplicationId appId, std::int32_t offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListAvailableAddOnContent, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationContentMetaStatus>& outList, ::nn::ncm::ApplicationId appId, ::std::int32_t offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListAvailableAddOnContent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListAvailableAddOnContent)
    }

    // nn::Result GetOwnedApplicationContentMetaStatus(nn::sf::Out<nn::ns::ApplicationContentMetaStatus> outValue, nn::ncm::ApplicationId appId, nn::Bit64 contentMetaId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetOwnedApplicationContentMetaStatus, (::nn::sf::Out<::nn::ns::ApplicationContentMetaStatus> outValue, ::nn::ncm::ApplicationId appId, ::nn::Bit64 contentMetaId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetOwnedApplicationContentMetaStatus)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(contentMetaId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetOwnedApplicationContentMetaStatus)
    }

    // nn::Result RegisterContentsExternalKey(nn::ncm::ApplicationId appId, nn::Bit64 contentMetaId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterContentsExternalKey, (::nn::ncm::ApplicationId appId, ::nn::Bit64 contentMetaId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterContentsExternalKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(contentMetaId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterContentsExternalKey)
    }

    // nn::Result ListApplicationContentMetaStatusWithRightsCheck(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationContentMetaStatus>& outList, nn::ncm::ApplicationId appId, std::int32_t offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationContentMetaStatusWithRightsCheck, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationContentMetaStatus>& outList, ::nn::ncm::ApplicationId appId, ::std::int32_t offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListApplicationContentMetaStatusWithRightsCheck)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListApplicationContentMetaStatusWithRightsCheck)
    }

    // nn::Result GetContentMetaStorage(nn::sf::Out<nn::ncm::StorageId> outValue, const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetContentMetaStorage, (::nn::sf::Out<::nn::ncm::StorageId> outValue, const ::nn::ncm::ContentMetaKey& key))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetContentMetaStorage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetContentMetaStorage)
    }

    // nn::Result PushDownloadTaskList(const nn::sf::InBuffer& buffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PushDownloadTaskList, (const ::nn::sf::InBuffer& buffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PushDownloadTaskList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PushDownloadTaskList)
    }

    // nn::Result ClearTaskStatusList() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ClearTaskStatusList)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ClearTaskStatusList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ClearTaskStatusList)
    }

    // nn::Result RequestDownloadTaskList() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RequestDownloadTaskList)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestDownloadTaskList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestDownloadTaskList)
    }

    // nn::Result RequestEnsureDownloadTask(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestEnsureDownloadTask, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestEnsureDownloadTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestEnsureDownloadTask)
    }

    // nn::Result ListDownloadTaskStatus(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::DownloadTaskStatus>& outList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListDownloadTaskStatus, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::DownloadTaskStatus>& outList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListDownloadTaskStatus)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListDownloadTaskStatus)
    }

    // nn::Result RequestDownloadTaskListData(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestDownloadTaskListData, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestDownloadTaskListData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestDownloadTaskListData)
    }

    // nn::Result RequestVersionList() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RequestVersionList)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestVersionList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestVersionList)
    }

    // nn::Result ListVersionList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::VersionListEntry>& versionListEntries) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListVersionList, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::VersionListEntry>& versionListEntries))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListVersionList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(versionListEntries)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListVersionList)
    }

    // nn::Result RequestVersionListData(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestVersionListData, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestVersionListData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestVersionListData)
    }

    // nn::Result GetApplicationRecord(nn::sf::Out<nn::ns::ApplicationRecord> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationRecord, (::nn::sf::Out<::nn::ns::ApplicationRecord> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetApplicationRecord)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetApplicationRecord)
    }

    // nn::Result GetApplicationRecordProperty(nn::sf::Out<nn::ns::ApplicationRecordProperty> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationRecordProperty, (::nn::sf::Out<::nn::ns::ApplicationRecordProperty> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetApplicationRecordProperty)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetApplicationRecordProperty)
    }

    // nn::Result EnableApplicationAutoUpdate(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnableApplicationAutoUpdate, (::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableApplicationAutoUpdate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableApplicationAutoUpdate)
    }

    // nn::Result DisableApplicationAutoUpdate(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DisableApplicationAutoUpdate, (::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DisableApplicationAutoUpdate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DisableApplicationAutoUpdate)
    }

    // nn::Result TouchApplication(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(TouchApplication, (::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TouchApplication)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TouchApplication)
    }

    // nn::Result RequestApplicationUpdate(nn::ncm::ApplicationId id, nn::Bit32 resultInnerValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestApplicationUpdate, (::nn::ncm::ApplicationId id, ::nn::Bit32 resultInnerValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestApplicationUpdate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(resultInnerValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestApplicationUpdate)
    }

    // nn::Result IsApplicationUpdateRequested(nn::sf::Out<bool> outValue, nn::sf::Out<nn::Bit32> resultInnerValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsApplicationUpdateRequested, (::nn::sf::Out<bool> outValue, ::nn::sf::Out<::nn::Bit32> resultInnerValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsApplicationUpdateRequested)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(resultInnerValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsApplicationUpdateRequested)
    }

    // nn::Result WithdrawApplicationUpdateRequest(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WithdrawApplicationUpdateRequest, (::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(WithdrawApplicationUpdateRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(WithdrawApplicationUpdateRequest)
    }

    // nn::Result ListApplicationRecordInstalledContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, nn::ncm::ApplicationId id, std::int32_t offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationRecordInstalledContentMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::nn::ncm::ApplicationId id, ::std::int32_t offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListApplicationRecordInstalledContentMeta)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListApplicationRecordInstalledContentMeta)
    }

    // nn::Result WithdrawCleanupAddOnContentsWithNoRightsRecommendation(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(WithdrawCleanupAddOnContentsWithNoRightsRecommendation, (::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(WithdrawCleanupAddOnContentsWithNoRightsRecommendation)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(WithdrawCleanupAddOnContentsWithNoRightsRecommendation)
    }

    // nn::Result HasApplicationRecord(nn::sf::Out<bool> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasApplicationRecord, (::nn::sf::Out<bool> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HasApplicationRecord)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HasApplicationRecord)
    }

    // nn::Result SetPreInstalledApplication(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPreInstalledApplication, (::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetPreInstalledApplication)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetPreInstalledApplication)
    }

    // nn::Result ClearPreInstalledApplicationFlag(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ClearPreInstalledApplicationFlag, (::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ClearPreInstalledApplicationFlag)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ClearPreInstalledApplicationFlag)
    }

    // nn::Result RequestVerifyApplicationDeprecated(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IProgressAsyncResult>> outAsync, nn::ncm::ApplicationId id, nn::sf::NativeHandle&& transferHandle, std::uint64_t transferSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestVerifyApplicationDeprecated, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IProgressAsyncResult>> outAsync, ::nn::ncm::ApplicationId id, ::nn::sf::NativeHandle&& transferHandle, ::std::uint64_t transferSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestVerifyApplicationDeprecated)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(transferHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(transferSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestVerifyApplicationDeprecated)
    }

    // nn::Result CorruptApplicationForDebug(nn::ncm::ApplicationId id, nn::Bit32 flags, nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CorruptApplicationForDebug, (::nn::ncm::ApplicationId id, ::nn::Bit32 flags, ::nn::ncm::StorageId storageId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CorruptApplicationForDebug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flags)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CorruptApplicationForDebug)
    }

    // nn::Result RequestVerifyAddOnContentsRights(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IProgressAsyncResult>> outAsync, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestVerifyAddOnContentsRights, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IProgressAsyncResult>> outAsync, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestVerifyAddOnContentsRights)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestVerifyAddOnContentsRights)
    }

    // nn::Result RequestVerifyApplication(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IProgressAsyncResult>> outAsync, nn::ncm::ApplicationId id, nn::Bit32 flags, nn::sf::NativeHandle&& transferHandle, std::uint64_t transferSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestVerifyApplication, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IProgressAsyncResult>> outAsync, ::nn::ncm::ApplicationId id, ::nn::Bit32 flags, ::nn::sf::NativeHandle&& transferHandle, ::std::uint64_t transferSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestVerifyApplication)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flags)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(transferHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(transferSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestVerifyApplication)
    }

    // nn::Result CorruptContentForDebug(const nn::ncm::ContentMetaKey& key, nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CorruptContentForDebug, (const ::nn::ncm::ContentMetaKey& key, ::nn::ncm::StorageId storageId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CorruptContentForDebug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CorruptContentForDebug)
    }

    // nn::Result NeedsUpdateVulnerability(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NeedsUpdateVulnerability, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(NeedsUpdateVulnerability)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(NeedsUpdateVulnerability)
    }

    // nn::Result IsAnyApplicationEntityInstalled(nn::sf::Out<bool> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsAnyApplicationEntityInstalled, (::nn::sf::Out<bool> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsAnyApplicationEntityInstalled)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsAnyApplicationEntityInstalled)
    }

    // nn::Result DeleteApplicationContentEntities(nn::ncm::ApplicationId id, std::uint32_t innerValue, nn::ncm::StorageId storage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteApplicationContentEntities, (::nn::ncm::ApplicationId id, ::std::uint32_t innerValue, ::nn::ncm::StorageId storage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteApplicationContentEntities)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(innerValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteApplicationContentEntities)
    }

    // nn::Result CleanupUnrecordedApplicationEntity(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CleanupUnrecordedApplicationEntity, (::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CleanupUnrecordedApplicationEntity)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CleanupUnrecordedApplicationEntity)
    }

    // nn::Result CleanupAddOnContentsWithNoRights(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CleanupAddOnContentsWithNoRights, (::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CleanupAddOnContentsWithNoRights)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CleanupAddOnContentsWithNoRights)
    }

    // nn::Result DeleteApplicationContentEntity(const nn::ncm::ContentMetaKey& key) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteApplicationContentEntity, (const ::nn::ncm::ContentMetaKey& key))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteApplicationContentEntity)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteApplicationContentEntity)
    }

    // nn::Result DeleteApplicationCompletelyForDebug(nn::ncm::ApplicationId id, std::uint32_t innerValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteApplicationCompletelyForDebug, (::nn::ncm::ApplicationId id, ::std::uint32_t innerValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteApplicationCompletelyForDebug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(innerValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteApplicationCompletelyForDebug)
    }

    // nn::Result PrepareShutdown() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(PrepareShutdown)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PrepareShutdown)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PrepareShutdown)
    }

    // nn::Result FormatSdCard() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(FormatSdCard)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(FormatSdCard)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(FormatSdCard)
    }

    // nn::Result NeedsSystemUpdateToFormatSdCard(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NeedsSystemUpdateToFormatSdCard, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(NeedsSystemUpdateToFormatSdCard)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(NeedsSystemUpdateToFormatSdCard)
    }

    // nn::Result GetLastSdCardFormatUnexpectedResult() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(GetLastSdCardFormatUnexpectedResult)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLastSdCardFormatUnexpectedResult)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLastSdCardFormatUnexpectedResult)
    }

    // nn::Result InsertSdCard() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(InsertSdCard)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(InsertSdCard)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(InsertSdCard)
    }

    // nn::Result RemoveSdCard() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RemoveSdCard)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RemoveSdCard)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RemoveSdCard)
    }

    // nn::Result GetSystemSeedForPseudoDeviceId(nn::sf::Out<nn::ns::SystemSeedForPseudoDeviceId> pOutSeed) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemSeedForPseudoDeviceId, (::nn::sf::Out<::nn::ns::SystemSeedForPseudoDeviceId> pOutSeed))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSystemSeedForPseudoDeviceId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSeed)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSystemSeedForPseudoDeviceId)
    }

    // nn::Result ResetSystemSeedForPseudoDeviceId() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ResetSystemSeedForPseudoDeviceId)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResetSystemSeedForPseudoDeviceId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResetSystemSeedForPseudoDeviceId)
    }

    // nn::Result ListApplicationDownloadingContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::StorageContentMetaKey>& outList, nn::ncm::ApplicationId id, std::int32_t offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationDownloadingContentMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::StorageContentMetaKey>& outList, ::nn::ncm::ApplicationId id, ::std::int32_t offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListApplicationDownloadingContentMeta)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListApplicationDownloadingContentMeta)
    }

    // nn::Result GetApplicationView(const nn::sf::OutArray<nn::ns::ApplicationView>& outList, const nn::sf::InArray<nn::ncm::ApplicationId>& idList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationView, (const ::nn::sf::OutArray<::nn::ns::ApplicationView>& outList, const ::nn::sf::InArray<::nn::ncm::ApplicationId>& idList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetApplicationView)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(idList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetApplicationView)
    }

    // nn::Result GetApplicationDownloadTaskStatus(nn::sf::Out<nn::ns::ApplicationDownloadTaskStatus> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationDownloadTaskStatus, (::nn::sf::Out<::nn::ns::ApplicationDownloadTaskStatus> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetApplicationDownloadTaskStatus)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetApplicationDownloadTaskStatus)
    }

    // nn::Result GetApplicationViewDownloadErrorContext(nn::sf::Out<nn::err::ErrorContext> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationViewDownloadErrorContext, (::nn::sf::Out<::nn::err::ErrorContext> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetApplicationViewDownloadErrorContext)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetApplicationViewDownloadErrorContext)
    }

    // nn::Result IsNotificationSetupCompleted(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsNotificationSetupCompleted, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsNotificationSetupCompleted)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsNotificationSetupCompleted)
    }

    // nn::Result GetLastNotificationInfoCount(nn::sf::Out<std::int64_t> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLastNotificationInfoCount, (::nn::sf::Out<::std::int64_t> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLastNotificationInfoCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLastNotificationInfoCount)
    }

    // nn::Result ListLastNotificationInfo(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::NotificationInfo>& outList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListLastNotificationInfo, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::NotificationInfo>& outList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListLastNotificationInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListLastNotificationInfo)
    }

    // nn::Result ListNotificationTask(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::AsyncTask>& outList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListNotificationTask, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::AsyncTask>& outList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListNotificationTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListNotificationTask)
    }

    // nn::Result IsActiveAccount(nn::sf::Out<bool> outValue, nn::es::AccountId accountId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsActiveAccount, (::nn::sf::Out<bool> outValue, ::nn::es::AccountId accountId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsActiveAccount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accountId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsActiveAccount)
    }

    // nn::Result RequestDownloadApplicationPrepurchasedRights(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestDownloadApplicationPrepurchasedRights, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestDownloadApplicationPrepurchasedRights)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestDownloadApplicationPrepurchasedRights)
    }

    // nn::Result GetApplicationTicketInfo(nn::sf::Out<nn::ns::ApplicationTicketInfo> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationTicketInfo, (::nn::sf::Out<::nn::ns::ApplicationTicketInfo> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetApplicationTicketInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetApplicationTicketInfo)
    }

    // nn::Result GetSystemDeliveryInfo(nn::sf::Out<nn::ns::SystemDeliveryInfo> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemDeliveryInfo, (::nn::sf::Out<::nn::ns::SystemDeliveryInfo> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSystemDeliveryInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSystemDeliveryInfo)
    }

    // nn::Result SelectLatestSystemDeliveryInfo(nn::sf::Out<std::int32_t> outValue, const nn::sf::InArray<nn::ns::SystemDeliveryInfo>& list, const nn::ns::SystemDeliveryInfo& receiverSystemInfo, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& receiverAppInfo) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SelectLatestSystemDeliveryInfo, (::nn::sf::Out<::std::int32_t> outValue, const ::nn::sf::InArray<::nn::ns::SystemDeliveryInfo>& list, const ::nn::ns::SystemDeliveryInfo& receiverSystemInfo, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& receiverAppInfo))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SelectLatestSystemDeliveryInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(list)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(receiverSystemInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(receiverAppInfo)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SelectLatestSystemDeliveryInfo)
    }

    // nn::Result VerifyDeliveryProtocolVersion(const nn::ns::SystemDeliveryInfo& info) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(VerifyDeliveryProtocolVersion, (const ::nn::ns::SystemDeliveryInfo& info))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(VerifyDeliveryProtocolVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(info)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(VerifyDeliveryProtocolVersion)
    }

    // nn::Result GetApplicationDeliveryInfo(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationDeliveryInfo>& outValue, nn::ncm::ApplicationId id, nn::ns::ApplicationDeliveryAttribute attributes) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationDeliveryInfo, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationDeliveryInfo>& outValue, ::nn::ncm::ApplicationId id, ::nn::ns::ApplicationDeliveryAttribute attributes))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetApplicationDeliveryInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(attributes)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetApplicationDeliveryInfo)
    }

    // nn::Result HasAllContentsToDeliver(nn::sf::Out<bool> outValue, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& appInfoList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasAllContentsToDeliver, (::nn::sf::Out<bool> outValue, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& appInfoList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HasAllContentsToDeliver)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appInfoList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HasAllContentsToDeliver)
    }

    // nn::Result CompareApplicationDeliveryInfo(nn::sf::Out<std::int32_t> outValue, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& lhs, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& rhs) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CompareApplicationDeliveryInfo, (::nn::sf::Out<::std::int32_t> outValue, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& lhs, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& rhs))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CompareApplicationDeliveryInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(lhs)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rhs)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CompareApplicationDeliveryInfo)
    }

    // nn::Result CanDeliverApplication(nn::sf::Out<bool> outValue, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& receiverInfoList, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& senderInfoList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CanDeliverApplication, (::nn::sf::Out<bool> outValue, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& receiverInfoList, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& senderInfoList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CanDeliverApplication)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(receiverInfoList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(senderInfoList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CanDeliverApplication)
    }

    // nn::Result ListContentMetaKeyToDeliverApplication(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ContentMetaKey>& outList, std::int32_t offset, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& infoList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListContentMetaKeyToDeliverApplication, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ContentMetaKey>& outList, ::std::int32_t offset, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& infoList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListContentMetaKeyToDeliverApplication)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(infoList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListContentMetaKeyToDeliverApplication)
    }

    // nn::Result NeedsSystemUpdateToDeliverApplication(nn::sf::Out<bool> outValue, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& applicationInfoList, const nn::ns::SystemDeliveryInfo& systemInfo) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NeedsSystemUpdateToDeliverApplication, (::nn::sf::Out<bool> outValue, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& applicationInfoList, const ::nn::ns::SystemDeliveryInfo& systemInfo))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(NeedsSystemUpdateToDeliverApplication)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationInfoList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(systemInfo)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(NeedsSystemUpdateToDeliverApplication)
    }

    // nn::Result EstimateRequiredSize(nn::sf::Out<std::int64_t> outValue, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EstimateRequiredSize, (::nn::sf::Out<::std::int64_t> outValue, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EstimateRequiredSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(keyList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EstimateRequiredSize)
    }

    // nn::Result RequestReceiveApplication(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, std::uint32_t ipv4, std::uint16_t port, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::ApplicationId id, nn::ncm::StorageId storageId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestReceiveApplication, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::ApplicationId id, ::nn::ncm::StorageId storageId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestReceiveApplication)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ipv4)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(port)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(keyList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestReceiveApplication)
    }

    // nn::Result CommitReceiveApplication(nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CommitReceiveApplication, (::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CommitReceiveApplication)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CommitReceiveApplication)
    }

    // nn::Result GetReceiveApplicationProgress(nn::sf::Out<nn::ns::ReceiveApplicationProgress> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReceiveApplicationProgress, (::nn::sf::Out<::nn::ns::ReceiveApplicationProgress> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetReceiveApplicationProgress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetReceiveApplicationProgress)
    }

    // nn::Result RequestSendApplication(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, std::uint32_t ipv4, std::uint16_t port, const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestSendApplication, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestSendApplication)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ipv4)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(port)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(keyList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestSendApplication)
    }

    // nn::Result GetSendApplicationProgress(nn::sf::Out<nn::ns::SendApplicationProgress> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSendApplicationProgress, (::nn::sf::Out<::nn::ns::SendApplicationProgress> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSendApplicationProgress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSendApplicationProgress)
    }

    // nn::Result CompareSystemDeliveryInfo(nn::sf::Out<std::int32_t> outValue, const nn::ns::SystemDeliveryInfo& lhs, const nn::ns::SystemDeliveryInfo& rhs) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CompareSystemDeliveryInfo, (::nn::sf::Out<::std::int32_t> outValue, const ::nn::ns::SystemDeliveryInfo& lhs, const ::nn::ns::SystemDeliveryInfo& rhs))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CompareSystemDeliveryInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(lhs)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rhs)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CompareSystemDeliveryInfo)
    }

    // nn::Result ListNotCommittedContentMeta(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ncm::ContentMetaKey>& outList, nn::ncm::ApplicationId id, std::int32_t offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListNotCommittedContentMeta, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ncm::ContentMetaKey>& outList, ::nn::ncm::ApplicationId id, ::std::int32_t offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListNotCommittedContentMeta)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListNotCommittedContentMeta)
    }

    // nn::Result CreateDownloadTask(const nn::sf::InArray<nn::ncm::ContentMetaKey>& keyList, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateDownloadTask, (const ::nn::sf::InArray<::nn::ncm::ContentMetaKey>& keyList, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateDownloadTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(keyList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateDownloadTask)
    }

    // nn::Result GetApplicationDeliveryInfoHash(nn::sf::Out<nn::ns::ApplicationDeliveryInfoHash> outValue, const nn::sf::InArray<nn::ns::ApplicationDeliveryInfo>& infoList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationDeliveryInfoHash, (::nn::sf::Out<::nn::ns::ApplicationDeliveryInfoHash> outValue, const ::nn::sf::InArray<::nn::ns::ApplicationDeliveryInfo>& infoList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetApplicationDeliveryInfoHash)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(infoList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetApplicationDeliveryInfoHash)
    }

    // nn::Result GetApplicationRightsOnClient(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationRightsOnClient>& outList, nn::ncm::ApplicationId appId, const nn::account::Uid& uid, nn::ns::ApplicationRightsOnClientQueryFlag flags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationRightsOnClient, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationRightsOnClient>& outList, ::nn::ncm::ApplicationId appId, const ::nn::account::Uid& uid, ::nn::ns::ApplicationRightsOnClientQueryFlag flags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetApplicationRightsOnClient)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetApplicationRightsOnClient)
    }

    // nn::Result GetApplicationTerminateResult(nn::sf::Out<std::uint32_t> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationTerminateResult, (::nn::sf::Out<::std::uint32_t> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetApplicationTerminateResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetApplicationTerminateResult)
    }

    // nn::Result GetRawApplicationTerminateResult(nn::sf::Out<std::uint32_t> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRawApplicationTerminateResult, (::nn::sf::Out<::std::uint32_t> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRawApplicationTerminateResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRawApplicationTerminateResult)
    }

    // nn::Result CreateRightsEnvironment(nn::sf::Out<nn::ns::RightsEnvironmentHandle> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateRightsEnvironment, (::nn::sf::Out<::nn::ns::RightsEnvironmentHandle> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateRightsEnvironment)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateRightsEnvironment)
    }

    // nn::Result DestroyRightsEnvironment(nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DestroyRightsEnvironment, (::nn::ns::RightsEnvironmentHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroyRightsEnvironment)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroyRightsEnvironment)
    }

    // nn::Result ActivateRightsEnvironment(nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ActivateRightsEnvironment, (::nn::ns::RightsEnvironmentHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ActivateRightsEnvironment)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ActivateRightsEnvironment)
    }

    // nn::Result DeactivateRightsEnvironment(nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeactivateRightsEnvironment, (::nn::ns::RightsEnvironmentHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeactivateRightsEnvironment)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeactivateRightsEnvironment)
    }

    // nn::Result AddTargetApplicationToRightsEnvironment(nn::ns::RightsEnvironmentHandle handle, nn::ncm::ApplicationId applicationId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddTargetApplicationToRightsEnvironment, (::nn::ns::RightsEnvironmentHandle handle, ::nn::ncm::ApplicationId applicationId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AddTargetApplicationToRightsEnvironment)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(applicationId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AddTargetApplicationToRightsEnvironment)
    }

    // nn::Result SetUsersToRightsEnvironment(nn::ns::RightsEnvironmentHandle handle, bool anyUser, const nn::sf::InArray<nn::account::Uid>& uids) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetUsersToRightsEnvironment, (::nn::ns::RightsEnvironmentHandle handle, bool anyUser, const ::nn::sf::InArray<::nn::account::Uid>& uids))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetUsersToRightsEnvironment)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(anyUser)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uids)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetUsersToRightsEnvironment)
    }

    // nn::Result GetRightsEnvironmentStatus(nn::sf::Out<nn::ns::RightsEnvironmentStatus> pOut, nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRightsEnvironmentStatus, (::nn::sf::Out<::nn::ns::RightsEnvironmentStatus> pOut, ::nn::ns::RightsEnvironmentHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRightsEnvironmentStatus)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRightsEnvironmentStatus)
    }

    // nn::Result GetGameCardApplicationCopyIdentifier(nn::sf::Out<nn::ns::GameCardApplicationCopyIdentifier> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGameCardApplicationCopyIdentifier, (::nn::sf::Out<::nn::ns::GameCardApplicationCopyIdentifier> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGameCardApplicationCopyIdentifier)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGameCardApplicationCopyIdentifier)
    }

    // nn::Result GetInstalledApplicationCopyIdentifier(nn::sf::Out<nn::ns::InstalledApplicationCopyIdentifier> outValue, nn::ncm::ApplicationId id, nn::ncm::StorageId storage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetInstalledApplicationCopyIdentifier, (::nn::sf::Out<::nn::ns::InstalledApplicationCopyIdentifier> outValue, ::nn::ncm::ApplicationId id, ::nn::ncm::StorageId storage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetInstalledApplicationCopyIdentifier)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetInstalledApplicationCopyIdentifier)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ns::detail::IApplicationManagerInterface>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ns::detail::IApplicationManagerInterface))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListApplicationRecord)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListApplicationRecord)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GenerateApplicationRecordCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GenerateApplicationRecordCount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetApplicationRecordUpdateSystemEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetApplicationRecordUpdateSystemEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetApplicationViewDeprecated)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(idList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetApplicationViewDeprecated)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(idList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteApplicationEntity)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteApplicationEntity)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteApplicationCompletely)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteApplicationCompletely)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsAnyApplicationEntityRedundant)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsAnyApplicationEntityRedundant)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteRedundantApplicationEntity)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteRedundantApplicationEntity)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsApplicationEntityMovable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsApplicationEntityMovable)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(MoveApplicationEntity)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(MoveApplicationEntity)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CalculateApplicationOccupiedSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CalculateApplicationOccupiedSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PushApplicationRecord)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(keyList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PushApplicationRecord)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appEvent),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(keyList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListApplicationRecordContentMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListApplicationRecordContentMeta)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetApplicationContentPath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetApplicationContentPath)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TerminateApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TerminateApplication)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResolveApplicationContentPath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResolveApplicationContentPath)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BeginInstallApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BeginInstallApplication)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(version),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteApplicationRecord)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteApplicationRecord)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestApplicationUpdateInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestApplicationUpdateInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelApplicationDownload)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelApplicationDownload)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResumeApplicationDownload)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResumeApplicationDownload)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UpdateVersionList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UpdateVersionList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PushLaunchVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PushLaunchVersion)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(version)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListRequiredVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(requiredVersionEntries)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListRequiredVersion)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(requiredVersionEntries)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CheckApplicationLaunchVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CheckApplicationLaunchVersion)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CheckApplicationLaunchRights)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CheckApplicationLaunchRights)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetApplicationLogoData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(logoPath)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetApplicationLogoData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(logoPath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CalculateApplicationDownloadRequiredSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CalculateApplicationDownloadRequiredSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outStorage),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CleanupSdCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CleanupSdCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CheckSdCardMountStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CheckSdCardMountStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSdCardMountStatusChangedEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSdCardMountStatusChangedEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGameCardAttachmentEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGameCardAttachmentEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGameCardAttachmentInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGameCardAttachmentInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetTotalSpaceSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetTotalSpaceSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFreeSpaceSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFreeSpaceSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSdCardRemovedEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSdCardRemovedEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGameCardUpdateDetectionEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGameCardUpdateDetectionEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DisableApplicationAutoDelete)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DisableApplicationAutoDelete)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableApplicationAutoDelete)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableApplicationAutoDelete)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetApplicationTerminateResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetApplicationTerminateResult)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(result)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ClearApplicationTerminateResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ClearApplicationTerminateResult)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLastSdCardMountUnexpectedResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLastSdCardMountUnexpectedResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBackgroundDownloadStressTaskInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBackgroundDownloadStressTaskInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGameCardStopper)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IGameCardStopper>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGameCardStopper)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsSystemProgramInstalled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsSystemProgramInstalled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartApplyDeltaTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartApplyDeltaTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRequestServerStopper)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IRequestServerStopper>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRequestServerStopper)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBackgroundApplyDeltaStressTaskInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBackgroundApplyDeltaStressTaskInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelApplicationApplyDelta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelApplicationApplyDelta)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResumeApplicationApplyDelta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResumeApplicationApplyDelta)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CalculateApplicationApplyDeltaRequiredSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CalculateApplicationApplyDeltaRequiredSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outStorage),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResumeAll)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResumeAll)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetStorageSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetStorageSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outTotalSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outFreeSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestDownloadApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestDownloadApplication)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(forceDirectUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestDownloadAddOnContent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(keyList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestDownloadAddOnContent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(keyList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DownloadApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DownloadApplication)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(forceDirectUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CheckApplicationResumeRights)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CheckApplicationResumeRights)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDynamicCommitEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDynamicCommitEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestUpdateApplication2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestUpdateApplication2)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableApplicationCrashReport)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableApplicationCrashReport)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isEnable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsApplicationCrashReportEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsApplicationCrashReportEnabled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(BoostSystemMemoryResourceLimit)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(BoostSystemMemoryResourceLimit)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(boostSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeprecatedLaunchApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeprecatedLaunchApplication)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(programIndex)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRunningApplicationProgramId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRunningApplicationProgramId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetMainApplicationProgramIndex)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetMainApplicationProgramIndex)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LaunchApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LaunchApplication)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(info),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(programIndex)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetApplicationLaunchInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetApplicationLaunchInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AcquireApplicationLaunchInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AcquireApplicationLaunchInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetMainApplicationProgramIndexByApplicationLaunchInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetMainApplicationProgramIndexByApplicationLaunchInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(info)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableApplicationAllThreadDumpOnCrash)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableApplicationAllThreadDumpOnCrash)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResetToFactorySettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResetToFactorySettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResetToFactorySettingsWithoutUserSaveData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResetToFactorySettingsWithoutUserSaveData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResetToFactorySettingsForRefurbishment)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResetToFactorySettingsForRefurbishment)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CalculateUserSaveDataStatistics)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CalculateUserSaveDataStatistics)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteUserSaveDataAll)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IProgressMonitorForDeleteUserSaveDataAll>), pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteUserSaveDataAll)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(pOut, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteUserSystemSaveData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteUserSystemSaveData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(sysSaveId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnregisterNetworkServiceAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnregisterNetworkServiceAccount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnregisterNetworkServiceAccountWithUserSaveDataDeletion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnregisterNetworkServiceAccountWithUserSaveDataDeletion)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetApplicationShellEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetApplicationShellEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PopApplicationShellEventInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PopApplicationShellEventInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LaunchLibraryApplet)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LaunchLibraryApplet)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TerminateLibraryApplet)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TerminateLibraryApplet)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LaunchSystemApplet)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LaunchSystemApplet)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TerminateSystemApplet)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TerminateSystemApplet)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LaunchOverlayApplet)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LaunchOverlayApplet)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TerminateOverlayApplet)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TerminateOverlayApplet)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(InvalidateAllApplicationControlCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(InvalidateAllApplicationControlCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestDownloadApplicationControlData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestDownloadApplicationControlData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetMaxApplicationControlCacheCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetMaxApplicationControlCacheCount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(InvalidateApplicationControlCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(InvalidateApplicationControlCache)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListApplicationControlCacheEntryInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListApplicationControlCacheEntryInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetApplicationControlProperty)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetApplicationControlProperty)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(info),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(programIndex)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestCheckGameCardRegistration)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestCheckGameCardRegistration)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestGameCardRegistrationGoldPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestGameCardRegistrationGoldPoint)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestRegisterGameCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestRegisterGameCard)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(goldPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGameCardMountFailureEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGameCardMountFailureEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsGameCardInserted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsGameCardInserted)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnsureGameCardAccess)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnsureGameCardAccess)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLastGameCardMountFailureResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLastGameCardMountFailureResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListApplicationIdOnGameCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListApplicationIdOnGameCard)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CountApplicationContentMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CountApplicationContentMeta)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListApplicationContentMetaStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListApplicationContentMetaStatus)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListAvailableAddOnContent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListAvailableAddOnContent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetOwnedApplicationContentMetaStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetOwnedApplicationContentMetaStatus)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(contentMetaId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterContentsExternalKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterContentsExternalKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(contentMetaId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListApplicationContentMetaStatusWithRightsCheck)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListApplicationContentMetaStatusWithRightsCheck)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetContentMetaStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetContentMetaStorage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(key)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PushDownloadTaskList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PushDownloadTaskList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ClearTaskStatusList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ClearTaskStatusList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestDownloadTaskList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestDownloadTaskList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestEnsureDownloadTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestEnsureDownloadTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListDownloadTaskStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListDownloadTaskStatus)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestDownloadTaskListData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestDownloadTaskListData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestVersionList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestVersionList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListVersionList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(versionListEntries)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListVersionList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(versionListEntries)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestVersionListData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestVersionListData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetApplicationRecord)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetApplicationRecord)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetApplicationRecordProperty)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetApplicationRecordProperty)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableApplicationAutoUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableApplicationAutoUpdate)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DisableApplicationAutoUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DisableApplicationAutoUpdate)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TouchApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TouchApplication)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestApplicationUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestApplicationUpdate)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(resultInnerValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsApplicationUpdateRequested)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsApplicationUpdateRequested)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(resultInnerValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(WithdrawApplicationUpdateRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(WithdrawApplicationUpdateRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListApplicationRecordInstalledContentMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListApplicationRecordInstalledContentMeta)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(WithdrawCleanupAddOnContentsWithNoRightsRecommendation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(WithdrawCleanupAddOnContentsWithNoRightsRecommendation)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HasApplicationRecord)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HasApplicationRecord)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetPreInstalledApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetPreInstalledApplication)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ClearPreInstalledApplicationFlag)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ClearPreInstalledApplicationFlag)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestVerifyApplicationDeprecated)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(transferHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IProgressAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestVerifyApplicationDeprecated)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(transferHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(transferSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CorruptApplicationForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CorruptApplicationForDebug)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flags),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestVerifyAddOnContentsRights)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IProgressAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestVerifyAddOnContentsRights)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestVerifyApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(transferHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IProgressAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestVerifyApplication)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flags),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(transferHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(transferSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CorruptContentForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CorruptContentForDebug)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(key),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(NeedsUpdateVulnerability)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(NeedsUpdateVulnerability)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsAnyApplicationEntityInstalled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsAnyApplicationEntityInstalled)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteApplicationContentEntities)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteApplicationContentEntities)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(innerValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CleanupUnrecordedApplicationEntity)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CleanupUnrecordedApplicationEntity)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CleanupAddOnContentsWithNoRights)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CleanupAddOnContentsWithNoRights)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteApplicationContentEntity)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteApplicationContentEntity)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(key)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteApplicationCompletelyForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteApplicationCompletelyForDebug)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(innerValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PrepareShutdown)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PrepareShutdown)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(FormatSdCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(FormatSdCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(NeedsSystemUpdateToFormatSdCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(NeedsSystemUpdateToFormatSdCard)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLastSdCardFormatUnexpectedResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLastSdCardFormatUnexpectedResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(InsertSdCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(InsertSdCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RemoveSdCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RemoveSdCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSystemSeedForPseudoDeviceId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSystemSeedForPseudoDeviceId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSeed)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResetSystemSeedForPseudoDeviceId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResetSystemSeedForPseudoDeviceId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListApplicationDownloadingContentMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_CHECK_PRE(NN_SF_DETAIL_APPLY_LAMBDA(_, (_ >= 0), NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)))
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListApplicationDownloadingContentMeta)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetApplicationView)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(idList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetApplicationView)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(idList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetApplicationDownloadTaskStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetApplicationDownloadTaskStatus)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetApplicationViewDownloadErrorContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetApplicationViewDownloadErrorContext)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsNotificationSetupCompleted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsNotificationSetupCompleted)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLastNotificationInfoCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLastNotificationInfoCount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListLastNotificationInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListLastNotificationInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListNotificationTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListNotificationTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsActiveAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsActiveAccount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accountId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestDownloadApplicationPrepurchasedRights)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestDownloadApplicationPrepurchasedRights)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetApplicationTicketInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetApplicationTicketInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSystemDeliveryInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSystemDeliveryInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SelectLatestSystemDeliveryInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(receiverSystemInfo)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(list)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(receiverAppInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SelectLatestSystemDeliveryInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(list),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(receiverSystemInfo),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(receiverAppInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(VerifyDeliveryProtocolVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(info)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(VerifyDeliveryProtocolVersion)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(info)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetApplicationDeliveryInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetApplicationDeliveryInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(attributes)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HasAllContentsToDeliver)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(appInfoList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HasAllContentsToDeliver)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(appInfoList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CompareApplicationDeliveryInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(lhs)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(rhs)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CompareApplicationDeliveryInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(lhs),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(rhs)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CanDeliverApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(receiverInfoList)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(senderInfoList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CanDeliverApplication)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(receiverInfoList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(senderInfoList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListContentMetaKeyToDeliverApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(infoList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListContentMetaKeyToDeliverApplication)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(infoList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(NeedsSystemUpdateToDeliverApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(systemInfo)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(applicationInfoList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(NeedsSystemUpdateToDeliverApplication)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(applicationInfoList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(systemInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EstimateRequiredSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(keyList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EstimateRequiredSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(keyList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestReceiveApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(keyList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestReceiveApplication)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ipv4),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(port),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(keyList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CommitReceiveApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CommitReceiveApplication)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetReceiveApplicationProgress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetReceiveApplicationProgress)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestSendApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(keyList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestSendApplication)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ipv4),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(port),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(keyList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSendApplicationProgress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSendApplicationProgress)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CompareSystemDeliveryInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(lhs)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(rhs)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CompareSystemDeliveryInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(lhs),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(rhs)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListNotCommittedContentMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListNotCommittedContentMeta)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateDownloadTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(keyList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateDownloadTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(keyList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetApplicationDeliveryInfoHash)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(infoList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetApplicationDeliveryInfoHash)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(infoList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetApplicationRightsOnClient)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetApplicationRightsOnClient)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetApplicationTerminateResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetApplicationTerminateResult)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRawApplicationTerminateResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRawApplicationTerminateResult)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateRightsEnvironment)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateRightsEnvironment)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroyRightsEnvironment)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroyRightsEnvironment)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ActivateRightsEnvironment)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ActivateRightsEnvironment)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeactivateRightsEnvironment)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeactivateRightsEnvironment)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AddTargetApplicationToRightsEnvironment)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AddTargetApplicationToRightsEnvironment)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(applicationId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetUsersToRightsEnvironment)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(uids)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetUsersToRightsEnvironment)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(anyUser),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(uids)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRightsEnvironmentStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRightsEnvironmentStatus)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGameCardApplicationCopyIdentifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGameCardApplicationCopyIdentifier)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetInstalledApplicationCopyIdentifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetInstalledApplicationCopyIdentifier)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListApplicationRecord)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GenerateApplicationRecordCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetApplicationRecordUpdateSystemEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetApplicationViewDeprecated)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteApplicationEntity)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteApplicationCompletely)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsAnyApplicationEntityRedundant)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteRedundantApplicationEntity)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsApplicationEntityMovable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(MoveApplicationEntity)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CalculateApplicationOccupiedSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PushApplicationRecord)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListApplicationRecordContentMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetApplicationContentPath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TerminateApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResolveApplicationContentPath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BeginInstallApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteApplicationRecord)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestApplicationUpdateInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelApplicationDownload)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResumeApplicationDownload)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UpdateVersionList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PushLaunchVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListRequiredVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CheckApplicationLaunchVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CheckApplicationLaunchRights)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetApplicationLogoData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CalculateApplicationDownloadRequiredSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CleanupSdCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CheckSdCardMountStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSdCardMountStatusChangedEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGameCardAttachmentEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGameCardAttachmentInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetTotalSpaceSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFreeSpaceSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSdCardRemovedEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGameCardUpdateDetectionEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DisableApplicationAutoDelete)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableApplicationAutoDelete)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetApplicationTerminateResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ClearApplicationTerminateResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLastSdCardMountUnexpectedResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBackgroundDownloadStressTaskInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGameCardStopper)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsSystemProgramInstalled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartApplyDeltaTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRequestServerStopper)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBackgroundApplyDeltaStressTaskInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelApplicationApplyDelta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResumeApplicationApplyDelta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CalculateApplicationApplyDeltaRequiredSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResumeAll)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetStorageSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestDownloadApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestDownloadAddOnContent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DownloadApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CheckApplicationResumeRights)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDynamicCommitEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestUpdateApplication2)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableApplicationCrashReport)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsApplicationCrashReportEnabled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(BoostSystemMemoryResourceLimit)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeprecatedLaunchApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRunningApplicationProgramId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetMainApplicationProgramIndex)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LaunchApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetApplicationLaunchInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AcquireApplicationLaunchInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetMainApplicationProgramIndexByApplicationLaunchInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableApplicationAllThreadDumpOnCrash)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResetToFactorySettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResetToFactorySettingsWithoutUserSaveData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResetToFactorySettingsForRefurbishment)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CalculateUserSaveDataStatistics)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteUserSaveDataAll)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteUserSystemSaveData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnregisterNetworkServiceAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnregisterNetworkServiceAccountWithUserSaveDataDeletion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetApplicationShellEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PopApplicationShellEventInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LaunchLibraryApplet)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TerminateLibraryApplet)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LaunchSystemApplet)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TerminateSystemApplet)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LaunchOverlayApplet)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TerminateOverlayApplet)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(InvalidateAllApplicationControlCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestDownloadApplicationControlData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetMaxApplicationControlCacheCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(InvalidateApplicationControlCache)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListApplicationControlCacheEntryInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetApplicationControlProperty)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestCheckGameCardRegistration)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestGameCardRegistrationGoldPoint)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestRegisterGameCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGameCardMountFailureEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsGameCardInserted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnsureGameCardAccess)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLastGameCardMountFailureResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListApplicationIdOnGameCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CountApplicationContentMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListApplicationContentMetaStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListAvailableAddOnContent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetOwnedApplicationContentMetaStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterContentsExternalKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListApplicationContentMetaStatusWithRightsCheck)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetContentMetaStorage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PushDownloadTaskList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ClearTaskStatusList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestDownloadTaskList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestEnsureDownloadTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListDownloadTaskStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestDownloadTaskListData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestVersionList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListVersionList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestVersionListData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetApplicationRecord)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetApplicationRecordProperty)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableApplicationAutoUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DisableApplicationAutoUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TouchApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestApplicationUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsApplicationUpdateRequested)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(WithdrawApplicationUpdateRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListApplicationRecordInstalledContentMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(WithdrawCleanupAddOnContentsWithNoRightsRecommendation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HasApplicationRecord)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetPreInstalledApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ClearPreInstalledApplicationFlag)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestVerifyApplicationDeprecated)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CorruptApplicationForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestVerifyAddOnContentsRights)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestVerifyApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CorruptContentForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(NeedsUpdateVulnerability)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsAnyApplicationEntityInstalled)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteApplicationContentEntities)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CleanupUnrecordedApplicationEntity)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CleanupAddOnContentsWithNoRights)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteApplicationContentEntity)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteApplicationCompletelyForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PrepareShutdown)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(FormatSdCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(NeedsSystemUpdateToFormatSdCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLastSdCardFormatUnexpectedResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(InsertSdCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RemoveSdCard)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSystemSeedForPseudoDeviceId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResetSystemSeedForPseudoDeviceId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListApplicationDownloadingContentMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetApplicationView)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetApplicationDownloadTaskStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetApplicationViewDownloadErrorContext)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsNotificationSetupCompleted)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLastNotificationInfoCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListLastNotificationInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListNotificationTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsActiveAccount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestDownloadApplicationPrepurchasedRights)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetApplicationTicketInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSystemDeliveryInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SelectLatestSystemDeliveryInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(VerifyDeliveryProtocolVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetApplicationDeliveryInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HasAllContentsToDeliver)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CompareApplicationDeliveryInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CanDeliverApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListContentMetaKeyToDeliverApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(NeedsSystemUpdateToDeliverApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EstimateRequiredSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestReceiveApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CommitReceiveApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetReceiveApplicationProgress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestSendApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSendApplicationProgress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CompareSystemDeliveryInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListNotCommittedContentMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateDownloadTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetApplicationDeliveryInfoHash)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetApplicationRightsOnClient)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetApplicationTerminateResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRawApplicationTerminateResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateRightsEnvironment)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroyRightsEnvironment)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ActivateRightsEnvironment)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeactivateRightsEnvironment)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AddTargetApplicationToRightsEnvironment)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetUsersToRightsEnvironment)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRightsEnvironmentStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGameCardApplicationCopyIdentifier)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetInstalledApplicationCopyIdentifier)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ns::detail::IApplicationManagerInterface))

namespace nn { namespace ns { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IApplicationVersionInterface, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IApplicationVersionInterface)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetLaunchRequiredVersion, (::nn::sf::Out<::std::uint32_t> outValue, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UpgradeLaunchRequiredVersion, (::nn::ncm::ApplicationId id, ::std::uint32_t launchRequiredVersion))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(UpdateVersionList, (const ::nn::sf::InBuffer& buffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PushLaunchVersion, (::nn::ncm::ApplicationId id, ::std::uint32_t version))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListRequiredVersion, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::RequiredVersionEntry>& requiredVersionEntries))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(RequestVersionList)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListVersionList, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::VersionListEntry>& versionListEntries))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestVersionListData, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(PerformAutoUpdate)
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IApplicationVersionInterface)

        ::nn::Result GetLaunchRequiredVersion(::nn::sf::Out<::std::uint32_t> outValue, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetLaunchRequiredVersion, (outValue, id));
        }

        ::nn::Result UpgradeLaunchRequiredVersion(::nn::ncm::ApplicationId id, ::std::uint32_t launchRequiredVersion) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UpgradeLaunchRequiredVersion, (id, launchRequiredVersion));
        }

        ::nn::Result UpdateVersionList(const ::nn::sf::InBuffer& buffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(UpdateVersionList, (buffer));
        }

        ::nn::Result PushLaunchVersion(::nn::ncm::ApplicationId id, ::std::uint32_t version) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PushLaunchVersion, (id, version));
        }

        ::nn::Result ListRequiredVersion(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::RequiredVersionEntry>& requiredVersionEntries) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListRequiredVersion, (outCount, requiredVersionEntries));
        }

        ::nn::Result RequestVersionList() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(RequestVersionList);
        }

        ::nn::Result ListVersionList(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::VersionListEntry>& versionListEntries) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListVersionList, (outCount, versionListEntries));
        }

        ::nn::Result RequestVersionListData(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestVersionListData, (outHandle, outAsync));
        }

        ::nn::Result PerformAutoUpdate() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(PerformAutoUpdate);
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IApplicationVersionInterface
    {
    public:
        nn::Result GetLaunchRequiredVersion(nn::sf::Out<std::uint32_t> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result UpgradeLaunchRequiredVersion(nn::ncm::ApplicationId id, std::uint32_t launchRequiredVersion) NN_NOEXCEPT;
        nn::Result UpdateVersionList(const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
        nn::Result PushLaunchVersion(nn::ncm::ApplicationId id, std::uint32_t version) NN_NOEXCEPT;
        nn::Result ListRequiredVersion(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::RequiredVersionEntry>& requiredVersionEntries) NN_NOEXCEPT;
        nn::Result RequestVersionList() NN_NOEXCEPT;
        nn::Result ListVersionList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::VersionListEntry>& versionListEntries) NN_NOEXCEPT;
        nn::Result RequestVersionListData(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync) NN_NOEXCEPT;
        nn::Result PerformAutoUpdate() NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetLaunchRequiredVersion(nn::sf::Out<std::uint32_t> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result UpgradeLaunchRequiredVersion(nn::ncm::ApplicationId id, std::uint32_t launchRequiredVersion) NN_NOEXCEPT;
    nn::Result UpdateVersionList(const nn::sf::InBuffer& buffer) NN_NOEXCEPT;
    nn::Result PushLaunchVersion(nn::ncm::ApplicationId id, std::uint32_t version) NN_NOEXCEPT;
    nn::Result ListRequiredVersion(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::RequiredVersionEntry>& requiredVersionEntries) NN_NOEXCEPT;
    nn::Result RequestVersionList() NN_NOEXCEPT;
    nn::Result ListVersionList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::VersionListEntry>& versionListEntries) NN_NOEXCEPT;
    nn::Result RequestVersionListData(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync) NN_NOEXCEPT;
    nn::Result PerformAutoUpdate() NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ns::detail::IApplicationVersionInterface))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLaunchRequiredVersion, (::nn::sf::Out<::std::uint32_t> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetLaunchRequiredVersion, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpgradeLaunchRequiredVersion, (::nn::ncm::ApplicationId id, ::std::uint32_t launchRequiredVersion))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UpgradeLaunchRequiredVersion, (id, launchRequiredVersion));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpdateVersionList, (const ::nn::sf::InBuffer& buffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(UpdateVersionList, (buffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PushLaunchVersion, (::nn::ncm::ApplicationId id, ::std::uint32_t version))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PushLaunchVersion, (id, version));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListRequiredVersion, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::RequiredVersionEntry>& requiredVersionEntries))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListRequiredVersion, (outCount, requiredVersionEntries));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RequestVersionList)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(RequestVersionList);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListVersionList, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::VersionListEntry>& versionListEntries))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListVersionList, (outCount, versionListEntries));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestVersionListData, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestVersionListData, (outHandle, outAsync));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(PerformAutoUpdate)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(PerformAutoUpdate);
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ns::detail::IApplicationVersionInterface>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ns::detail::IApplicationVersionInterface))

    // nn::Result GetLaunchRequiredVersion(nn::sf::Out<std::uint32_t> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetLaunchRequiredVersion)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetLaunchRequiredVersion)

    // nn::Result UpgradeLaunchRequiredVersion(nn::ncm::ApplicationId id, std::uint32_t launchRequiredVersion) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UpgradeLaunchRequiredVersion)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(launchRequiredVersion, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (launchRequiredVersion, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(launchRequiredVersion)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UpgradeLaunchRequiredVersion)

    // nn::Result UpdateVersionList(const nn::sf::InBuffer& buffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UpdateVersionList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(35)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UpdateVersionList)

    // nn::Result PushLaunchVersion(nn::ncm::ApplicationId id, std::uint32_t version) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PushLaunchVersion)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(36)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(version, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (version, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(version)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PushLaunchVersion)

    // nn::Result ListRequiredVersion(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::RequiredVersionEntry>& requiredVersionEntries) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListRequiredVersion)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(37)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(requiredVersionEntries, 0, (const ::nn::sf::OutArray<::nn::ns::RequiredVersionEntry>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (requiredVersionEntries))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(requiredVersionEntries)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListRequiredVersion)

    // nn::Result RequestVersionList() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestVersionList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(800)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestVersionList)

    // nn::Result ListVersionList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::VersionListEntry>& versionListEntries) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListVersionList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(801)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(versionListEntries, 0, (const ::nn::sf::OutArray<::nn::ns::VersionListEntry>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (versionListEntries))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(versionListEntries)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListVersionList)

    // nn::Result RequestVersionListData(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestVersionListData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(802)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestVersionListData)

    // nn::Result PerformAutoUpdate() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PerformAutoUpdate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1000)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PerformAutoUpdate)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ApplicationId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::RequiredVersionEntry), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::VersionListEntry), 16, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ns::detail::IApplicationVersionInterface, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ns::detail::IApplicationVersionInterface))

    // nn::Result GetLaunchRequiredVersion(nn::sf::Out<std::uint32_t> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetLaunchRequiredVersion, (::nn::sf::Out<::std::uint32_t> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetLaunchRequiredVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetLaunchRequiredVersion)
    }

    // nn::Result UpgradeLaunchRequiredVersion(nn::ncm::ApplicationId id, std::uint32_t launchRequiredVersion) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpgradeLaunchRequiredVersion, (::nn::ncm::ApplicationId id, ::std::uint32_t launchRequiredVersion))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UpgradeLaunchRequiredVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(launchRequiredVersion)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UpgradeLaunchRequiredVersion)
    }

    // nn::Result UpdateVersionList(const nn::sf::InBuffer& buffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(UpdateVersionList, (const ::nn::sf::InBuffer& buffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UpdateVersionList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UpdateVersionList)
    }

    // nn::Result PushLaunchVersion(nn::ncm::ApplicationId id, std::uint32_t version) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PushLaunchVersion, (::nn::ncm::ApplicationId id, ::std::uint32_t version))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PushLaunchVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(version)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PushLaunchVersion)
    }

    // nn::Result ListRequiredVersion(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::RequiredVersionEntry>& requiredVersionEntries) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListRequiredVersion, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::RequiredVersionEntry>& requiredVersionEntries))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListRequiredVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(requiredVersionEntries)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListRequiredVersion)
    }

    // nn::Result RequestVersionList() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RequestVersionList)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestVersionList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestVersionList)
    }

    // nn::Result ListVersionList(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::VersionListEntry>& versionListEntries) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListVersionList, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::VersionListEntry>& versionListEntries))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListVersionList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(versionListEntries)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListVersionList)
    }

    // nn::Result RequestVersionListData(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestVersionListData, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestVersionListData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestVersionListData)
    }

    // nn::Result PerformAutoUpdate() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(PerformAutoUpdate)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PerformAutoUpdate)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PerformAutoUpdate)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ns::detail::IApplicationVersionInterface>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ns::detail::IApplicationVersionInterface))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetLaunchRequiredVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetLaunchRequiredVersion)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UpgradeLaunchRequiredVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UpgradeLaunchRequiredVersion)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(launchRequiredVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UpdateVersionList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UpdateVersionList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PushLaunchVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PushLaunchVersion)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(version)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListRequiredVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(requiredVersionEntries)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListRequiredVersion)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(requiredVersionEntries)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestVersionList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestVersionList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListVersionList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(versionListEntries)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListVersionList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(versionListEntries)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestVersionListData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestVersionListData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PerformAutoUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PerformAutoUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetLaunchRequiredVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UpgradeLaunchRequiredVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UpdateVersionList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PushLaunchVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListRequiredVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestVersionList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListVersionList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestVersionListData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PerformAutoUpdate)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ns::detail::IApplicationVersionInterface))

namespace nn { namespace ns { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IContentManagementInterface, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IContentManagementInterface)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CalculateApplicationOccupiedSize, (::nn::sf::Out<::nn::ns::ApplicationOccupiedSize> outValue, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CheckSdCardMountStatus)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetTotalSpaceSize, (::nn::sf::Out<::std::int64_t> outSize, ::nn::ncm::StorageId storage))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFreeSpaceSize, (::nn::sf::Out<::std::int64_t> outSize, ::nn::ncm::StorageId storage))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CountApplicationContentMeta, (::nn::sf::Out<::std::int32_t> outValue, ::nn::ncm::ApplicationId appId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationContentMetaStatus, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationContentMetaStatus>& outList, ::nn::ncm::ApplicationId appId, ::std::int32_t offset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationContentMetaStatusWithRightsCheck, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationContentMetaStatus>& outList, ::nn::ncm::ApplicationId appId, ::std::int32_t offset))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VALUE_0(IsAnyApplicationRunning, (bool))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IContentManagementInterface)

        ::nn::Result CalculateApplicationOccupiedSize(::nn::sf::Out<::nn::ns::ApplicationOccupiedSize> outValue, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CalculateApplicationOccupiedSize, (outValue, id));
        }

        ::nn::Result CheckSdCardMountStatus() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CheckSdCardMountStatus);
        }

        ::nn::Result GetTotalSpaceSize(::nn::sf::Out<::std::int64_t> outSize, ::nn::ncm::StorageId storage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetTotalSpaceSize, (outSize, storage));
        }

        ::nn::Result GetFreeSpaceSize(::nn::sf::Out<::std::int64_t> outSize, ::nn::ncm::StorageId storage) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFreeSpaceSize, (outSize, storage));
        }

        ::nn::Result CountApplicationContentMeta(::nn::sf::Out<::std::int32_t> outValue, ::nn::ncm::ApplicationId appId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CountApplicationContentMeta, (outValue, appId));
        }

        ::nn::Result ListApplicationContentMetaStatus(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationContentMetaStatus>& outList, ::nn::ncm::ApplicationId appId, ::std::int32_t offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListApplicationContentMetaStatus, (outCount, outList, appId, offset));
        }

        ::nn::Result ListApplicationContentMetaStatusWithRightsCheck(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationContentMetaStatus>& outList, ::nn::ncm::ApplicationId appId, ::std::int32_t offset) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListApplicationContentMetaStatusWithRightsCheck, (outCount, outList, appId, offset));
        }

        bool IsAnyApplicationRunning() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VALUE_0(IsAnyApplicationRunning, (bool));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IContentManagementInterface
    {
    public:
        nn::Result CalculateApplicationOccupiedSize(nn::sf::Out<nn::ns::ApplicationOccupiedSize> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result CheckSdCardMountStatus() NN_NOEXCEPT;
        nn::Result GetTotalSpaceSize(nn::sf::Out<std::int64_t> outSize, nn::ncm::StorageId storage) NN_NOEXCEPT;
        nn::Result GetFreeSpaceSize(nn::sf::Out<std::int64_t> outSize, nn::ncm::StorageId storage) NN_NOEXCEPT;
        nn::Result CountApplicationContentMeta(nn::sf::Out<std::int32_t> outValue, nn::ncm::ApplicationId appId) NN_NOEXCEPT;
        nn::Result ListApplicationContentMetaStatus(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationContentMetaStatus>& outList, nn::ncm::ApplicationId appId, std::int32_t offset) NN_NOEXCEPT;
        nn::Result ListApplicationContentMetaStatusWithRightsCheck(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationContentMetaStatus>& outList, nn::ncm::ApplicationId appId, std::int32_t offset) NN_NOEXCEPT;
        bool IsAnyApplicationRunning() NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CalculateApplicationOccupiedSize(nn::sf::Out<nn::ns::ApplicationOccupiedSize> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result CheckSdCardMountStatus() NN_NOEXCEPT;
    nn::Result GetTotalSpaceSize(nn::sf::Out<std::int64_t> outSize, nn::ncm::StorageId storage) NN_NOEXCEPT;
    nn::Result GetFreeSpaceSize(nn::sf::Out<std::int64_t> outSize, nn::ncm::StorageId storage) NN_NOEXCEPT;
    nn::Result CountApplicationContentMeta(nn::sf::Out<std::int32_t> outValue, nn::ncm::ApplicationId appId) NN_NOEXCEPT;
    nn::Result ListApplicationContentMetaStatus(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationContentMetaStatus>& outList, nn::ncm::ApplicationId appId, std::int32_t offset) NN_NOEXCEPT;
    nn::Result ListApplicationContentMetaStatusWithRightsCheck(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationContentMetaStatus>& outList, nn::ncm::ApplicationId appId, std::int32_t offset) NN_NOEXCEPT;
    bool IsAnyApplicationRunning() NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ns::detail::IContentManagementInterface))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CalculateApplicationOccupiedSize, (::nn::sf::Out<::nn::ns::ApplicationOccupiedSize> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CalculateApplicationOccupiedSize, (outValue, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CheckSdCardMountStatus)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CheckSdCardMountStatus);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTotalSpaceSize, (::nn::sf::Out<::std::int64_t> outSize, ::nn::ncm::StorageId storage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetTotalSpaceSize, (outSize, storage));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFreeSpaceSize, (::nn::sf::Out<::std::int64_t> outSize, ::nn::ncm::StorageId storage))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFreeSpaceSize, (outSize, storage));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CountApplicationContentMeta, (::nn::sf::Out<::std::int32_t> outValue, ::nn::ncm::ApplicationId appId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CountApplicationContentMeta, (outValue, appId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationContentMetaStatus, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationContentMetaStatus>& outList, ::nn::ncm::ApplicationId appId, ::std::int32_t offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListApplicationContentMetaStatus, (outCount, outList, appId, offset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationContentMetaStatusWithRightsCheck, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationContentMetaStatus>& outList, ::nn::ncm::ApplicationId appId, ::std::int32_t offset))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListApplicationContentMetaStatusWithRightsCheck, (outCount, outList, appId, offset));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(IsAnyApplicationRunning, (bool))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VALUE_0(IsAnyApplicationRunning, (bool));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ns::detail::IContentManagementInterface>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ns::detail::IContentManagementInterface))

    // nn::Result CalculateApplicationOccupiedSize(nn::sf::Out<nn::ns::ApplicationOccupiedSize> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CalculateApplicationOccupiedSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::ns::ApplicationOccupiedSize), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(128)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CalculateApplicationOccupiedSize)

    // nn::Result CheckSdCardMountStatus() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CheckSdCardMountStatus)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(43)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CheckSdCardMountStatus)

    // nn::Result GetTotalSpaceSize(nn::sf::Out<std::int64_t> outSize, nn::ncm::StorageId storage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetTotalSpaceSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(47)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storage, (::nn::ncm::StorageId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storage))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetTotalSpaceSize)

    // nn::Result GetFreeSpaceSize(nn::sf::Out<std::int64_t> outSize, nn::ncm::StorageId storage) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFreeSpaceSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(48)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storage, (::nn::ncm::StorageId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (storage))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outSize, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storage)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFreeSpaceSize)

    // nn::Result CountApplicationContentMeta(nn::sf::Out<std::int32_t> outValue, nn::ncm::ApplicationId appId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CountApplicationContentMeta)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(600)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CountApplicationContentMeta)

    // nn::Result ListApplicationContentMetaStatus(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationContentMetaStatus>& outList, nn::ncm::ApplicationId appId, std::int32_t offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListApplicationContentMetaStatus)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(601)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ns::ApplicationContentMetaStatus>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (offset, appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListApplicationContentMetaStatus)

    // nn::Result ListApplicationContentMetaStatusWithRightsCheck(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationContentMetaStatus>& outList, nn::ncm::ApplicationId appId, std::int32_t offset) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListApplicationContentMetaStatusWithRightsCheck)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(605)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ns::ApplicationContentMetaStatus>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appId, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (offset, appId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListApplicationContentMetaStatusWithRightsCheck)

    // bool IsAnyApplicationRunning() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsAnyApplicationRunning)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(607)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (NN_SF_DETAIL_OUT_RETURN_NAME))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(NN_SF_DETAIL_OUT_RETURN_NAME)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsAnyApplicationRunning)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::ApplicationOccupiedSize), 128, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ApplicationId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::StorageId), 1, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::ApplicationContentMetaStatus), 16, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ns::detail::IContentManagementInterface, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ns::detail::IContentManagementInterface))

    // nn::Result CalculateApplicationOccupiedSize(nn::sf::Out<nn::ns::ApplicationOccupiedSize> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CalculateApplicationOccupiedSize, (::nn::sf::Out<::nn::ns::ApplicationOccupiedSize> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CalculateApplicationOccupiedSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CalculateApplicationOccupiedSize)
    }

    // nn::Result CheckSdCardMountStatus() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CheckSdCardMountStatus)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CheckSdCardMountStatus)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CheckSdCardMountStatus)
    }

    // nn::Result GetTotalSpaceSize(nn::sf::Out<std::int64_t> outSize, nn::ncm::StorageId storage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTotalSpaceSize, (::nn::sf::Out<::std::int64_t> outSize, ::nn::ncm::StorageId storage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetTotalSpaceSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetTotalSpaceSize)
    }

    // nn::Result GetFreeSpaceSize(nn::sf::Out<std::int64_t> outSize, nn::ncm::StorageId storage) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFreeSpaceSize, (::nn::sf::Out<::std::int64_t> outSize, ::nn::ncm::StorageId storage))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFreeSpaceSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storage)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFreeSpaceSize)
    }

    // nn::Result CountApplicationContentMeta(nn::sf::Out<std::int32_t> outValue, nn::ncm::ApplicationId appId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CountApplicationContentMeta, (::nn::sf::Out<::std::int32_t> outValue, ::nn::ncm::ApplicationId appId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CountApplicationContentMeta)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CountApplicationContentMeta)
    }

    // nn::Result ListApplicationContentMetaStatus(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationContentMetaStatus>& outList, nn::ncm::ApplicationId appId, std::int32_t offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationContentMetaStatus, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationContentMetaStatus>& outList, ::nn::ncm::ApplicationId appId, ::std::int32_t offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListApplicationContentMetaStatus)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListApplicationContentMetaStatus)
    }

    // nn::Result ListApplicationContentMetaStatusWithRightsCheck(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::ApplicationContentMetaStatus>& outList, nn::ncm::ApplicationId appId, std::int32_t offset) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListApplicationContentMetaStatusWithRightsCheck, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::ApplicationContentMetaStatus>& outList, ::nn::ncm::ApplicationId appId, ::std::int32_t offset))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListApplicationContentMetaStatusWithRightsCheck)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListApplicationContentMetaStatusWithRightsCheck)
    }

    // bool IsAnyApplicationRunning() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VALUE_0(IsAnyApplicationRunning, (bool))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsAnyApplicationRunning)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsAnyApplicationRunning)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ns::detail::IContentManagementInterface>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ns::detail::IContentManagementInterface))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CalculateApplicationOccupiedSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CalculateApplicationOccupiedSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CheckSdCardMountStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CheckSdCardMountStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetTotalSpaceSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetTotalSpaceSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFreeSpaceSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFreeSpaceSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CountApplicationContentMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CountApplicationContentMeta)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListApplicationContentMetaStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListApplicationContentMetaStatus)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListApplicationContentMetaStatusWithRightsCheck)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListApplicationContentMetaStatusWithRightsCheck)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsAnyApplicationRunning)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsAnyApplicationRunning)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(NN_SF_DETAIL_OUT_RETURN_NAME)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CalculateApplicationOccupiedSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CheckSdCardMountStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetTotalSpaceSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFreeSpaceSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CountApplicationContentMeta)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListApplicationContentMetaStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListApplicationContentMetaStatusWithRightsCheck)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsAnyApplicationRunning)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ns::detail::IContentManagementInterface))

namespace nn { namespace ns { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IDocumentInterface, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IDocumentInterface)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationContentPath, (::nn::sf::Out<::nn::ncm::Path> outValue, ::nn::ncm::ApplicationId id, ::nn::ncm::ContentType type))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ResolveApplicationContentPath, (::nn::ncm::ProgramId id, ::nn::ncm::ContentType type))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRunningApplicationProgramId, (::nn::sf::Out<::nn::ncm::ProgramId> outValue, ::nn::ncm::ApplicationId id))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IDocumentInterface)

        ::nn::Result GetApplicationContentPath(::nn::sf::Out<::nn::ncm::Path> outValue, ::nn::ncm::ApplicationId id, ::nn::ncm::ContentType type) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetApplicationContentPath, (outValue, id, type));
        }

        ::nn::Result ResolveApplicationContentPath(::nn::ncm::ProgramId id, ::nn::ncm::ContentType type) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ResolveApplicationContentPath, (id, type));
        }

        ::nn::Result GetRunningApplicationProgramId(::nn::sf::Out<::nn::ncm::ProgramId> outValue, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRunningApplicationProgramId, (outValue, id));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IDocumentInterface
    {
    public:
        nn::Result GetApplicationContentPath(nn::sf::Out<nn::ncm::Path> outValue, nn::ncm::ApplicationId id, nn::ncm::ContentType type) NN_NOEXCEPT;
        nn::Result ResolveApplicationContentPath(nn::ncm::ProgramId id, nn::ncm::ContentType type) NN_NOEXCEPT;
        nn::Result GetRunningApplicationProgramId(nn::sf::Out<nn::ncm::ProgramId> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetApplicationContentPath(nn::sf::Out<nn::ncm::Path> outValue, nn::ncm::ApplicationId id, nn::ncm::ContentType type) NN_NOEXCEPT;
    nn::Result ResolveApplicationContentPath(nn::ncm::ProgramId id, nn::ncm::ContentType type) NN_NOEXCEPT;
    nn::Result GetRunningApplicationProgramId(nn::sf::Out<nn::ncm::ProgramId> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ns::detail::IDocumentInterface))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationContentPath, (::nn::sf::Out<::nn::ncm::Path> outValue, ::nn::ncm::ApplicationId id, ::nn::ncm::ContentType type))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetApplicationContentPath, (outValue, id, type));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResolveApplicationContentPath, (::nn::ncm::ProgramId id, ::nn::ncm::ContentType type))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ResolveApplicationContentPath, (id, type));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRunningApplicationProgramId, (::nn::sf::Out<::nn::ncm::ProgramId> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRunningApplicationProgramId, (outValue, id));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ns::detail::IDocumentInterface>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ns::detail::IDocumentInterface))

    // nn::Result GetApplicationContentPath(nn::sf::Out<nn::ncm::Path> outValue, nn::ncm::ApplicationId id, nn::ncm::ContentType type) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetApplicationContentPath)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(outValue, 0, (::nn::sf::Out<::nn::ncm::Path>), 768, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::nn::ncm::ContentType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (type, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetApplicationContentPath)

    // nn::Result ResolveApplicationContentPath(nn::ncm::ProgramId id, nn::ncm::ContentType type) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResolveApplicationContentPath)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(23)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::nn::ncm::ContentType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ProgramId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (type, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResolveApplicationContentPath)

    // nn::Result GetRunningApplicationProgramId(nn::sf::Out<nn::ncm::ProgramId> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRunningApplicationProgramId)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(92)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::ncm::ProgramId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRunningApplicationProgramId)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::Path), 768, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ApplicationId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ContentType), 1, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ProgramId), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ns::detail::IDocumentInterface, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ns::detail::IDocumentInterface))

    // nn::Result GetApplicationContentPath(nn::sf::Out<nn::ncm::Path> outValue, nn::ncm::ApplicationId id, nn::ncm::ContentType type) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationContentPath, (::nn::sf::Out<::nn::ncm::Path> outValue, ::nn::ncm::ApplicationId id, ::nn::ncm::ContentType type))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetApplicationContentPath)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetApplicationContentPath)
    }

    // nn::Result ResolveApplicationContentPath(nn::ncm::ProgramId id, nn::ncm::ContentType type) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResolveApplicationContentPath, (::nn::ncm::ProgramId id, ::nn::ncm::ContentType type))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResolveApplicationContentPath)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResolveApplicationContentPath)
    }

    // nn::Result GetRunningApplicationProgramId(nn::sf::Out<nn::ncm::ProgramId> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRunningApplicationProgramId, (::nn::sf::Out<::nn::ncm::ProgramId> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRunningApplicationProgramId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRunningApplicationProgramId)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ns::detail::IDocumentInterface>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ns::detail::IDocumentInterface))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetApplicationContentPath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetApplicationContentPath)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResolveApplicationContentPath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResolveApplicationContentPath)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRunningApplicationProgramId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRunningApplicationProgramId)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetApplicationContentPath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResolveApplicationContentPath)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRunningApplicationProgramId)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ns::detail::IDocumentInterface))

namespace nn { namespace ns { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IDownloadTaskInterface, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IDownloadTaskInterface)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ClearTaskStatusList)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(RequestDownloadTaskList)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestEnsureDownloadTask, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ListDownloadTaskStatus, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::DownloadTaskStatus>& outList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestDownloadTaskListData, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(TryCommitCurrentApplicationDownloadTask)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_0(EnableAutoCommit)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_VOID_0(DisableAutoCommit)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(TriggerDynamicCommitEvent)
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IDownloadTaskInterface)

        ::nn::Result ClearTaskStatusList() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ClearTaskStatusList);
        }

        ::nn::Result RequestDownloadTaskList() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(RequestDownloadTaskList);
        }

        ::nn::Result RequestEnsureDownloadTask(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestEnsureDownloadTask, (outHandle, outAsync));
        }

        ::nn::Result ListDownloadTaskStatus(::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::DownloadTaskStatus>& outList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ListDownloadTaskStatus, (outCount, outList));
        }

        ::nn::Result RequestDownloadTaskListData(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestDownloadTaskListData, (outHandle, outAsync));
        }

        ::nn::Result TryCommitCurrentApplicationDownloadTask() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(TryCommitCurrentApplicationDownloadTask);
        }

        void EnableAutoCommit() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_0(EnableAutoCommit);
        }

        void DisableAutoCommit() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_VOID_0(DisableAutoCommit);
        }

        ::nn::Result TriggerDynamicCommitEvent() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(TriggerDynamicCommitEvent);
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IDownloadTaskInterface
    {
    public:
        nn::Result ClearTaskStatusList() NN_NOEXCEPT;
        nn::Result RequestDownloadTaskList() NN_NOEXCEPT;
        nn::Result RequestEnsureDownloadTask(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT;
        nn::Result ListDownloadTaskStatus(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::DownloadTaskStatus>& outList) NN_NOEXCEPT;
        nn::Result RequestDownloadTaskListData(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync) NN_NOEXCEPT;
        nn::Result TryCommitCurrentApplicationDownloadTask() NN_NOEXCEPT;
        void EnableAutoCommit() NN_NOEXCEPT;
        void DisableAutoCommit() NN_NOEXCEPT;
        nn::Result TriggerDynamicCommitEvent() NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result ClearTaskStatusList() NN_NOEXCEPT;
    nn::Result RequestDownloadTaskList() NN_NOEXCEPT;
    nn::Result RequestEnsureDownloadTask(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT;
    nn::Result ListDownloadTaskStatus(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::DownloadTaskStatus>& outList) NN_NOEXCEPT;
    nn::Result RequestDownloadTaskListData(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync) NN_NOEXCEPT;
    nn::Result TryCommitCurrentApplicationDownloadTask() NN_NOEXCEPT;
    void EnableAutoCommit() NN_NOEXCEPT;
    void DisableAutoCommit() NN_NOEXCEPT;
    nn::Result TriggerDynamicCommitEvent() NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ns::detail::IDownloadTaskInterface))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ClearTaskStatusList)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ClearTaskStatusList);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RequestDownloadTaskList)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(RequestDownloadTaskList);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestEnsureDownloadTask, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestEnsureDownloadTask, (outHandle, outAsync));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListDownloadTaskStatus, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::DownloadTaskStatus>& outList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ListDownloadTaskStatus, (outCount, outList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestDownloadTaskListData, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestDownloadTaskListData, (outHandle, outAsync));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(TryCommitCurrentApplicationDownloadTask)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(TryCommitCurrentApplicationDownloadTask);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(EnableAutoCommit)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_0(EnableAutoCommit);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(DisableAutoCommit)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_VOID_0(DisableAutoCommit);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(TriggerDynamicCommitEvent)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(TriggerDynamicCommitEvent);
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ns::detail::IDownloadTaskInterface>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ns::detail::IDownloadTaskInterface))

    // nn::Result ClearTaskStatusList() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ClearTaskStatusList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(701)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ClearTaskStatusList)

    // nn::Result RequestDownloadTaskList() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestDownloadTaskList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(702)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestDownloadTaskList)

    // nn::Result RequestEnsureDownloadTask(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestEnsureDownloadTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(703)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestEnsureDownloadTask)

    // nn::Result ListDownloadTaskStatus(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::DownloadTaskStatus>& outList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ListDownloadTaskStatus)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(704)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outList, 0, (const ::nn::sf::OutArray<::nn::ns::DownloadTaskStatus>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCount, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCount), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ListDownloadTaskStatus)

    // nn::Result RequestDownloadTaskListData(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestDownloadTaskListData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(705)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestDownloadTaskListData)

    // nn::Result TryCommitCurrentApplicationDownloadTask() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TryCommitCurrentApplicationDownloadTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(706)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TryCommitCurrentApplicationDownloadTask)

    // void EnableAutoCommit() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableAutoCommit)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(707)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableAutoCommit)

    // void DisableAutoCommit() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DisableAutoCommit)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(708)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_VOID(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DisableAutoCommit)

    // nn::Result TriggerDynamicCommitEvent() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(TriggerDynamicCommitEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(709)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(TriggerDynamicCommitEvent)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::DownloadTaskStatus), 32, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ns::detail::IDownloadTaskInterface, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ns::detail::IDownloadTaskInterface))

    // nn::Result ClearTaskStatusList() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ClearTaskStatusList)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ClearTaskStatusList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ClearTaskStatusList)
    }

    // nn::Result RequestDownloadTaskList() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RequestDownloadTaskList)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestDownloadTaskList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestDownloadTaskList)
    }

    // nn::Result RequestEnsureDownloadTask(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestEnsureDownloadTask, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestEnsureDownloadTask)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestEnsureDownloadTask)
    }

    // nn::Result ListDownloadTaskStatus(nn::sf::Out<std::int32_t> outCount, const nn::sf::OutArray<nn::ns::DownloadTaskStatus>& outList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ListDownloadTaskStatus, (::nn::sf::Out<::std::int32_t> outCount, const ::nn::sf::OutArray<::nn::ns::DownloadTaskStatus>& outList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ListDownloadTaskStatus)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ListDownloadTaskStatus)
    }

    // nn::Result RequestDownloadTaskListData(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestDownloadTaskListData, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestDownloadTaskListData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestDownloadTaskListData)
    }

    // nn::Result TryCommitCurrentApplicationDownloadTask() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(TryCommitCurrentApplicationDownloadTask)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TryCommitCurrentApplicationDownloadTask)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TryCommitCurrentApplicationDownloadTask)
    }

    // void EnableAutoCommit() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(EnableAutoCommit)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableAutoCommit)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableAutoCommit)
    }

    // void DisableAutoCommit() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_VOID_0(DisableAutoCommit)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DisableAutoCommit)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DisableAutoCommit)
    }

    // nn::Result TriggerDynamicCommitEvent() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(TriggerDynamicCommitEvent)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(TriggerDynamicCommitEvent)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(TriggerDynamicCommitEvent)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ns::detail::IDownloadTaskInterface>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ns::detail::IDownloadTaskInterface))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ClearTaskStatusList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ClearTaskStatusList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestDownloadTaskList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestDownloadTaskList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestEnsureDownloadTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestEnsureDownloadTask)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ListDownloadTaskStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ListDownloadTaskStatus)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCount),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestDownloadTaskListData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestDownloadTaskListData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TryCommitCurrentApplicationDownloadTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TryCommitCurrentApplicationDownloadTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableAutoCommit)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableAutoCommit)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DisableAutoCommit)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DisableAutoCommit)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(TriggerDynamicCommitEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(TriggerDynamicCommitEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ClearTaskStatusList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestDownloadTaskList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestEnsureDownloadTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ListDownloadTaskStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestDownloadTaskListData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TryCommitCurrentApplicationDownloadTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableAutoCommit)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DisableAutoCommit)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(TriggerDynamicCommitEvent)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ns::detail::IDownloadTaskInterface))

namespace nn { namespace ns { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IDynamicRightsInterface, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IDynamicRightsInterface)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestApplicationRightsOnServer, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outValue, ::nn::ncm::ApplicationId id, const ::nn::account::Uid& uid, ::nn::Bit32 flags))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestAssignRights, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outValue, const ::nn::sf::InArray<::nn::ns::ApplicationRightsOnServer>& list))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterUserOfAccountRestrictedRights, (const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(UnregisterAllUsersOfAccountRestrictedRights)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestAssignRightsToResume, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outValue, ::nn::ns::RightsEnvironmentHandle handle, const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(VerifyActivatedRightsOwners, (::nn::ns::RightsEnvironmentHandle handle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationRightsStatus, (::nn::sf::Out<::nn::ns::ApplicationRightsStatus> outValue, ::nn::ns::RightsEnvironmentHandle handle))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IDynamicRightsInterface)

        ::nn::Result RequestApplicationRightsOnServer(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outValue, ::nn::ncm::ApplicationId id, const ::nn::account::Uid& uid, ::nn::Bit32 flags) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestApplicationRightsOnServer, (outHandle, outValue, id, uid, flags));
        }

        ::nn::Result RequestAssignRights(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outValue, const ::nn::sf::InArray<::nn::ns::ApplicationRightsOnServer>& list) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestAssignRights, (outHandle, outValue, list));
        }

        ::nn::Result RegisterUserOfAccountRestrictedRights(const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterUserOfAccountRestrictedRights, (uid));
        }

        ::nn::Result UnregisterAllUsersOfAccountRestrictedRights() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(UnregisterAllUsersOfAccountRestrictedRights);
        }

        ::nn::Result RequestAssignRightsToResume(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outValue, ::nn::ns::RightsEnvironmentHandle handle, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestAssignRightsToResume, (outHandle, outValue, handle, uid));
        }

        ::nn::Result VerifyActivatedRightsOwners(::nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(VerifyActivatedRightsOwners, (handle));
        }

        ::nn::Result GetApplicationRightsStatus(::nn::sf::Out<::nn::ns::ApplicationRightsStatus> outValue, ::nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetApplicationRightsStatus, (outValue, handle));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IDynamicRightsInterface
    {
    public:
        nn::Result RequestApplicationRightsOnServer(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outValue, nn::ncm::ApplicationId id, const nn::account::Uid& uid, nn::Bit32 flags) NN_NOEXCEPT;
        nn::Result RequestAssignRights(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outValue, const nn::sf::InArray<nn::ns::ApplicationRightsOnServer>& list) NN_NOEXCEPT;
        nn::Result RegisterUserOfAccountRestrictedRights(const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result UnregisterAllUsersOfAccountRestrictedRights() NN_NOEXCEPT;
        nn::Result RequestAssignRightsToResume(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outValue, nn::ns::RightsEnvironmentHandle handle, const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result VerifyActivatedRightsOwners(nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT;
        nn::Result GetApplicationRightsStatus(nn::sf::Out<nn::ns::ApplicationRightsStatus> outValue, nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result RequestApplicationRightsOnServer(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outValue, nn::ncm::ApplicationId id, const nn::account::Uid& uid, nn::Bit32 flags) NN_NOEXCEPT;
    nn::Result RequestAssignRights(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outValue, const nn::sf::InArray<nn::ns::ApplicationRightsOnServer>& list) NN_NOEXCEPT;
    nn::Result RegisterUserOfAccountRestrictedRights(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result UnregisterAllUsersOfAccountRestrictedRights() NN_NOEXCEPT;
    nn::Result RequestAssignRightsToResume(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outValue, nn::ns::RightsEnvironmentHandle handle, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result VerifyActivatedRightsOwners(nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT;
    nn::Result GetApplicationRightsStatus(nn::sf::Out<nn::ns::ApplicationRightsStatus> outValue, nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ns::detail::IDynamicRightsInterface))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestApplicationRightsOnServer, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outValue, ::nn::ncm::ApplicationId id, const ::nn::account::Uid& uid, ::nn::Bit32 flags))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestApplicationRightsOnServer, (outHandle, outValue, id, uid, flags));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestAssignRights, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outValue, const ::nn::sf::InArray<::nn::ns::ApplicationRightsOnServer>& list))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestAssignRights, (outHandle, outValue, list));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterUserOfAccountRestrictedRights, (const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterUserOfAccountRestrictedRights, (uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnregisterAllUsersOfAccountRestrictedRights)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(UnregisterAllUsersOfAccountRestrictedRights);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestAssignRightsToResume, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outValue, ::nn::ns::RightsEnvironmentHandle handle, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestAssignRightsToResume, (outHandle, outValue, handle, uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(VerifyActivatedRightsOwners, (::nn::ns::RightsEnvironmentHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(VerifyActivatedRightsOwners, (handle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationRightsStatus, (::nn::sf::Out<::nn::ns::ApplicationRightsStatus> outValue, ::nn::ns::RightsEnvironmentHandle handle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetApplicationRightsStatus, (outValue, handle));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ns::detail::IDynamicRightsInterface>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ns::detail::IDynamicRightsInterface))

    // nn::Result RequestApplicationRightsOnServer(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outValue, nn::ncm::ApplicationId id, const nn::account::Uid& uid, nn::Bit32 flags) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestApplicationRightsOnServer)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flags, (::nn::Bit32), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (flags, id, uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flags)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestApplicationRightsOnServer)

    // nn::Result RequestAssignRights(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outValue, const nn::sf::InArray<nn::ns::ApplicationRightsOnServer>& list) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestAssignRights)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(list, 0, (const ::nn::sf::InArray<::nn::ns::ApplicationRightsOnServer>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (list))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(list)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestAssignRights)

    // nn::Result RegisterUserOfAccountRestrictedRights(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterUserOfAccountRestrictedRights)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterUserOfAccountRestrictedRights)

    // nn::Result UnregisterAllUsersOfAccountRestrictedRights() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnregisterAllUsersOfAccountRestrictedRights)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnregisterAllUsersOfAccountRestrictedRights)

    // nn::Result RequestAssignRightsToResume(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outValue, nn::ns::RightsEnvironmentHandle handle, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestAssignRightsToResume)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::ns::RightsEnvironmentHandle), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (handle, uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestAssignRightsToResume)

    // nn::Result VerifyActivatedRightsOwners(nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(VerifyActivatedRightsOwners)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::ns::RightsEnvironmentHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(VerifyActivatedRightsOwners)

    // nn::Result GetApplicationRightsStatus(nn::sf::Out<nn::ns::ApplicationRightsStatus> outValue, nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetApplicationRightsStatus)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(handle, (::nn::ns::RightsEnvironmentHandle), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (handle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::ns::ApplicationRightsStatus), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(handle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetApplicationRightsStatus)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ApplicationId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::Uid), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::ApplicationRightsOnServer), 40, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::RightsEnvironmentHandle), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::ApplicationRightsStatus), 1, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ns::detail::IDynamicRightsInterface, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ns::detail::IDynamicRightsInterface))

    // nn::Result RequestApplicationRightsOnServer(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outValue, nn::ncm::ApplicationId id, const nn::account::Uid& uid, nn::Bit32 flags) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestApplicationRightsOnServer, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outValue, ::nn::ncm::ApplicationId id, const ::nn::account::Uid& uid, ::nn::Bit32 flags))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestApplicationRightsOnServer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flags)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestApplicationRightsOnServer)
    }

    // nn::Result RequestAssignRights(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outValue, const nn::sf::InArray<nn::ns::ApplicationRightsOnServer>& list) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestAssignRights, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outValue, const ::nn::sf::InArray<::nn::ns::ApplicationRightsOnServer>& list))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestAssignRights)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(list)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestAssignRights)
    }

    // nn::Result RegisterUserOfAccountRestrictedRights(const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterUserOfAccountRestrictedRights, (const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterUserOfAccountRestrictedRights)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterUserOfAccountRestrictedRights)
    }

    // nn::Result UnregisterAllUsersOfAccountRestrictedRights() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnregisterAllUsersOfAccountRestrictedRights)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnregisterAllUsersOfAccountRestrictedRights)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnregisterAllUsersOfAccountRestrictedRights)
    }

    // nn::Result RequestAssignRightsToResume(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outValue, nn::ns::RightsEnvironmentHandle handle, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestAssignRightsToResume, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outValue, ::nn::ns::RightsEnvironmentHandle handle, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestAssignRightsToResume)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestAssignRightsToResume)
    }

    // nn::Result VerifyActivatedRightsOwners(nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(VerifyActivatedRightsOwners, (::nn::ns::RightsEnvironmentHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(VerifyActivatedRightsOwners)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(VerifyActivatedRightsOwners)
    }

    // nn::Result GetApplicationRightsStatus(nn::sf::Out<nn::ns::ApplicationRightsStatus> outValue, nn::ns::RightsEnvironmentHandle handle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationRightsStatus, (::nn::sf::Out<::nn::ns::ApplicationRightsStatus> outValue, ::nn::ns::RightsEnvironmentHandle handle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetApplicationRightsStatus)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(handle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetApplicationRightsStatus)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ns::detail::IDynamicRightsInterface>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ns::detail::IDynamicRightsInterface))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestApplicationRightsOnServer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestApplicationRightsOnServer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flags)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestAssignRights)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(list)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestAssignRights)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(list)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterUserOfAccountRestrictedRights)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterUserOfAccountRestrictedRights)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnregisterAllUsersOfAccountRestrictedRights)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnregisterAllUsersOfAccountRestrictedRights)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestAssignRightsToResume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestAssignRightsToResume)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(VerifyActivatedRightsOwners)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(VerifyActivatedRightsOwners)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetApplicationRightsStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetApplicationRightsStatus)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(handle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestApplicationRightsOnServer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestAssignRights)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterUserOfAccountRestrictedRights)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnregisterAllUsersOfAccountRestrictedRights)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestAssignRightsToResume)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(VerifyActivatedRightsOwners)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetApplicationRightsStatus)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ns::detail::IDynamicRightsInterface))

namespace nn { namespace ns { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IECommerceInterface, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IECommerceInterface)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestLinkDevice, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, const ::nn::account::Uid& uid))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestCleanupAllPreInstalledApplications, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestCleanupPreInstalledApplication, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestSyncRights, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IECommerceInterface)

        ::nn::Result RequestLinkDevice(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, const ::nn::account::Uid& uid) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestLinkDevice, (outHandle, outAsync, uid));
        }

        ::nn::Result RequestCleanupAllPreInstalledApplications(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestCleanupAllPreInstalledApplications, (outHandle, outAsync));
        }

        ::nn::Result RequestCleanupPreInstalledApplication(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestCleanupPreInstalledApplication, (outHandle, outAsync, id));
        }

        ::nn::Result RequestSyncRights(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestSyncRights, (outHandle, outAsync));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IECommerceInterface
    {
    public:
        nn::Result RequestLinkDevice(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, const nn::account::Uid& uid) NN_NOEXCEPT;
        nn::Result RequestCleanupAllPreInstalledApplications(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT;
        nn::Result RequestCleanupPreInstalledApplication(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result RequestSyncRights(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result RequestLinkDevice(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result RequestCleanupAllPreInstalledApplications(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT;
    nn::Result RequestCleanupPreInstalledApplication(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result RequestSyncRights(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ns::detail::IECommerceInterface))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestLinkDevice, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, const ::nn::account::Uid& uid))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestLinkDevice, (outHandle, outAsync, uid));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestCleanupAllPreInstalledApplications, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestCleanupAllPreInstalledApplications, (outHandle, outAsync));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestCleanupPreInstalledApplication, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestCleanupPreInstalledApplication, (outHandle, outAsync, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestSyncRights, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestSyncRights, (outHandle, outAsync));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ns::detail::IECommerceInterface>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ns::detail::IECommerceInterface))

    // nn::Result RequestLinkDevice(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestLinkDevice)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(uid, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (uid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(uid)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestLinkDevice)

    // nn::Result RequestCleanupAllPreInstalledApplications(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestCleanupAllPreInstalledApplications)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestCleanupAllPreInstalledApplications)

    // nn::Result RequestCleanupPreInstalledApplication(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestCleanupPreInstalledApplication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestCleanupPreInstalledApplication)

    // nn::Result RequestSyncRights(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestSyncRights)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestSyncRights)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::Uid), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ApplicationId), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ns::detail::IECommerceInterface, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ns::detail::IECommerceInterface))

    // nn::Result RequestLinkDevice(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, const nn::account::Uid& uid) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestLinkDevice, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, const ::nn::account::Uid& uid))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestLinkDevice)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(uid)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestLinkDevice)
    }

    // nn::Result RequestCleanupAllPreInstalledApplications(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestCleanupAllPreInstalledApplications, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestCleanupAllPreInstalledApplications)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestCleanupAllPreInstalledApplications)
    }

    // nn::Result RequestCleanupPreInstalledApplication(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestCleanupPreInstalledApplication, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestCleanupPreInstalledApplication)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestCleanupPreInstalledApplication)
    }

    // nn::Result RequestSyncRights(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestSyncRights, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestSyncRights)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestSyncRights)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ns::detail::IECommerceInterface>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ns::detail::IECommerceInterface))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestLinkDevice)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestLinkDevice)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(uid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestCleanupAllPreInstalledApplications)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestCleanupAllPreInstalledApplications)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestCleanupPreInstalledApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestCleanupPreInstalledApplication)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestSyncRights)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestSyncRights)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestLinkDevice)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestCleanupAllPreInstalledApplications)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestCleanupPreInstalledApplication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestSyncRights)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ns::detail::IECommerceInterface))

namespace nn { namespace ns { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IFactoryResetInterface, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IFactoryResetInterface)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ResetToFactorySettings)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ResetToFactorySettingsWithoutUserSaveData)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ResetToFactorySettingsForRefurbishment)
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IFactoryResetInterface)

        ::nn::Result ResetToFactorySettings() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ResetToFactorySettings);
        }

        ::nn::Result ResetToFactorySettingsWithoutUserSaveData() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ResetToFactorySettingsWithoutUserSaveData);
        }

        ::nn::Result ResetToFactorySettingsForRefurbishment() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ResetToFactorySettingsForRefurbishment);
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IFactoryResetInterface
    {
    public:
        nn::Result ResetToFactorySettings() NN_NOEXCEPT;
        nn::Result ResetToFactorySettingsWithoutUserSaveData() NN_NOEXCEPT;
        nn::Result ResetToFactorySettingsForRefurbishment() NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result ResetToFactorySettings() NN_NOEXCEPT;
    nn::Result ResetToFactorySettingsWithoutUserSaveData() NN_NOEXCEPT;
    nn::Result ResetToFactorySettingsForRefurbishment() NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ns::detail::IFactoryResetInterface))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ResetToFactorySettings)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ResetToFactorySettings);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ResetToFactorySettingsWithoutUserSaveData)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ResetToFactorySettingsWithoutUserSaveData);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ResetToFactorySettingsForRefurbishment)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ResetToFactorySettingsForRefurbishment);
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ns::detail::IFactoryResetInterface>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ns::detail::IFactoryResetInterface))

    // nn::Result ResetToFactorySettings() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResetToFactorySettings)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(100)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResetToFactorySettings)

    // nn::Result ResetToFactorySettingsWithoutUserSaveData() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResetToFactorySettingsWithoutUserSaveData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(101)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResetToFactorySettingsWithoutUserSaveData)

    // nn::Result ResetToFactorySettingsForRefurbishment() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResetToFactorySettingsForRefurbishment)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(102)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResetToFactorySettingsForRefurbishment)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ns::detail::IFactoryResetInterface, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ns::detail::IFactoryResetInterface))

    // nn::Result ResetToFactorySettings() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ResetToFactorySettings)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResetToFactorySettings)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResetToFactorySettings)
    }

    // nn::Result ResetToFactorySettingsWithoutUserSaveData() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ResetToFactorySettingsWithoutUserSaveData)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResetToFactorySettingsWithoutUserSaveData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResetToFactorySettingsWithoutUserSaveData)
    }

    // nn::Result ResetToFactorySettingsForRefurbishment() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ResetToFactorySettingsForRefurbishment)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResetToFactorySettingsForRefurbishment)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResetToFactorySettingsForRefurbishment)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ns::detail::IFactoryResetInterface>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ns::detail::IFactoryResetInterface))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResetToFactorySettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResetToFactorySettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResetToFactorySettingsWithoutUserSaveData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResetToFactorySettingsWithoutUserSaveData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResetToFactorySettingsForRefurbishment)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResetToFactorySettingsForRefurbishment)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResetToFactorySettings)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResetToFactorySettingsWithoutUserSaveData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResetToFactorySettingsForRefurbishment)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ns::detail::IFactoryResetInterface))

namespace nn { namespace ns { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IGameCardStopper, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IGameCardStopper)
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IGameCardStopper)

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IGameCardStopper
    {
    public:
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ns::detail::IGameCardStopper))

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ns::detail::IGameCardStopper>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ns::detail::IGameCardStopper))

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ns::detail::IGameCardStopper, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ns::detail::IGameCardStopper))

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ns::detail::IGameCardStopper>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ns::detail::IGameCardStopper))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ns::detail::IGameCardStopper))

namespace nn { namespace ns { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IProgressMonitorForDeleteUserSaveDataAll, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IProgressMonitorForDeleteUserSaveDataAll)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(IsFinished, (::nn::sf::Out<bool> pOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(GetResult)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetProgress, (::nn::sf::Out<::nn::ns::detail::ProgressForDeleteUserSaveDataAll> pOut))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IProgressMonitorForDeleteUserSaveDataAll)

        ::nn::Result GetSystemEvent(::nn::sf::Out<::nn::sf::NativeHandle> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSystemEvent, (pOut));
        }

        ::nn::Result IsFinished(::nn::sf::Out<bool> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(IsFinished, (pOut));
        }

        ::nn::Result GetResult() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(GetResult);
        }

        ::nn::Result GetProgress(::nn::sf::Out<::nn::ns::detail::ProgressForDeleteUserSaveDataAll> pOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetProgress, (pOut));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IProgressMonitorForDeleteUserSaveDataAll
    {
    public:
        nn::Result GetSystemEvent(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT;
        nn::Result IsFinished(nn::sf::Out<bool> pOut) NN_NOEXCEPT;
        nn::Result GetResult() NN_NOEXCEPT;
        nn::Result GetProgress(nn::sf::Out<nn::ns::detail::ProgressForDeleteUserSaveDataAll> pOut) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetSystemEvent(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT;
    nn::Result IsFinished(nn::sf::Out<bool> pOut) NN_NOEXCEPT;
    nn::Result GetResult() NN_NOEXCEPT;
    nn::Result GetProgress(nn::sf::Out<nn::ns::detail::ProgressForDeleteUserSaveDataAll> pOut) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ns::detail::IProgressMonitorForDeleteUserSaveDataAll))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSystemEvent, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsFinished, (::nn::sf::Out<bool> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(IsFinished, (pOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(GetResult)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(GetResult);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProgress, (::nn::sf::Out<::nn::ns::detail::ProgressForDeleteUserSaveDataAll> pOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetProgress, (pOut));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ns::detail::IProgressMonitorForDeleteUserSaveDataAll>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ns::detail::IProgressMonitorForDeleteUserSaveDataAll))

    // nn::Result GetSystemEvent(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSystemEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pOut, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSystemEvent)

    // nn::Result IsFinished(nn::sf::Out<bool> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(IsFinished)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(IsFinished)

    // nn::Result GetResult() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetResult)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetResult)

    // nn::Result GetProgress(nn::sf::Out<nn::ns::detail::ProgressForDeleteUserSaveDataAll> pOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetProgress)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOut, (::nn::ns::detail::ProgressForDeleteUserSaveDataAll), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(40)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetProgress)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::detail::ProgressForDeleteUserSaveDataAll), 40, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ns::detail::IProgressMonitorForDeleteUserSaveDataAll, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ns::detail::IProgressMonitorForDeleteUserSaveDataAll))

    // nn::Result GetSystemEvent(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSystemEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSystemEvent)
    }

    // nn::Result IsFinished(nn::sf::Out<bool> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(IsFinished, (::nn::sf::Out<bool> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(IsFinished)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(IsFinished)
    }

    // nn::Result GetResult() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(GetResult)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetResult)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetResult)
    }

    // nn::Result GetProgress(nn::sf::Out<nn::ns::detail::ProgressForDeleteUserSaveDataAll> pOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetProgress, (::nn::sf::Out<::nn::ns::detail::ProgressForDeleteUserSaveDataAll> pOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetProgress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetProgress)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ns::detail::IProgressMonitorForDeleteUserSaveDataAll>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ns::detail::IProgressMonitorForDeleteUserSaveDataAll))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSystemEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSystemEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(IsFinished)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(IsFinished)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetProgress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetProgress)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSystemEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(IsFinished)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetProgress)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ns::detail::IProgressMonitorForDeleteUserSaveDataAll))

namespace nn { namespace ns { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IReadOnlyApplicationControlDataInterface, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IReadOnlyApplicationControlDataInterface)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationControlData, (::nn::sf::Out<::std::uint32_t> outValue, const ::nn::sf::OutBuffer& buffer, ::nn::ns::ApplicationControlSource source, ::nn::ncm::ApplicationId id))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationDesiredLanguage, (::nn::sf::Out<::nn::Bit8> outValue, ::nn::Bit32 supportedLanguageFlag))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ConvertApplicationLanguageToLanguageCode, (::nn::sf::Out<::nn::settings::LanguageCode> outValue, ::nn::Bit8 language))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ConvertLanguageCodeToApplicationLanguage, (::nn::sf::Out<::nn::Bit8> outValue, ::nn::settings::LanguageCode code))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IReadOnlyApplicationControlDataInterface)

        ::nn::Result GetApplicationControlData(::nn::sf::Out<::std::uint32_t> outValue, const ::nn::sf::OutBuffer& buffer, ::nn::ns::ApplicationControlSource source, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetApplicationControlData, (outValue, buffer, source, id));
        }

        ::nn::Result GetApplicationDesiredLanguage(::nn::sf::Out<::nn::Bit8> outValue, ::nn::Bit32 supportedLanguageFlag) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetApplicationDesiredLanguage, (outValue, supportedLanguageFlag));
        }

        ::nn::Result ConvertApplicationLanguageToLanguageCode(::nn::sf::Out<::nn::settings::LanguageCode> outValue, ::nn::Bit8 language) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ConvertApplicationLanguageToLanguageCode, (outValue, language));
        }

        ::nn::Result ConvertLanguageCodeToApplicationLanguage(::nn::sf::Out<::nn::Bit8> outValue, ::nn::settings::LanguageCode code) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ConvertLanguageCodeToApplicationLanguage, (outValue, code));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IReadOnlyApplicationControlDataInterface
    {
    public:
        nn::Result GetApplicationControlData(nn::sf::Out<std::uint32_t> outValue, const nn::sf::OutBuffer& buffer, nn::ns::ApplicationControlSource source, nn::ncm::ApplicationId id) NN_NOEXCEPT;
        nn::Result GetApplicationDesiredLanguage(nn::sf::Out<nn::Bit8> outValue, nn::Bit32 supportedLanguageFlag) NN_NOEXCEPT;
        nn::Result ConvertApplicationLanguageToLanguageCode(nn::sf::Out<nn::settings::LanguageCode> outValue, nn::Bit8 language) NN_NOEXCEPT;
        nn::Result ConvertLanguageCodeToApplicationLanguage(nn::sf::Out<nn::Bit8> outValue, nn::settings::LanguageCode code) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetApplicationControlData(nn::sf::Out<std::uint32_t> outValue, const nn::sf::OutBuffer& buffer, nn::ns::ApplicationControlSource source, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    nn::Result GetApplicationDesiredLanguage(nn::sf::Out<nn::Bit8> outValue, nn::Bit32 supportedLanguageFlag) NN_NOEXCEPT;
    nn::Result ConvertApplicationLanguageToLanguageCode(nn::sf::Out<nn::settings::LanguageCode> outValue, nn::Bit8 language) NN_NOEXCEPT;
    nn::Result ConvertLanguageCodeToApplicationLanguage(nn::sf::Out<nn::Bit8> outValue, nn::settings::LanguageCode code) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ns::detail::IReadOnlyApplicationControlDataInterface))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationControlData, (::nn::sf::Out<::std::uint32_t> outValue, const ::nn::sf::OutBuffer& buffer, ::nn::ns::ApplicationControlSource source, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetApplicationControlData, (outValue, buffer, source, id));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationDesiredLanguage, (::nn::sf::Out<::nn::Bit8> outValue, ::nn::Bit32 supportedLanguageFlag))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetApplicationDesiredLanguage, (outValue, supportedLanguageFlag));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ConvertApplicationLanguageToLanguageCode, (::nn::sf::Out<::nn::settings::LanguageCode> outValue, ::nn::Bit8 language))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ConvertApplicationLanguageToLanguageCode, (outValue, language));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ConvertLanguageCodeToApplicationLanguage, (::nn::sf::Out<::nn::Bit8> outValue, ::nn::settings::LanguageCode code))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ConvertLanguageCodeToApplicationLanguage, (outValue, code));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ns::detail::IReadOnlyApplicationControlDataInterface>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ns::detail::IReadOnlyApplicationControlDataInterface))

    // nn::Result GetApplicationControlData(nn::sf::Out<std::uint32_t> outValue, const nn::sf::OutBuffer& buffer, nn::ns::ApplicationControlSource source, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetApplicationControlData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(source, (::nn::ns::ApplicationControlSource), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (source, id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(source), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetApplicationControlData)

    // nn::Result GetApplicationDesiredLanguage(nn::sf::Out<nn::Bit8> outValue, nn::Bit32 supportedLanguageFlag) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetApplicationDesiredLanguage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(supportedLanguageFlag, (::nn::Bit32), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (supportedLanguageFlag))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::Bit8), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(supportedLanguageFlag)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetApplicationDesiredLanguage)

    // nn::Result ConvertApplicationLanguageToLanguageCode(nn::sf::Out<nn::settings::LanguageCode> outValue, nn::Bit8 language) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ConvertApplicationLanguageToLanguageCode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(language, (::nn::Bit8), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (language))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::settings::LanguageCode), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(language)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ConvertApplicationLanguageToLanguageCode)

    // nn::Result ConvertLanguageCodeToApplicationLanguage(nn::sf::Out<nn::Bit8> outValue, nn::settings::LanguageCode code) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ConvertLanguageCodeToApplicationLanguage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(code, (::nn::settings::LanguageCode), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (code))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::Bit8), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(code)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ConvertLanguageCodeToApplicationLanguage)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::ApplicationControlSource), 1, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ApplicationId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::settings::LanguageCode), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ns::detail::IReadOnlyApplicationControlDataInterface, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ns::detail::IReadOnlyApplicationControlDataInterface))

    // nn::Result GetApplicationControlData(nn::sf::Out<std::uint32_t> outValue, const nn::sf::OutBuffer& buffer, nn::ns::ApplicationControlSource source, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationControlData, (::nn::sf::Out<::std::uint32_t> outValue, const ::nn::sf::OutBuffer& buffer, ::nn::ns::ApplicationControlSource source, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetApplicationControlData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(source)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetApplicationControlData)
    }

    // nn::Result GetApplicationDesiredLanguage(nn::sf::Out<nn::Bit8> outValue, nn::Bit32 supportedLanguageFlag) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationDesiredLanguage, (::nn::sf::Out<::nn::Bit8> outValue, ::nn::Bit32 supportedLanguageFlag))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetApplicationDesiredLanguage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(supportedLanguageFlag)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetApplicationDesiredLanguage)
    }

    // nn::Result ConvertApplicationLanguageToLanguageCode(nn::sf::Out<nn::settings::LanguageCode> outValue, nn::Bit8 language) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ConvertApplicationLanguageToLanguageCode, (::nn::sf::Out<::nn::settings::LanguageCode> outValue, ::nn::Bit8 language))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ConvertApplicationLanguageToLanguageCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(language)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ConvertApplicationLanguageToLanguageCode)
    }

    // nn::Result ConvertLanguageCodeToApplicationLanguage(nn::sf::Out<nn::Bit8> outValue, nn::settings::LanguageCode code) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ConvertLanguageCodeToApplicationLanguage, (::nn::sf::Out<::nn::Bit8> outValue, ::nn::settings::LanguageCode code))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ConvertLanguageCodeToApplicationLanguage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(code)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ConvertLanguageCodeToApplicationLanguage)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ns::detail::IReadOnlyApplicationControlDataInterface>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ns::detail::IReadOnlyApplicationControlDataInterface))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetApplicationControlData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetApplicationControlData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(source),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetApplicationDesiredLanguage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetApplicationDesiredLanguage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(supportedLanguageFlag)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ConvertApplicationLanguageToLanguageCode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ConvertApplicationLanguageToLanguageCode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(language)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ConvertLanguageCodeToApplicationLanguage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ConvertLanguageCodeToApplicationLanguage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(code)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetApplicationControlData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetApplicationDesiredLanguage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ConvertApplicationLanguageToLanguageCode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ConvertLanguageCodeToApplicationLanguage)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ns::detail::IReadOnlyApplicationControlDataInterface))

namespace nn { namespace ns { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IReadOnlyApplicationRecordInterface, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IReadOnlyApplicationRecordInterface)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(HasApplicationRecord, (::nn::sf::Out<bool> outValue, ::nn::ncm::ApplicationId id))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IReadOnlyApplicationRecordInterface)

        ::nn::Result HasApplicationRecord(::nn::sf::Out<bool> outValue, ::nn::ncm::ApplicationId id) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(HasApplicationRecord, (outValue, id));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IReadOnlyApplicationRecordInterface
    {
    public:
        nn::Result HasApplicationRecord(nn::sf::Out<bool> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result HasApplicationRecord(nn::sf::Out<bool> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ns::detail::IReadOnlyApplicationRecordInterface))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasApplicationRecord, (::nn::sf::Out<bool> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(HasApplicationRecord, (outValue, id));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ns::detail::IReadOnlyApplicationRecordInterface>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ns::detail::IReadOnlyApplicationRecordInterface))

    // nn::Result HasApplicationRecord(nn::sf::Out<bool> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HasApplicationRecord)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(id, (::nn::ncm::ApplicationId), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (id))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(id)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HasApplicationRecord)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ApplicationId), 8, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ns::detail::IReadOnlyApplicationRecordInterface, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ns::detail::IReadOnlyApplicationRecordInterface))

    // nn::Result HasApplicationRecord(nn::sf::Out<bool> outValue, nn::ncm::ApplicationId id) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasApplicationRecord, (::nn::sf::Out<bool> outValue, ::nn::ncm::ApplicationId id))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HasApplicationRecord)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(id)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HasApplicationRecord)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ns::detail::IReadOnlyApplicationRecordInterface>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ns::detail::IReadOnlyApplicationRecordInterface))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HasApplicationRecord)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HasApplicationRecord)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(id)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HasApplicationRecord)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ns::detail::IReadOnlyApplicationRecordInterface))

namespace nn { namespace ns { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IRequestServerStopper, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IRequestServerStopper)
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IRequestServerStopper)

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IRequestServerStopper
    {
    public:
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ns::detail::IRequestServerStopper))

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ns::detail::IRequestServerStopper>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ns::detail::IRequestServerStopper))

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ns::detail::IRequestServerStopper, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ns::detail::IRequestServerStopper))

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ns::detail::IRequestServerStopper>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ns::detail::IRequestServerStopper))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ns::detail::IRequestServerStopper))

namespace nn { namespace ns { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IServiceGetterInterface, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IServiceGetterInterface)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDynamicRightsInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IDynamicRightsInterface>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetReadOnlyApplicationControlDataInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IReadOnlyApplicationControlDataInterface>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetReadOnlyApplicationRecordInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IReadOnlyApplicationRecordInterface>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetECommerceInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IECommerceInterface>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationVersionInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IApplicationVersionInterface>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFactoryResetInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IFactoryResetInterface>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAccountProxyInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAccountProxyInterface>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationManagerInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IApplicationManagerInterface>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDownloadTaskInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IDownloadTaskInterface>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetContentManagementInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IContentManagementInterface>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDocumentInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IDocumentInterface>> outValue))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IServiceGetterInterface)

        ::nn::Result GetDynamicRightsInterface(::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IDynamicRightsInterface>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDynamicRightsInterface, (outValue));
        }

        ::nn::Result GetReadOnlyApplicationControlDataInterface(::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IReadOnlyApplicationControlDataInterface>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetReadOnlyApplicationControlDataInterface, (outValue));
        }

        ::nn::Result GetReadOnlyApplicationRecordInterface(::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IReadOnlyApplicationRecordInterface>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetReadOnlyApplicationRecordInterface, (outValue));
        }

        ::nn::Result GetECommerceInterface(::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IECommerceInterface>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetECommerceInterface, (outValue));
        }

        ::nn::Result GetApplicationVersionInterface(::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IApplicationVersionInterface>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetApplicationVersionInterface, (outValue));
        }

        ::nn::Result GetFactoryResetInterface(::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IFactoryResetInterface>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFactoryResetInterface, (outValue));
        }

        ::nn::Result GetAccountProxyInterface(::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAccountProxyInterface>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAccountProxyInterface, (outValue));
        }

        ::nn::Result GetApplicationManagerInterface(::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IApplicationManagerInterface>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetApplicationManagerInterface, (outValue));
        }

        ::nn::Result GetDownloadTaskInterface(::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IDownloadTaskInterface>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDownloadTaskInterface, (outValue));
        }

        ::nn::Result GetContentManagementInterface(::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IContentManagementInterface>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetContentManagementInterface, (outValue));
        }

        ::nn::Result GetDocumentInterface(::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IDocumentInterface>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDocumentInterface, (outValue));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IServiceGetterInterface
    {
    public:
        nn::Result GetDynamicRightsInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IDynamicRightsInterface>> outValue) NN_NOEXCEPT;
        nn::Result GetReadOnlyApplicationControlDataInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IReadOnlyApplicationControlDataInterface>> outValue) NN_NOEXCEPT;
        nn::Result GetReadOnlyApplicationRecordInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IReadOnlyApplicationRecordInterface>> outValue) NN_NOEXCEPT;
        nn::Result GetECommerceInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IECommerceInterface>> outValue) NN_NOEXCEPT;
        nn::Result GetApplicationVersionInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IApplicationVersionInterface>> outValue) NN_NOEXCEPT;
        nn::Result GetFactoryResetInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IFactoryResetInterface>> outValue) NN_NOEXCEPT;
        nn::Result GetAccountProxyInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAccountProxyInterface>> outValue) NN_NOEXCEPT;
        nn::Result GetApplicationManagerInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IApplicationManagerInterface>> outValue) NN_NOEXCEPT;
        nn::Result GetDownloadTaskInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IDownloadTaskInterface>> outValue) NN_NOEXCEPT;
        nn::Result GetContentManagementInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IContentManagementInterface>> outValue) NN_NOEXCEPT;
        nn::Result GetDocumentInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IDocumentInterface>> outValue) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetDynamicRightsInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IDynamicRightsInterface>> outValue) NN_NOEXCEPT;
    nn::Result GetReadOnlyApplicationControlDataInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IReadOnlyApplicationControlDataInterface>> outValue) NN_NOEXCEPT;
    nn::Result GetReadOnlyApplicationRecordInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IReadOnlyApplicationRecordInterface>> outValue) NN_NOEXCEPT;
    nn::Result GetECommerceInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IECommerceInterface>> outValue) NN_NOEXCEPT;
    nn::Result GetApplicationVersionInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IApplicationVersionInterface>> outValue) NN_NOEXCEPT;
    nn::Result GetFactoryResetInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IFactoryResetInterface>> outValue) NN_NOEXCEPT;
    nn::Result GetAccountProxyInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAccountProxyInterface>> outValue) NN_NOEXCEPT;
    nn::Result GetApplicationManagerInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IApplicationManagerInterface>> outValue) NN_NOEXCEPT;
    nn::Result GetDownloadTaskInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IDownloadTaskInterface>> outValue) NN_NOEXCEPT;
    nn::Result GetContentManagementInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IContentManagementInterface>> outValue) NN_NOEXCEPT;
    nn::Result GetDocumentInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IDocumentInterface>> outValue) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ns::detail::IServiceGetterInterface))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDynamicRightsInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IDynamicRightsInterface>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDynamicRightsInterface, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReadOnlyApplicationControlDataInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IReadOnlyApplicationControlDataInterface>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetReadOnlyApplicationControlDataInterface, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReadOnlyApplicationRecordInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IReadOnlyApplicationRecordInterface>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetReadOnlyApplicationRecordInterface, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetECommerceInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IECommerceInterface>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetECommerceInterface, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationVersionInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IApplicationVersionInterface>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetApplicationVersionInterface, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFactoryResetInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IFactoryResetInterface>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFactoryResetInterface, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAccountProxyInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAccountProxyInterface>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAccountProxyInterface, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationManagerInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IApplicationManagerInterface>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetApplicationManagerInterface, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDownloadTaskInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IDownloadTaskInterface>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDownloadTaskInterface, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetContentManagementInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IContentManagementInterface>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetContentManagementInterface, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDocumentInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IDocumentInterface>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDocumentInterface, (outValue));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ns::detail::IServiceGetterInterface>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ns::detail::IServiceGetterInterface))

    // nn::Result GetDynamicRightsInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IDynamicRightsInterface>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDynamicRightsInterface)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7988)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDynamicRightsInterface)

    // nn::Result GetReadOnlyApplicationControlDataInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IReadOnlyApplicationControlDataInterface>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetReadOnlyApplicationControlDataInterface)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7989)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetReadOnlyApplicationControlDataInterface)

    // nn::Result GetReadOnlyApplicationRecordInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IReadOnlyApplicationRecordInterface>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetReadOnlyApplicationRecordInterface)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7991)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetReadOnlyApplicationRecordInterface)

    // nn::Result GetECommerceInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IECommerceInterface>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetECommerceInterface)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7992)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetECommerceInterface)

    // nn::Result GetApplicationVersionInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IApplicationVersionInterface>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetApplicationVersionInterface)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7993)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetApplicationVersionInterface)

    // nn::Result GetFactoryResetInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IFactoryResetInterface>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFactoryResetInterface)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7994)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFactoryResetInterface)

    // nn::Result GetAccountProxyInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAccountProxyInterface>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAccountProxyInterface)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7995)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAccountProxyInterface)

    // nn::Result GetApplicationManagerInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IApplicationManagerInterface>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetApplicationManagerInterface)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7996)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetApplicationManagerInterface)

    // nn::Result GetDownloadTaskInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IDownloadTaskInterface>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDownloadTaskInterface)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7997)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDownloadTaskInterface)

    // nn::Result GetContentManagementInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IContentManagementInterface>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetContentManagementInterface)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7998)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetContentManagementInterface)

    // nn::Result GetDocumentInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IDocumentInterface>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDocumentInterface)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7999)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDocumentInterface)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ns::detail::IServiceGetterInterface, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ns::detail::IServiceGetterInterface))

    // nn::Result GetDynamicRightsInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IDynamicRightsInterface>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDynamicRightsInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IDynamicRightsInterface>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDynamicRightsInterface)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDynamicRightsInterface)
    }

    // nn::Result GetReadOnlyApplicationControlDataInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IReadOnlyApplicationControlDataInterface>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReadOnlyApplicationControlDataInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IReadOnlyApplicationControlDataInterface>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetReadOnlyApplicationControlDataInterface)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetReadOnlyApplicationControlDataInterface)
    }

    // nn::Result GetReadOnlyApplicationRecordInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IReadOnlyApplicationRecordInterface>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReadOnlyApplicationRecordInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IReadOnlyApplicationRecordInterface>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetReadOnlyApplicationRecordInterface)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetReadOnlyApplicationRecordInterface)
    }

    // nn::Result GetECommerceInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IECommerceInterface>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetECommerceInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IECommerceInterface>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetECommerceInterface)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetECommerceInterface)
    }

    // nn::Result GetApplicationVersionInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IApplicationVersionInterface>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationVersionInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IApplicationVersionInterface>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetApplicationVersionInterface)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetApplicationVersionInterface)
    }

    // nn::Result GetFactoryResetInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IFactoryResetInterface>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFactoryResetInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IFactoryResetInterface>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFactoryResetInterface)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFactoryResetInterface)
    }

    // nn::Result GetAccountProxyInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAccountProxyInterface>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAccountProxyInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAccountProxyInterface>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAccountProxyInterface)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAccountProxyInterface)
    }

    // nn::Result GetApplicationManagerInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IApplicationManagerInterface>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetApplicationManagerInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IApplicationManagerInterface>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetApplicationManagerInterface)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetApplicationManagerInterface)
    }

    // nn::Result GetDownloadTaskInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IDownloadTaskInterface>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDownloadTaskInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IDownloadTaskInterface>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDownloadTaskInterface)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDownloadTaskInterface)
    }

    // nn::Result GetContentManagementInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IContentManagementInterface>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetContentManagementInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IContentManagementInterface>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetContentManagementInterface)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetContentManagementInterface)
    }

    // nn::Result GetDocumentInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IDocumentInterface>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDocumentInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IDocumentInterface>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDocumentInterface)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDocumentInterface)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ns::detail::IServiceGetterInterface>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ns::detail::IServiceGetterInterface))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDynamicRightsInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IDynamicRightsInterface>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDynamicRightsInterface)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetReadOnlyApplicationControlDataInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IReadOnlyApplicationControlDataInterface>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetReadOnlyApplicationControlDataInterface)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetReadOnlyApplicationRecordInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IReadOnlyApplicationRecordInterface>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetReadOnlyApplicationRecordInterface)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetECommerceInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IECommerceInterface>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetECommerceInterface)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetApplicationVersionInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IApplicationVersionInterface>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetApplicationVersionInterface)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFactoryResetInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IFactoryResetInterface>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFactoryResetInterface)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAccountProxyInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAccountProxyInterface>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAccountProxyInterface)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetApplicationManagerInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IApplicationManagerInterface>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetApplicationManagerInterface)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDownloadTaskInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IDownloadTaskInterface>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDownloadTaskInterface)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetContentManagementInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IContentManagementInterface>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetContentManagementInterface)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDocumentInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IDocumentInterface>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDocumentInterface)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDynamicRightsInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetReadOnlyApplicationControlDataInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetReadOnlyApplicationRecordInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetECommerceInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetApplicationVersionInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFactoryResetInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAccountProxyInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetApplicationManagerInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDownloadTaskInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetContentManagementInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDocumentInterface)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ns::detail::IServiceGetterInterface))
