﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <array>

namespace nn{ namespace npns{

template<typename DefinitionT>
class StatisticsCollection : private std::array<int32_t, DefinitionT::Size>
{
    NN_DISALLOW_COPY(StatisticsCollection);
    NN_DISALLOW_MOVE(StatisticsCollection);
    typedef typename DefinitionT::Contents Contents;
    typedef std::array<int32_t, DefinitionT::Size> array;
    const size_t Size = DefinitionT::Size;

public:
    StatisticsCollection() NN_NOEXCEPT
    {
        this->fill(0);
    }
    void Increment(Contents index) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_RANGE(static_cast<int>(index), 0, static_cast<int>(Size));
        this->at(index)++;
    }
    void Add(Contents index, int32_t value) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_RANGE(static_cast<int>(index), 0, static_cast<int>(Size));
        this->at(index) += value;
    }
    int32_t GetValue(Contents index) const NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_RANGE(static_cast<int>(index), 0, static_cast<int>(Size));
        return this->at(index);
    }
    void ShowAll() const NN_NOEXCEPT
    {
        for (auto it = this->cbegin(); it != this->end(); ++it)
        {
            NN_SDK_LOG("%-40s: % 7d\n", GetName(it), *it);
        }
    }
    static const char* GetName(Contents index) NN_NOEXCEPT
    {
        return DefinitionT::GetString(index);
    }
    const char* GetName(typename array::const_iterator it) const NN_NOEXCEPT
    {
        auto diff = it - this->cbegin();
        return GetName(static_cast<Contents>(diff));
    }

    using array::begin;
    using array::end;
    using array::cbegin;
    using array::cend;
    using array::rbegin;
    using array::rend;
    using array::data;
};

}}


