﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn{ namespace npns{

enum StatisticsKind
{
    StatisticsKind_Online,
    StatisticsKind_Connect,
    StatisticsKind_ConnectHalfawake,
    StatisticsKind_Disconnect,
    StatisticsKind_ConnectError,
    StatisticsKind_ConnectionLost,
    StatisticsKind_ConnectionLostOffline,
    StatisticsKind_CheckArrival,
    StatisticsKind_CheckArrivalError,
    StatisticsKind_ReceiveNotification,
    StatisticsKind_ReceiveNotificationHalfawake,
    StatisticsKind_Fullawake,
    StatisticsKind_Halfawake,
    StatisticsKind_HalfawakeScheduled,
    StatisticsKind_HalfawakeSessionRecovered,
    StatisticsKind_Sleep,
    StatisticsKind_SleepStateSuspendTimeout,
    StatisticsKind_SleepStateConnectedOnHalfawakeTimeout,
    StatisticsKind_DurationHalfawake,
    StatisticsKind_PingPongSuccess,
    StatisticsKind_PingPongFailure,
    StatisticsKind_PingPongFailureThenConfirmationPass,
    StatisticsKind_Max
};

class StatisticsDefinition
{
public:
    typedef StatisticsKind Contents;
    static const size_t Size = StatisticsKind_Max;
    static const char* GetString(Contents index) NN_NOEXCEPT
    {
        switch (index)
        {
#define NN_NPNS_CASE_STRING(name) case StatisticsKind_##name: return #name
        NN_NPNS_CASE_STRING(Online);
        NN_NPNS_CASE_STRING(Connect);
        NN_NPNS_CASE_STRING(ConnectHalfawake);
        NN_NPNS_CASE_STRING(Disconnect);
        NN_NPNS_CASE_STRING(ConnectError);
        NN_NPNS_CASE_STRING(ConnectionLost);
        NN_NPNS_CASE_STRING(ConnectionLostOffline);
        NN_NPNS_CASE_STRING(CheckArrival);
        NN_NPNS_CASE_STRING(CheckArrivalError);
        NN_NPNS_CASE_STRING(ReceiveNotification);
        NN_NPNS_CASE_STRING(ReceiveNotificationHalfawake);
        NN_NPNS_CASE_STRING(Fullawake);
        NN_NPNS_CASE_STRING(Halfawake);
        NN_NPNS_CASE_STRING(HalfawakeScheduled);
        NN_NPNS_CASE_STRING(HalfawakeSessionRecovered);
        NN_NPNS_CASE_STRING(Sleep);
        NN_NPNS_CASE_STRING(SleepStateSuspendTimeout);
        NN_NPNS_CASE_STRING(SleepStateConnectedOnHalfawakeTimeout);
        NN_NPNS_CASE_STRING(DurationHalfawake);
        NN_NPNS_CASE_STRING(PingPongSuccess);
        NN_NPNS_CASE_STRING(PingPongFailure);
        NN_NPNS_CASE_STRING(PingPongFailureThenConfirmationPass);
        NN_NPNS_CASE_STRING(Max);
#undef  NN_NPNS_CASE_STRING
        default:
            break;
        }
        return "(unknown)";
    }
};

}}


