﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 *  @file
 *  @brief  プッシュ通知に関する API の宣言
 *
 *  :include nn/npns.h
 */


#pragma once


/**
 *  @namespace  nn::npns
 *  @brief      プッシュ通知ライブラリの名前空間です。
 *
 *              ### 機能概要
 *              プッシュ通知ライブラリは、任天堂が提供するプッシュ通知サーバから通知を受信したり、その受信のための各種設定を行うための API を提供します。
 *              アプリケーションやシステムサービスはプッシュ通知の受信をトリガにして、ダウンロード処理など実行コストの高い処理をタイムリーに行うことができます。@n
 *
 *              ### 共通の事前条件
 *              プッシュ通知ライブラリが提供する API を利用するには、個別に明示されていないかぎり、利用前に @ref nn::npns::Initialize 関数によってライブラリを初期化する必要があります。@n
 *
 *              ###
 *
 *              ### Windows 上での挙動と制限
 */

#include <nn/npns/npns_Api.h>

